/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.provider;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.provider.InternalLogger;

public final class MessageFormatter {
    private static final int INITIAL_STRING_BUFFER_CAPACITY = 256;
    private final DecimalFormatSymbols symbols;

    public MessageFormatter(Locale locale) {
        this.symbols = new DecimalFormatSymbols(locale);
    }

    public String format(String message, Object[] arguments) {
        StringBuilder builder = new StringBuilder(256);
        int argumentIndex = 0;
        int start = 0;
        int openingCurlyBrackets = 0;
        for (int index = 0; index < message.length(); ++index) {
            char character = message.charAt(index);
            if (character == '{') {
                if (openingCurlyBrackets++ != 0 || start >= index) continue;
                builder.append(message, start, index);
                start = index;
                continue;
            }
            if (character != '}' || openingCurlyBrackets <= 0 || --openingCurlyBrackets != 0) continue;
            if (argumentIndex < arguments.length) {
                Object argument;
                if ((argument = arguments[argumentIndex++]) instanceof Supplier) {
                    argument = ((Supplier)argument).get();
                }
                if (index == start + 1) {
                    builder.append(argument);
                } else {
                    builder.append(this.format(message.substring(start + 1, index), argument));
                }
            } else {
                builder.append(message, start, index + 1);
            }
            start = index + 1;
        }
        if (start < message.length()) {
            builder.append(message, start, message.length());
        }
        return builder.toString();
    }

    private String format(String pattern, Object argument) {
        try {
            return this.getFormatter(pattern, argument).format(argument);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.WARN, "Illegal argument '" + String.valueOf(argument) + "' for pattern '" + pattern + "'");
            return String.valueOf(argument);
        }
    }

    private Format getFormatter(String pattern, Object argument) {
        if (pattern.indexOf(124) != -1) {
            int start = pattern.indexOf(123);
            if (start >= 0 && start < pattern.lastIndexOf(125)) {
                return new ChoiceFormat(this.format(pattern, new Object[]{argument}));
            }
            return new ChoiceFormat(pattern);
        }
        return new DecimalFormat(pattern, this.symbols);
    }
}

