/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.provider;

import java.util.Collection;
import java.util.ServiceLoader;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.provider.BundleLoggingProvider;
import org.tinylog.provider.InternalLogger;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.NopLoggingProvider;
import org.tinylog.runtime.RuntimeProvider;

public final class ProviderRegistry {
    private static final String PROVIDER_PROPERTY = "provider";
    private static final String NOP_PROVIDER_NAME = "nop";
    private static final LoggingProvider loggingProvider = ProviderRegistry.loadLoggingProvider();

    private ProviderRegistry() {
    }

    public static LoggingProvider getLoggingProvider() {
        return loggingProvider;
    }

    private static LoggingProvider loadLoggingProvider() {
        if (RuntimeProvider.getProcessId() == Long.MIN_VALUE) {
            ServiceLoader.load(LoggingProvider.class);
        }
        org.tinylog.configuration.ServiceLoader<LoggingProvider> loader = new org.tinylog.configuration.ServiceLoader<LoggingProvider>(LoggingProvider.class, new Class[0]);
        String name = Configuration.get(PROVIDER_PROPERTY);
        if (name == null) {
            Collection<LoggingProvider> providers = loader.createAll(new Object[0]);
            switch (providers.size()) {
                case 0: {
                    InternalLogger.log(Level.WARN, "No logging framework implementation found in classpath. Add tinylog-impl.jar for outputting log entries.");
                    return new NopLoggingProvider();
                }
                case 1: {
                    return providers.iterator().next();
                }
            }
            return new BundleLoggingProvider(providers);
        }
        if (NOP_PROVIDER_NAME.equalsIgnoreCase(name)) {
            return new NopLoggingProvider();
        }
        LoggingProvider provider = loader.create(name, new Object[0]);
        if (provider == null) {
            InternalLogger.log(Level.ERROR, "Requested logging provider is not available. Logging will be disabled.");
            return new NopLoggingProvider();
        }
        return provider;
    }
}

