/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.runtime;

import android.os.Process;
import dalvik.system.VMStack;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.tinylog.Level;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.LegacyTimestamp;
import org.tinylog.runtime.LegacyTimestampFormatter;
import org.tinylog.runtime.RuntimeDialect;
import org.tinylog.runtime.Timestamp;
import org.tinylog.runtime.TimestampFormatter;

final class AndroidRuntime
implements RuntimeDialect {
    private static final int STACK_TRACE_SIZE = 10;
    private static final Timestamp startTime = new LegacyTimestamp();
    private final Method stackTraceElementsFiller;
    private final int stackTraceOffset;

    AndroidRuntime() {
        StackTraceElementsFiller filler = AndroidRuntime.getStackTraceElementsFiller();
        this.stackTraceElementsFiller = filler.method;
        this.stackTraceOffset = filler.index;
    }

    @Override
    public boolean isAndroid() {
        return true;
    }

    @Override
    public String getDefaultWriter() {
        return "logcat";
    }

    @Override
    public long getProcessId() {
        return Process.myPid();
    }

    @Override
    public Timestamp getStartTime() {
        return startTime;
    }

    @Override
    public String getCallerClassName(int depth) {
        return this.getCallerStackTraceElement(depth + 1).getClassName();
    }

    @Override
    public String getCallerClassName(String loggerClassName) {
        return this.getCallerStackTraceElement(loggerClassName).getClassName();
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(int depth) {
        StackTraceElement[] trace = this.extractCallerStackTraceElements(depth + this.stackTraceOffset + 1);
        return trace == null ? new Throwable().getStackTrace()[depth] : trace[trace.length - 1];
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(String loggerClassName) {
        StackTraceElement element;
        StackTraceElement[] trace = this.extractCallerStackTraceElements(this.stackTraceOffset + 10);
        if (trace != null && (element = AndroidRuntime.findStackTraceElement(loggerClassName, trace)) != null) {
            return element;
        }
        element = AndroidRuntime.findStackTraceElement(loggerClassName, new Throwable().getStackTrace());
        if (element == null) {
            throw new IllegalStateException("Logger class \"" + loggerClassName + "\" is missing in stack trace");
        }
        return element;
    }

    @Override
    public Timestamp createTimestamp() {
        return new LegacyTimestamp();
    }

    @Override
    public TimestampFormatter createTimestampFormatter(String pattern, Locale locale) {
        return new LegacyTimestampFormatter(pattern, locale);
    }

    private static StackTraceElementsFiller getStackTraceElementsFiller() {
        try {
            Method method = VMStack.class.getDeclaredMethod("fillStackTraceElements", Thread.class, StackTraceElement[].class);
            method.setAccessible(true);
            StackTraceElement[] trace = new StackTraceElement[10];
            method.invoke(null, Thread.currentThread(), trace);
            for (int i = 0; i < 10; ++i) {
                StackTraceElement element = trace[i];
                if (element == null || !AndroidRuntime.class.getName().equals(element.getClassName()) || !"getStackTraceElementsFiller".equals(element.getMethodName())) continue;
                return new StackTraceElementsFiller(method, i);
            }
            return new StackTraceElementsFiller(null, -1);
        }
        catch (NoClassDefFoundError error) {
            return new StackTraceElementsFiller(null, -1);
        }
        catch (Exception ex) {
            return new StackTraceElementsFiller(null, -1);
        }
    }

    private static StackTraceElement findStackTraceElement(String loggerClassName, StackTraceElement[] trace) {
        int index;
        for (index = 0; index < trace.length && !loggerClassName.equals(trace[index].getClassName()); ++index) {
        }
        while (index < trace.length && loggerClassName.equals(trace[index].getClassName())) {
            ++index;
        }
        if (index < trace.length) {
            return trace[index];
        }
        return null;
    }

    private StackTraceElement[] extractCallerStackTraceElements(int count) {
        if (this.stackTraceElementsFiller != null) {
            try {
                StackTraceElement[] trace = new StackTraceElement[count + 1];
                this.stackTraceElementsFiller.invoke(null, Thread.currentThread(), trace);
                return trace;
            }
            catch (IllegalAccessException ex) {
                InternalLogger.log(Level.ERROR, ex, "Failed getting stack trace element from dalvik.system.VMStack");
            }
            catch (InvocationTargetException ex) {
                InternalLogger.log(Level.ERROR, ex.getTargetException(), "Failed getting stack trace element from dalvik.system.VMStack");
            }
        }
        return null;
    }

    private static final class StackTraceElementsFiller {
        private final Method method;
        private final int index;

        private StackTraceElementsFiller(Method method, int index) {
            this.method = method;
            this.index = index;
        }
    }
}

