/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

class MaximumSizeToken
implements Token {
    private final Token token;
    private final int maximumSize;

    MaximumSizeToken(Token token, int size) {
        this.token = token;
        this.maximumSize = size;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return this.token.getRequiredLogEntryValues();
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        int offset = builder.length();
        this.token.render(logEntry, builder);
        int size = builder.length() - offset;
        if (size > this.maximumSize) {
            builder.delete(offset, offset + size - this.maximumSize);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        StringBuilder builder = new StringBuilder();
        this.render(logEntry, builder);
        statement.setString(index, builder.toString());
    }
}

