/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class ThreadContextToken
implements Token {
    private static final String DEFAULT_EMPTY_VALUE = "";
    private static final String DELIMITER = ", ";
    private static final String SEPARATOR = "=";
    private final String key;
    private final String defaultValue;

    ThreadContextToken() {
        this.key = null;
        this.defaultValue = DEFAULT_EMPTY_VALUE;
    }

    ThreadContextToken(String key) {
        this.key = key;
        this.defaultValue = DEFAULT_EMPTY_VALUE;
    }

    ThreadContextToken(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singletonList(LogEntryValue.CONTEXT);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        if (this.key != null) {
            String value = logEntry.getContext().get(this.key);
            if (value == null) {
                builder.append(this.defaultValue);
            } else {
                builder.append(value);
            }
        } else {
            TreeMap<String, String> sortedContext = new TreeMap<String, String>(logEntry.getContext());
            boolean first = true;
            for (Map.Entry contextEntry : sortedContext.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(DELIMITER);
                }
                builder.append((String)contextEntry.getKey()).append(SEPARATOR).append((String)contextEntry.getValue());
            }
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        if (this.key == null || this.key.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            this.render(logEntry, builder);
            statement.setString(index, builder.toString());
        } else {
            String value = logEntry.getContext().get(this.key);
            if (value == null && !DEFAULT_EMPTY_VALUE.equals(this.defaultValue)) {
                statement.setString(index, this.defaultValue);
            } else {
                statement.setString(index, value);
            }
        }
    }
}

