/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.deployment;

import java.util.function.BiFunction;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class EntityServiceBuilderEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private String entityClass;
    private String entityName;

    public EntityServiceBuilderEnhancer(String entityName, String entityClass) {
        this.entityClass = entityClass;
        this.entityName = entityName;
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new EntityServiceBuilderEnhancerClassVisitor(className, outputClassVisitor, this.entityName, this.entityClass);
    }

    static class EntityServiceBuilderEnhancerClassVisitor
    extends ClassVisitor {
        private String entityClass;
        private String entityName;

        public EntityServiceBuilderEnhancerClassVisitor(String className, ClassVisitor outputClassVisitor, String entityName, String entityClass) {
            super(458752, outputClassVisitor);
            this.entityClass = entityClass.replace('.', '/');
            this.entityName = entityName;
        }

        public void visitEnd() {
            MethodVisitor mv1 = super.visitMethod(4161, "getEntityClass", "()Ljava/lang/Class;", null, null);
            mv1.visitCode();
            mv1.visitLdcInsn((Object)Type.getType((String)("L" + this.entityClass + ";")));
            mv1.visitInsn(176);
            mv1.visitMaxs(0, 0);
            mv1.visitEnd();
            MethodVisitor mv = super.visitMethod(4161, "getEntityName", "()Ljava/lang/String;", null, null);
            mv.visitCode();
            mv.visitLdcInsn((Object)this.entityName);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            super.visitEnd();
        }
    }
}

