/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.StaticMetamodel;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.tkit.quarkus.jpa.daos.AbstractDAO;
import org.tkit.quarkus.jpa.deployment.EntityServiceBuilderEnhancer;

public class JPABuild {
    private static final String FEATURE_NAME = "tkit-jpa";
    private static final DotName DOT_NAME_REPOSITORY = DotName.createSimple((String)AbstractDAO.class.getName());
    private static final DotName ENTITY = DotName.createSimple((String)Entity.class.getName());
    private static final DotName DOT_NAME_ENTITY_MANAGER = DotName.createSimple((String)EntityManager.class.getName());
    private static final String ATTRIBUTE_NAME = "name";

    @BuildStep
    FeatureBuildItem createFeatureItem() {
        return new FeatureBuildItem(FEATURE_NAME);
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(DOT_NAME_ENTITY_MANAGER));
    }

    @BuildStep
    void build(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOT_NAME_REPOSITORY)) {
            List annotations;
            if (classInfo.superClassType().kind() != Type.Kind.PARAMETERIZED_TYPE) continue;
            Type entity = (Type)classInfo.superClassType().asParameterizedType().arguments().get(0);
            ClassInfo ec = index.getIndex().getClassByName(entity.name());
            String name = entity.name().withoutPackagePrefix();
            if (ec.annotations() != null && (annotations = (List)ec.annotations().get(ENTITY)) != null && !annotations.isEmpty()) {
                AnnotationInstance annotationInstance = (AnnotationInstance)annotations.get(0);
                for (AnnotationValue a : annotationInstance.values()) {
                    if (!ATTRIBUTE_NAME.equals(a.name())) continue;
                    name = a.asString();
                }
            }
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)new EntityServiceBuilderEnhancer(name, entity.name().toString())));
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    public void test(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflective) {
        String[] metamodelClasses;
        Collection annos = index.getIndex().getAnnotations(DotName.createSimple((String)StaticMetamodel.class.getName()));
        if (annos != null && (metamodelClasses = (String[])annos.stream().map(a -> a.target().asClass().toString()).toArray(String[]::new)).length > 0) {
            reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, false, true, metamodelClasses));
        }
    }
}

