/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.daos;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.jpa.daos.EntityService;
import org.tkit.quarkus.jpa.daos.Page;
import org.tkit.quarkus.jpa.daos.PagedQuery;
import org.tkit.quarkus.jpa.exceptions.ConstraintException;
import org.tkit.quarkus.jpa.exceptions.DAOException;
import org.tkit.quarkus.jpa.models.AbstractTraceableEntity;

public abstract class AbstractDAO<T extends AbstractTraceableEntity<?>>
implements EntityService {
    private static final Logger log = LoggerFactory.getLogger(AbstractDAO.class);
    protected static final String HINT_LOAD_GRAPH = "javax.persistence.loadgraph";
    private static final String ID = "id";
    @Inject
    protected EntityManager em;
    protected Class<T> entityClass;
    protected String entityName;

    @PostConstruct
    public void init() {
        String serviceClass = this.getClass().getName();
        this.entityClass = this.getEntityClass();
        this.entityName = this.getEntityName();
        log.debug("Initialize the entity service {} for entity {}/{}", new Object[]{serviceClass, this.entityClass, this.entityName});
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public PagedQuery<T> createPageQuery(CriteriaQuery<T> query, Page page) {
        return new PagedQuery<T>(this.em, query, page);
    }

    public <E> PagedQuery<E> createPageQueryCustom(CriteriaQuery<E> query, Page page) {
        return new PagedQuery<E>(this.em, query, page);
    }

    public Stream<T> findAll() throws DAOException {
        return this.findAll(null);
    }

    public Stream<T> findAll(EntityGraph<?> entityGraph) throws DAOException {
        try {
            CriteriaQuery<T> cq = this.criteriaQuery();
            cq.from(this.entityClass);
            cq.distinct(true);
            TypedQuery query = this.getEntityManager().createQuery(cq);
            if (entityGraph != null) {
                query.setHint(HINT_LOAD_GRAPH, entityGraph);
            }
            return query.getResultStream();
        }
        catch (Exception e) {
            throw new DAOException(Errors.FIND_ALL_ENTITIES_FAILED, (Throwable)e, this.entityName, entityGraph == null ? null : entityGraph.getName());
        }
    }

    @Transactional(value=Transactional.TxType.SUPPORTS, rollbackOn={DAOException.class})
    public T findById(Object id) throws DAOException {
        try {
            return (T)((AbstractTraceableEntity)this.getEntityManager().find(this.entityClass, id));
        }
        catch (Exception e) {
            throw new DAOException(Errors.FIND_ENTITY_BY_ID_FAILED, (Throwable)e, this.entityName, id);
        }
    }

    @Transactional(value=Transactional.TxType.SUPPORTS, rollbackOn={DAOException.class})
    public T findById(Object id, EntityGraph<?> entityGraph) throws DAOException {
        try {
            return (T)((AbstractTraceableEntity)this.getEntityManager().find(this.entityClass, id, Collections.singletonMap(HINT_LOAD_GRAPH, entityGraph)));
        }
        catch (Exception e) {
            throw new DAOException(Errors.FIND_ENTITY_BY_ID_FAILED, (Throwable)e, this.entityName, id, entityGraph == null ? null : entityGraph.getName());
        }
    }

    @Transactional(value=Transactional.TxType.SUPPORTS, rollbackOn={DAOException.class})
    public Stream<T> findByIds(List<Object> ids) throws DAOException {
        return this.findByIds(ids, null);
    }

    public Stream<T> findByIds(List<Object> ids, EntityGraph<?> entityGraph) throws DAOException {
        try {
            if (ids != null && !ids.isEmpty()) {
                CriteriaQuery<T> cq = this.criteriaQuery();
                cq.where((Expression)cq.from(this.entityClass).get(ID).in(ids));
                TypedQuery query = this.getEntityManager().createQuery(cq);
                if (entityGraph != null) {
                    query.setHint(HINT_LOAD_GRAPH, entityGraph);
                }
                return query.getResultStream();
            }
            return Stream.empty();
        }
        catch (Exception e) {
            throw new DAOException(Errors.FAILED_TO_GET_ENTITY_BY_IDS, (Throwable)e, this.entityName, entityGraph == null ? null : entityGraph.getName());
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public T update(T entity) throws DAOException {
        try {
            AbstractTraceableEntity result = (AbstractTraceableEntity)this.getEntityManager().merge(entity);
            this.getEntityManager().flush();
            return (T)result;
        }
        catch (Exception e) {
            throw this.handleConstraint(e, Errors.MERGE_ENTITY_FAILED);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public Stream<T> update(Stream<T> entities) throws DAOException {
        if (entities != null) {
            try {
                Stream<AbstractTraceableEntity> result = entities.map(arg_0 -> ((EntityManager)this.getEntityManager()).merge(arg_0));
                this.getEntityManager().flush();
                return result;
            }
            catch (Exception e) {
                throw this.handleConstraint(e, Errors.MERGE_ENTITY_FAILED);
            }
        }
        return Stream.empty();
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public Stream<T> update(List<T> entities) throws DAOException {
        if (entities != null) {
            return this.update(entities.stream());
        }
        return Stream.empty();
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public T create(T entity) throws DAOException {
        try {
            this.getEntityManager().persist(entity);
            this.getEntityManager().flush();
        }
        catch (Exception e) {
            throw this.handleConstraint(e, Errors.PERSIST_ENTITY_FAILED);
        }
        return entity;
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public Stream<T> create(List<T> entities) throws DAOException {
        if (entities != null) {
            return this.create(entities.stream());
        }
        return Stream.empty();
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public Stream<T> create(Stream<T> entities) throws DAOException {
        if (entities != null) {
            try {
                entities.forEach(arg_0 -> ((EntityManager)this.getEntityManager()).persist(arg_0));
                this.getEntityManager().flush();
            }
            catch (Exception e) {
                throw this.handleConstraint(e, Errors.PERSIST_ENTITY_FAILED);
            }
        }
        return Stream.empty();
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public void delete(T entity) throws DAOException {
        try {
            this.getEntityManager().remove(entity);
            this.getEntityManager().flush();
        }
        catch (Exception e) {
            throw this.handleConstraint(e, Errors.DELETE_ENTITY_FAILED);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public void delete(List<T> entities) throws DAOException {
        if (entities != null && !entities.isEmpty()) {
            this.delete(entities.stream());
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public void delete(Stream<T> entities) throws DAOException {
        if (entities != null && entities.findAny().isPresent()) {
            entities.forEach(arg_0 -> ((EntityManager)this.getEntityManager()).remove(arg_0));
            this.getEntityManager().flush();
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public void deleteAll() throws DAOException {
        try {
            Stream<T> tmp = this.findAll();
            this.delete(tmp);
        }
        catch (Exception e) {
            throw new DAOException(Errors.FAILED_TO_DELETE_ALL, (Throwable)e, this.entityName);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public int deleteQueryAll() throws DAOException {
        try {
            CriteriaQuery<T> cq = this.criteriaQuery();
            cq.from(this.entityClass);
            int result = this.getEntityManager().createQuery(cq).executeUpdate();
            this.getEntityManager().flush();
            return result;
        }
        catch (Exception e) {
            throw this.handleConstraint(e, Errors.FAILED_TO_DELETE_ALL_QUERY);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public boolean deleteQueryById(Object id) throws DAOException {
        if (id != null) {
            try {
                CriteriaDelete<T> cq = this.deleteQuery();
                cq.where((Expression)this.getEntityManager().getCriteriaBuilder().equal((Expression)cq.from(this.entityClass).get(ID), id));
                int count = this.getEntityManager().createQuery(cq).executeUpdate();
                this.getEntityManager().flush();
                return count == 1;
            }
            catch (Exception e) {
                throw this.handleConstraint(e, Errors.FAILED_TO_DELETE_BY_GUID_QUERY);
            }
        }
        return false;
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={DAOException.class})
    public int deleteQueryByIds(List<Object> ids) throws DAOException {
        try {
            if (ids != null && !ids.isEmpty()) {
                CriteriaDelete<T> cq = this.deleteQuery();
                cq.where((Expression)cq.from(this.entityClass).get(ID).in(ids));
                int result = this.getEntityManager().createQuery(cq).executeUpdate();
                this.getEntityManager().flush();
                return result;
            }
        }
        catch (Exception e) {
            throw this.handleConstraint(e, Errors.FAILED_TO_DELETE_ALL_BY_IDS_QUERY);
        }
        return 0;
    }

    protected Query createNamedQuery(String namedQuery, Map<String, Object> parameters) {
        Query query = this.getEntityManager().createNamedQuery(namedQuery);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        }
        return query;
    }

    protected void refresh(T entity) {
        this.getEntityManager().refresh(entity);
    }

    protected void lock(T entity, LockModeType lockMode) {
        this.getEntityManager().lock(entity, lockMode);
    }

    protected DAOException handleConstraint(Exception ex, Enum<?> key) {
        Throwable providerException;
        PersistenceException e;
        if (ex instanceof ConstraintException) {
            return (ConstraintException)ex;
        }
        if (ex instanceof PersistenceException && (e = (PersistenceException)ex).getCause() != null && "org.hibernate.exception.ConstraintViolationException".equals((providerException = e.getCause()).getClass().getName())) {
            String msg = providerException.getMessage();
            if (providerException.getCause() != null && (msg = providerException.getCause().getMessage()) != null) {
                msg = msg.replaceAll("\n", "");
            }
            return new ConstraintException(msg, key, (Throwable)e, new Serializable[]{this.entityName});
        }
        return new DAOException(key, (Throwable)ex, this.entityName);
    }

    protected CriteriaQuery<T> criteriaQuery() {
        return this.getEntityManager().getCriteriaBuilder().createQuery(this.entityClass);
    }

    protected CriteriaDelete<T> deleteQuery() {
        return this.getEntityManager().getCriteriaBuilder().createCriteriaDelete(this.entityClass);
    }

    protected CriteriaUpdate<T> updateQuery() {
        return this.getEntityManager().getCriteriaBuilder().createCriteriaUpdate(this.entityClass);
    }

    protected static enum Errors {
        FAILED_TO_GET_ENTITY_BY_IDS,
        FAILED_TO_DELETE_ALL,
        FAILED_TO_DELETE_ALL_QUERY,
        FAILED_TO_DELETE_BY_GUID_QUERY,
        FAILED_TO_DELETE_ALL_BY_IDS_QUERY,
        PERSIST_ENTITY_FAILED,
        MERGE_ENTITY_FAILED,
        DELETE_ENTITY_FAILED,
        FIND_ENTITY_BY_ID_FAILED,
        FIND_ALL_ENTITIES_FAILED;

    }
}

