/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.models;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.time.LocalDateTime;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;

@MappedSuperclass
public abstract class AbstractTraceableEntity<T>
implements Serializable {
    private static final long serialVersionUID = -8041083748062531412L;
    @Version
    @Column(name="OPTLOCK", nullable=false)
    private Integer version;
    private LocalDateTime creationDate;
    private String creationUser;
    private LocalDateTime modificationDate;
    private String modificationUser;
    @Transient
    protected boolean persisted;
    @Transient
    private boolean controlTraceabilityManual = false;

    @PrePersist
    public void prePersist() {
        if (!this.isControlTraceabilityManual()) {
            Instance principalInstance = CDI.current().select(Principal.class, new Annotation[0]);
            if (principalInstance.isResolvable()) {
                this.setCreationUser(((Principal)principalInstance.get()).getName());
                this.setModificationUser(this.getCreationUser());
            }
            this.setCreationDate(LocalDateTime.now());
            this.setModificationDate(this.getCreationDate());
        }
    }

    @PreUpdate
    public void preUpdate() {
        if (!this.isControlTraceabilityManual()) {
            Instance principalInstance = CDI.current().select(Principal.class, new Annotation[0]);
            if (principalInstance.isResolvable()) {
                this.setModificationUser(((Principal)principalInstance.get()).getName());
            }
            this.setModificationDate(LocalDateTime.now());
        }
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationUser() {
        return this.creationUser;
    }

    public void setCreationUser(String creationUser) {
        this.creationUser = creationUser;
    }

    public LocalDateTime getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(LocalDateTime modificationDate) {
        this.modificationDate = modificationDate;
    }

    public String getModificationUser() {
        return this.modificationUser;
    }

    public void setModificationUser(String modificationUser) {
        this.modificationUser = modificationUser;
    }

    public boolean isControlTraceabilityManual() {
        return this.controlTraceabilityManual;
    }

    public void setControlTraceabilityManual(boolean controlTraceabilityManual) {
        this.controlTraceabilityManual = controlTraceabilityManual;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public abstract T getId();

    public abstract void setId(T var1);

    @PostLoad
    @PostUpdate
    @PostPersist
    public void checkPersistentState() {
        this.persisted = true;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getId();
    }
}

