/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.cdi;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.tkit.quarkus.log.cdi.LogService;
import org.tkit.quarkus.log.cdi.interceptor.LogParamValueService;
import org.tkit.quarkus.log.cdi.runtime.LogBuildTimeConfig;
import org.tkit.quarkus.log.cdi.runtime.LogRecorder;

public class LogProcessor {
    static final String FEATURE_NAME = "tkit-cdi-log";
    private static final Logger log = Logger.getLogger(LogProcessor.class);
    private static final String LOG_BUILDER_SERVICE = LogParamValueService.class.getName();
    private static final List<DotName> ANNOTATION_DOT_NAMES = List.of(DotName.createSimple((String)ApplicationScoped.class.getName()), DotName.createSimple((String)Singleton.class.getName()), DotName.createSimple((String)RequestScoped.class.getName()));
    LogBuildTimeConfig buildConfig;

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(FEATURE_NAME);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureRuntimeProperties(LogRecorder recorder, BeanContainerBuildItem beanContainer) {
        BeanContainer container = beanContainer.getValue();
        recorder.init(container);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(BuildProducer<FeatureBuildItem> feature, LogRecorder recorder) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem(FEATURE_NAME));
    }

    @BuildStep
    public AnnotationsTransformerBuildItem interceptorBinding() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){
            private Pattern ignorePattern;
            {
                this.ignorePattern = LogProcessor.this.buildConfig.ignorePattern.isPresent() ? Pattern.compile((String)LogProcessor.this.buildConfig.ignorePattern.get()) : null;
            }

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return !LogProcessor.this.buildConfig.disable && kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo target = context.getTarget().asClass();
                Map tmp = target.annotations();
                Optional<DotName> dot = ANNOTATION_DOT_NAMES.stream().filter(tmp::containsKey).findFirst();
                if (dot.isPresent()) {
                    String name = target.name().toString();
                    Optional<String> add = LogProcessor.this.buildConfig.packages.stream().filter(name::startsWith).findFirst();
                    if (add.isPresent() && !LOG_BUILDER_SERVICE.equals(name) && !this.matchesIgnorePattern(name)) {
                        ((Transformation)context.transform().add(LogService.class, new AnnotationValue[0])).done();
                    }
                }
            }

            private boolean matchesIgnorePattern(String name) {
                if (LogProcessor.this.buildConfig.ignorePattern.isEmpty() || ((String)LogProcessor.this.buildConfig.ignorePattern.get()).isBlank()) {
                    return false;
                }
                boolean matches = this.ignorePattern.matcher(name).matches();
                if (matches) {
                    log.infof("Disabling tkit logs on: {%s} because it matches the ignore pattern: '%s' (set via 'tkit.log.ignore.pattern')", (Object)name, (Object)LogProcessor.this.buildConfig.ignorePattern);
                }
                return matches;
            }
        });
    }
}

