/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.cdi.interceptor;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class JavaTypesLogParamValue {
    public static Map<Class<?>, Function<Object, String>> assignableFrom() {
        HashMap result = new HashMap();
        result.put(Collection.class, JavaTypesLogParamValue::collection);
        result.put(InputStream.class, JavaTypesLogParamValue::inputStream);
        result.put(Map.class, JavaTypesLogParamValue::map);
        result.put(OutputStream.class, JavaTypesLogParamValue::outputStream);
        result.put(Stream.class, JavaTypesLogParamValue::stream);
        return result;
    }

    public static Map<Class<?>, Function<Object, String>> classes() {
        HashMap result = new HashMap();
        result.put(Class[].class, JavaTypesLogParamValue::array);
        result.put(int[].class, JavaTypesLogParamValue::array);
        result.put(double[].class, JavaTypesLogParamValue::array);
        result.put(float[].class, JavaTypesLogParamValue::array);
        result.put(boolean[].class, JavaTypesLogParamValue::array);
        result.put(long[].class, JavaTypesLogParamValue::array);
        result.put(byte[].class, JavaTypesLogParamValue::array);
        result.put(Integer[].class, JavaTypesLogParamValue::array);
        result.put(Double[].class, JavaTypesLogParamValue::array);
        result.put(String[].class, JavaTypesLogParamValue::array);
        result.put(Boolean[].class, JavaTypesLogParamValue::array);
        result.put(Long[].class, JavaTypesLogParamValue::array);
        result.put(Byte[].class, JavaTypesLogParamValue::array);
        result.put(Class.class, JavaTypesLogParamValue::basic);
        result.put(Byte.TYPE, JavaTypesLogParamValue::basic);
        result.put(Integer.TYPE, JavaTypesLogParamValue::basic);
        result.put(Double.TYPE, JavaTypesLogParamValue::basic);
        result.put(Float.TYPE, JavaTypesLogParamValue::basic);
        result.put(Boolean.TYPE, JavaTypesLogParamValue::basic);
        result.put(Long.TYPE, JavaTypesLogParamValue::basic);
        result.put(Integer.class, JavaTypesLogParamValue::basic);
        result.put(Double.class, JavaTypesLogParamValue::basic);
        result.put(String.class, JavaTypesLogParamValue::basic);
        result.put(Boolean.class, JavaTypesLogParamValue::basic);
        result.put(Long.class, JavaTypesLogParamValue::basic);
        result.put(Byte.class, JavaTypesLogParamValue::basic);
        result.put(Enum.class, JavaTypesLogParamValue::enumeration);
        result.put(HashMap.class, JavaTypesLogParamValue::map);
        result.put(HashSet.class, JavaTypesLogParamValue::collection);
        result.put(ArrayList.class, JavaTypesLogParamValue::collection);
        return result;
    }

    public static String basic(Object parameter) {
        return "" + parameter;
    }

    public static String array(Object parameter) {
        return parameter.getClass().getSimpleName() + "[" + Array.getLength(parameter) + "]";
    }

    public static String enumeration(Object parameter) {
        return parameter.getClass().getSimpleName() + ":" + parameter.toString();
    }

    public static String inputStream(Object parameter) {
        return parameter.getClass().getSimpleName();
    }

    public static String outputStream(Object parameter) {
        return parameter.getClass().getSimpleName();
    }

    public static String map(Object parameter) {
        StringBuilder sb = new StringBuilder();
        String name = parameter.getClass().getSimpleName();
        Map tmp = (Map)parameter;
        if (tmp.isEmpty()) {
            sb.append("empty ").append(name);
        } else {
            sb.append(name).append(' ').append(tmp.size()).append(" of [");
            String keyClassName = null;
            String valueClassName = null;
            if (parameter.getClass().getGenericSuperclass() instanceof ParameterizedType) {
                Type valueType;
                ParameterizedType parameterizedType = (ParameterizedType)parameter.getClass().getGenericSuperclass();
                Type keyType = parameterizedType.getActualTypeArguments()[0];
                if (!(keyType instanceof TypeVariable)) {
                    keyClassName = keyType.getClass().getSimpleName();
                }
                if (!((valueType = parameterizedType.getActualTypeArguments()[1]) instanceof TypeVariable)) {
                    keyClassName = valueType.getClass().getSimpleName();
                }
            }
            Map.Entry item = tmp.entrySet().iterator().next();
            if (keyClassName == null && item.getKey() != null) {
                keyClassName = item.getKey().getClass().getSimpleName();
            }
            if (item.getValue() != null) {
                valueClassName = item.getValue().getClass().getSimpleName();
            }
            sb.append(keyClassName).append('+').append(valueClassName).append(']');
        }
        return sb.toString();
    }

    public static String collection(Object parameter) {
        Collection tmp = (Collection)parameter;
        String name = tmp.getClass().getSimpleName();
        StringBuilder sb = new StringBuilder();
        if (tmp.isEmpty()) {
            sb.append("empty ").append(name);
        } else {
            sb.append(name).append('(').append(tmp.size());
            Class clazz = Object.class;
            if (parameter.getClass().getGenericSuperclass() instanceof ParameterizedType) {
                Object obj;
                ParameterizedType parameterizedType = (ParameterizedType)parameter.getClass().getGenericSuperclass();
                Type type = parameterizedType.getActualTypeArguments()[0];
                clazz = type.getClass();
                if (type instanceof TypeVariable && (obj = tmp.iterator().next()) != null) {
                    clazz = obj.getClass();
                }
            } else {
                Object obj = tmp.iterator().next();
                if (obj != null) {
                    clazz = obj.getClass();
                }
            }
            sb.append(clazz.getSimpleName());
            sb.append(')');
        }
        return sb.toString();
    }

    public static String stream(Object parameter) {
        return parameter.getClass().getSimpleName();
    }
}

