/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.cdi.interceptor;

import java.text.FieldPosition;
import java.text.MessageFormat;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.tkit.quarkus.log.cdi.interceptor.InterceptorContext;

public class LogConfig {
    static final String RESULT_VOID;
    private static MessageFormat messageStart;
    private static MessageFormat messageSucceed;
    private static MessageFormat messageFutureStart;
    private static MessageFormat messageFailed;

    private LogConfig() {
    }

    static Object msgFailed(InterceptorContext context) {
        return LogConfig.msg(messageFailed, new Object[]{context.method, context.parameters, context.result, context.time});
    }

    static Object msgSucceed(InterceptorContext context) {
        return LogConfig.msg(messageSucceed, new Object[]{context.method, context.parameters, context.result, context.time});
    }

    static Object msgFutureStart(InterceptorContext context) {
        return LogConfig.msg(messageFutureStart, new Object[]{context.method, context.parameters, context.result, context.time});
    }

    static Object msgStart(InterceptorContext context) {
        return LogConfig.msg(messageStart, new Object[]{context.method, context.parameters});
    }

    public static Object msg(final MessageFormat mf, final Object[] parameters) {
        return new Object(){

            public String toString() {
                return mf.format(parameters, new StringBuffer(), (FieldPosition)null).toString();
            }
        };
    }

    static {
        Config config = ConfigProvider.getConfig();
        RESULT_VOID = config.getOptionalValue("org.tkit.logger.result.void", String.class).orElse("void");
        messageStart = new MessageFormat(config.getOptionalValue("org.tkit.logger.start", String.class).orElse("{0}({1}) started."));
        messageSucceed = new MessageFormat(config.getOptionalValue("org.tkit.logger.succeed", String.class).orElse("{0}({1}):{2} [{3}s] succeed."));
        messageFailed = new MessageFormat(config.getOptionalValue("org.tkit.logger.failed", String.class).orElse("{0}({1}):{2} [{3}s] failed."));
        messageFutureStart = new MessageFormat(config.getOptionalValue("org.tkit.logger.futureStart", String.class).orElse("{0}({1}) future started."));
    }
}

