/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.cdi.interceptor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.tkit.quarkus.log.cdi.LogParamValue;
import org.tkit.quarkus.log.cdi.interceptor.JavaTypesLogParamValue;

@Singleton
public class LogParamValueService {
    public static Map<Class<?>, Function<Object, String>> CLASSES = new ConcurrentHashMap(JavaTypesLogParamValue.classes());
    public static Map<Class<?>, Function<Object, String>> ASSIGNABLE_FROM = new HashMap(JavaTypesLogParamValue.assignableFrom());
    @Inject
    @Any
    Instance<LogParamValue> services;

    public void init() {
        if (this.services != null) {
            HashMap classes = new HashMap();
            HashMap assignable = new HashMap();
            for (LogParamValue def : this.services) {
                this.map(def.getClasses(), classes);
                this.map(def.getAssignableFrom(), assignable);
            }
            classes.forEach((c, item) -> CLASSES.put((Class<?>)c, item.fn));
            assignable.forEach((c, item) -> ASSIGNABLE_FROM.put((Class<?>)c, item.fn));
        }
    }

    private void map(List<LogParamValue.Item> items, Map<Class<?>, LogParamValue.Item> target) {
        if (items != null) {
            for (LogParamValue.Item item : items) {
                LogParamValue.Item tmp = target.get(item.clazz);
                if (tmp != null) {
                    if (item.priority <= tmp.priority) continue;
                    target.put(item.clazz, item);
                    continue;
                }
                target.put(item.clazz, item);
            }
        }
    }

    public String getParameterValue(Object parameter) {
        if (parameter != null) {
            Class<?> clazz = parameter.getClass();
            Function<Object, String> fn = CLASSES.get(clazz);
            if (fn != null) {
                return fn.apply(parameter);
            }
            for (Map.Entry<Class<?>, Function<Object, String>> entry : ASSIGNABLE_FROM.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                Function<Object, String> fn2 = entry.getValue();
                CLASSES.put(clazz, fn2);
                return fn2.apply(parameter);
            }
        }
        return "" + parameter;
    }
}

