/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.cdi.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.tkit.quarkus.log.cdi.LogParam;
import org.tkit.quarkus.log.cdi.LogParamValue;

public class LogAnnotationGenerator {
    private static String TEMPLATE = "package org.tkit.quarkus.log.cdi;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport javax.enterprise.context.ApplicationScoped;\n\n@ApplicationScoped\n@LogService(log = false)\npublic class #name# implements LogParamValue {\n\n  public List<Item> getClasses() {\n    List<Item> result = new ArrayList<>();\n#classes#    return result;\n  }\n\n  public List<Item> getAssignableFrom() {\n    List<Item> result = new ArrayList<>();\n#assignable#    return result;\n  }\n}";

    public static void createLogParam(ProcessingEnvironment env, Set<? extends Element> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        ArrayList<MethodInfo> classes = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> assignable = new ArrayList<MethodInfo>();
        for (Element element : elements) {
            if (element.getKind() == ElementKind.METHOD && element.getModifiers().contains((Object)Modifier.STATIC)) {
                env.getMessager().printMessage(Diagnostic.Kind.NOTE, "LogParam processing interface: " + element);
                ExecutableElement method = (ExecutableElement)element;
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!LogParam.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
                    int priority = 0;
                    List tmpClasses = null;
                    List tmpAssignable = null;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                        if ("priority".equals(e.getKey().getSimpleName().toString())) {
                            priority = (Integer)e.getValue().getValue();
                        }
                        if ("classes".equals(e.getKey().getSimpleName().toString())) {
                            tmpClasses = (List)e.getValue().getValue();
                        }
                        if (!"assignableFrom".equals(e.getKey().getSimpleName().toString())) continue;
                        tmpAssignable = (List)e.getValue().getValue();
                    }
                    if (tmpClasses != null) {
                        classes.addAll(LogAnnotationGenerator.create(priority, method, tmpClasses));
                    }
                    if (tmpAssignable == null) continue;
                    assignable.addAll(LogAnnotationGenerator.create(priority, method, tmpAssignable));
                }
                continue;
            }
            env.getMessager().printMessage(Diagnostic.Kind.ERROR, "LogParam is not static method. The element: " + element + " kind: " + element.getKind() + " will be ignored.");
        }
        if (classes.isEmpty() && assignable.isEmpty()) {
            return;
        }
        String classesSource = LogAnnotationGenerator.generate(classes);
        String string = LogAnnotationGenerator.generate(assignable);
        String name = "_" + UUID.randomUUID().toString().replaceAll("-", "_");
        String source = "";
        source = TEMPLATE.replaceFirst("#name#", LogParamValue.class.getSimpleName() + name);
        source = source.replaceFirst("#classes#", classesSource);
        source = source.replaceFirst("#assignable#", string);
        try {
            PackageElement packageElement = env.getElementUtils().getPackageElement("org.tkit.quarkus.log.cdi");
            String fileName = LogParamValue.class.getName() + name;
            JavaFileObject builderFile = env.getFiler().createSourceFile(fileName, packageElement);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.write(source);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String generate(List<MethodInfo> items) {
        if (items.isEmpty()) {
            return "";
        }
        return items.stream().map(i -> "    result.add(item(" + i.priority + "," + i.paramClass + ".class," + i.clazz + "::" + i.method + "));\n").collect(Collectors.joining());
    }

    private static List<MethodInfo> create(int priority, ExecutableElement method, List<?> values) {
        return values.stream().map(value -> {
            MethodInfo i = new MethodInfo();
            i.priority = priority;
            i.paramClass = ((AnnotationValue)value).getValue().toString();
            i.method = method.getSimpleName().toString();
            i.clazz = "" + method.getEnclosingElement();
            return i;
        }).collect(Collectors.toList());
    }

    public static class MethodInfo {
        public int priority;
        public String paramClass;
        public String clazz;
        public String method;
    }
}

