/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.cdi.runtime;

import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tkit.quarkus.log.cdi.LogParam;
import org.tkit.quarkus.log.cdi.runtime.LogAnnotationGenerator;

@SupportedAnnotationTypes(value={"org.tkit.quarkus.log.cdi.LogParam"})
public class LogAnnotationProcessor
extends AbstractProcessor {
    public static final String LOGGER_PARAM_CLASS = "org.tkit.quarkus.log.cdi.LogParam";
    private static final int MAX_ROUND = 20;
    private int round;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        LogAnnotationGenerator.createLogParam(this.processingEnv, roundEnv.getElementsAnnotatedWith(LogParam.class));
        if (!roundEnv.processingOver() && this.round > 20) {
            this.messager().printMessage(Diagnostic.Kind.ERROR, "LogParam possible processing loop detected (21)");
        }
        ++this.round;
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(LogParam.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private Messager messager() {
        return this.processingEnv.getMessager();
    }
}

