/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.rs.exceptions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class RestException
extends RuntimeException {
    private Response.Status status;
    private Enum<?> errorCode;
    private List<Object> parameters = new ArrayList<Object>();
    private Map<String, Object> namedParameters = new HashMap<String, Object>();

    public RestException(Enum<?> errorCode) {
        this(errorCode, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public RestException(Enum<?> errorCode, Response.Status status) {
        super(RestException.requireNonNull(errorCode));
        this.errorCode = errorCode;
        this.status = status;
    }

    public RestException(Enum<?> errorCode, Response.Status status, Throwable cause) {
        super(RestException.requireNonNull(errorCode), cause);
        this.errorCode = errorCode;
        this.status = status;
    }

    public RestException(Enum<?> errorCode, Throwable cause) {
        this(errorCode, Response.Status.INTERNAL_SERVER_ERROR, cause);
    }

    public RestException(Enum<?> errorCode, Response.Status status, Throwable cause, Object ... params) {
        this(errorCode, status, cause);
        if (params != null) {
            Collections.addAll(this.parameters, params);
        }
    }

    public RestException(Enum<?> errorCode, Throwable cause, Object ... params) {
        this(errorCode, Response.Status.INTERNAL_SERVER_ERROR, cause, params);
    }

    public RestException(Enum<?> errorCode, Response.Status status, Object ... params) {
        this(errorCode, status);
        if (params != null) {
            Collections.addAll(this.parameters, params);
        }
    }

    public RestException(Enum<?> errorCode, Object ... params) {
        this(errorCode, Response.Status.INTERNAL_SERVER_ERROR, params);
    }

    public RestException addParam(String name, Object value) {
        this.namedParameters.put(name, value);
        return this;
    }

    public RestException addParam(Object value) {
        this.parameters.add(value);
        return this;
    }

    public RestException withParams(Object ... params) {
        Collections.addAll(this.parameters, params);
        return this;
    }

    public RestException withNamedParams(Map<String, Object> namedParams) {
        this.namedParameters.putAll(namedParams);
        return this;
    }

    private static String requireNonNull(Enum<?> errorCode) {
        if (errorCode == null) {
            throw new NullPointerException("Error code is null!");
        }
        return errorCode.name();
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public Enum<?> getErrorCode() {
        return this.errorCode;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }
}

