/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.rs.mappers;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.rs.exceptions.RestException;
import org.tkit.quarkus.rs.models.RestExceptionDTO;
import org.tkit.quarkus.rs.resources.ResourceManager;

@Provider
@Priority(value=10000)
public class DefaultExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionMapper.class);
    public static final int PRIORITY = 10000;
    @Context
    private HttpHeaders headers;
    @Context
    UriInfo uriInfo;

    public Response toResponse(Exception e) {
        Optional logException = ConfigProvider.getConfig().getOptionalValue("tkit.rs.mapper.log", Boolean.class);
        if (logException.isEmpty() || ((Boolean)logException.get()).booleanValue()) {
            log.error("REST exception URL:{},ERROR:{}", (Object)this.uriInfo.getRequestUri(), (Object)e.getMessage());
        }
        if (e instanceof RestException) {
            return this.createResponse((RestException)e);
        }
        if (e instanceof WebApplicationException) {
            return this.createResponse((WebApplicationException)e);
        }
        return this.createResponse(e);
    }

    private Response createResponse(RestException e) {
        RestExceptionDTO dto = new RestExceptionDTO();
        String message = ResourceManager.getMessage(e.getErrorCode(), this.getLocale(), e.getParameters());
        dto.setMessage(message);
        dto.setErrorCode(e.getErrorCode().name());
        dto.setParameters(e.getParameters());
        dto.setNamedParameters(e.getNamedParameters());
        return Response.status((Response.Status)e.getStatus()).type(this.mediaType()).entity((Object)dto).build();
    }

    protected Response createResponse(WebApplicationException e) {
        RestExceptionDTO dto = new RestExceptionDTO();
        dto.setErrorCode(Error.WEB_APPLICATION_EXCEPTION.name());
        dto.setMessage(e.getMessage());
        return Response.fromResponse((Response)e.getResponse()).entity((Object)dto).type(this.mediaType()).build();
    }

    protected Response createResponse(Exception e) {
        RestExceptionDTO dto = new RestExceptionDTO();
        dto.setErrorCode(Error.UNDEFINED_ERROR_CODE.name());
        dto.setMessage(e.getMessage());
        return Response.serverError().type(this.mediaType()).entity((Object)dto).build();
    }

    protected MediaType mediaType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }

    protected Locale getLocale() {
        Locale tmp;
        List locales = this.headers.getAcceptableLanguages();
        if (locales != null && !locales.isEmpty() && (tmp = (Locale)locales.get(0)) != null && !"*".equals(tmp.getLanguage())) {
            return tmp;
        }
        return null;
    }

    public static enum Error {
        WEB_APPLICATION_EXCEPTION,
        UNDEFINED_ERROR_CODE;

    }
}

