/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.test;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.test.WithDBData;

public class WithDBDataExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(WithDBDataExtension.class);

    public void afterTestExecution(ExtensionContext context) throws Exception {
        Method method = context.getRequiredTestMethod();
        WithDBData an = method.getAnnotation(WithDBData.class);
        if (an != null) {
            log.info("[DB-IMPORT] After method level data for {} data-source {}", (Object)method.getName(), (Object)an.value());
            this.deleteAllData(an);
        } else {
            WithDBData can = context.getRequiredTestClass().getAnnotation(WithDBData.class);
            if (can != null && can.rinseAndRepeat()) {
                log.info("[DB-IMPORT] After class level data(Rinse and Repeat) for {} data-source {}", (Object)method.getName(), (Object)can.value());
                this.deleteAllData(can);
            } else {
                log.debug("[DB-IMPORT] No WithDBData annotation found on class level {}", (Object)context.getRequiredTestClass().getName());
            }
        }
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        Method method;
        WithDBData an;
        Object importAll = context.getStore(ExtensionContext.Namespace.GLOBAL).remove((Object)WithDBData.class.getName());
        if (importAll != null) {
            this.importAll(context.getRequiredTestClass());
        }
        if ((an = (method = context.getRequiredTestMethod()).getAnnotation(WithDBData.class)) != null) {
            log.info("[DB-IMPORT] Init method level data for {} data-source {}", (Object)method.getName(), (Object)an.value());
            this.importAllData(an);
        } else if (importAll == null) {
            WithDBData can = context.getRequiredTestClass().getAnnotation(WithDBData.class);
            if (can != null && can.rinseAndRepeat()) {
                log.info("[DB-IMPORT] Init class level data(Rinse and Repeat) for {} data-source {}", (Object)method.getName(), (Object)can.value());
                this.importAllData(can);
            } else {
                log.debug("[DB-IMPORT] No WithDBData annotation found on class level {}", (Object)context.getRequiredTestClass().getName());
            }
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Class clazz = context.getRequiredTestClass();
        WithDBData an = clazz.getAnnotation(WithDBData.class);
        if (an != null) {
            log.info("[DB-IMPORT] After class level data for {} data-source {}", (Object)clazz.getName(), (Object)an.value());
            this.deleteAllData(an);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Object tmp = context.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)WithDBDataExtension.class.getName());
        if (tmp == null) {
            context.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)WithDBDataExtension.class.getName(), (Object)Boolean.TRUE.toString());
            context.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)WithDBData.class.getName(), (Object)Boolean.TRUE.toString());
        } else {
            this.importAll(context.getRequiredTestClass());
        }
    }

    private void importAll(Class<?> clazz) {
        WithDBData an = clazz.getAnnotation(WithDBData.class);
        if (an != null) {
            log.info("[DB-IMPORT] Init class level data for {} data-source {}", (Object)clazz.getName(), (Object)an.value());
            this.importAllData(an);
        }
    }

    private void deleteAllData(WithDBData an) throws Exception {
        for (int i = 0; i < an.value().length; ++i) {
            if (an.deleteAfterTest()) {
                String path = an.value()[i];
                URL fileUrl = this.getClass().getClassLoader().getResource(path);
                if (fileUrl != null) {
                    log.info("Truncate data via DBImport file {}", (Object)fileUrl);
                    if (WithDBDataExtension.isExcel(path)) {
                        WithDBDataExtension.deleteExcelData(fileUrl);
                    } else if (WithDBDataExtension.isCsv(path)) {
                        WithDBDataExtension.deleteCsvData(fileUrl);
                    }
                    log.info("[DB-IMPORT] Truncate data successfully {}", (Object)fileUrl);
                    continue;
                }
                log.warn("[DB-IMPORT] Missing database import resource {} in the class-path.", (Object)path);
                continue;
            }
            log.info("[DB-IMPORT] no data deleted after test due to annotation value");
        }
    }

    public static void deleteCsvData(URL fileUrl) throws Exception {
        ((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().spec(WithDBDataExtension.requestSpecification()).contentType("application/x-www-form-urlencoded").formParam("csv_path", new Object[]{fileUrl.getPath()}).log().ifValidationFails()).when().post("db/teardown/csv", new Object[0])).then()).statusCode(200);
    }

    public static void deleteExcelData(URL fileUrl) {
        ((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().spec(WithDBDataExtension.requestSpecification()).contentType("application/excel").body(WithDBDataExtension.createFile(fileUrl)).log().ifValidationFails()).when().post("db/teardown/excel", new Object[0])).then()).statusCode(200);
    }

    private void importAllData(WithDBData an) {
        for (int i = 0; i < an.value().length; ++i) {
            String path = an.value()[i];
            URL fileUrl = this.getClass().getClassLoader().getResource(path);
            if (fileUrl != null) {
                log.info("[DB-IMPORT] Importing data via DBImport file {}", (Object)fileUrl);
                if (WithDBDataExtension.isExcel(path)) {
                    WithDBDataExtension.importExcelData(fileUrl, an.deleteBeforeInsert());
                    log.info("[DB-IMPORT] Imported Excel {} datasource {}", (Object)this.getClass().getSimpleName(), (Object)path);
                    continue;
                }
                if (!WithDBDataExtension.isCsv(path)) continue;
                WithDBDataExtension.importCsvData(fileUrl, an.deleteBeforeInsert());
                log.info("[DB-IMPORT] Imported CSV {} datasource {}", (Object)this.getClass().getSimpleName(), (Object)fileUrl);
                continue;
            }
            log.warn("[DB-IMPORT] Missing database import resource {} in the class-path.", (Object)path);
        }
    }

    public static RequestSpecification requestSpecification() {
        String url = System.getProperty("tkit.test.dbimport.url", "http://docker:8811/");
        return new RequestSpecBuilder().setBaseUri(url).build();
    }

    public static boolean isCsv(String path) {
        return path != null && (path.endsWith("csv") || path.endsWith("csv/"));
    }

    public static boolean isExcel(String path) {
        return path != null && (path.endsWith(".xls") || path.endsWith(".xlsx"));
    }

    public static void importExcelData(URL fileUrl, boolean deleteBeforeInsert) {
        ((ValidatableResponse)((Response)((Response)((RequestSpecification)RestAssured.given().spec(WithDBDataExtension.requestSpecification()).contentType("application/excel").body(WithDBDataExtension.createFile(fileUrl)).log().all()).queryParam("cleanBefore", new Object[]{deleteBeforeInsert}).when().post("db/import/excel", new Object[0])).prettyPeek()).then()).statusCode(200);
    }

    public static void importCsvData(URL fileUrl, boolean deleteBeforeInsert) {
        ((ValidatableResponse)((Response)((Response)((RequestSpecification)RestAssured.given().spec(WithDBDataExtension.requestSpecification()).formParam("csv_path", new Object[]{fileUrl.getPath()}).log().ifValidationFails()).queryParam("cleanBefore", new Object[]{deleteBeforeInsert}).when().post("db/import/csv", new Object[0])).prettyPeek()).then()).statusCode(200);
    }

    private static File createFile(URL fileUrl) {
        try {
            return new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Wrong URI format. " + fileUrl, e);
        }
    }
}

