/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.test.docker;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.utility.MountableFile;
import org.tkit.quarkus.test.docker.ContainerConfig;
import org.tkit.quarkus.test.docker.ContainerLogger;
import org.tkit.quarkus.test.docker.DockerTestEnvironment;
import org.tkit.quarkus.test.docker.TestGenericContainer;
import org.tkit.quarkus.test.docker.properties.TestProperty;

public class DockerComposeService {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeService.class);
    private TestGenericContainer container;
    private ContainerConfig config;

    protected DockerComposeService(Network network, ContainerConfig config) {
        this.config = config;
        this.container = this.createContainer(network, config);
    }

    public static DockerComposeService createDockerComposeService(Network network, ContainerConfig config) {
        return new DockerComposeService(network, config);
    }

    public String getName() {
        return this.config.name;
    }

    public ContainerConfig getConfig() {
        return this.config;
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    public void start(DockerTestEnvironment environment, boolean integrationTest) {
        if (this.container == null) {
            return;
        }
        ArrayList<TestProperty> te = new ArrayList<TestProperty>(this.config.commonVariables.environments);
        if (integrationTest) {
            te.addAll(this.config.integrationVariables.environments);
        } else {
            te.addAll(this.config.unitVariables.environments);
        }
        Map<String, String> env = DockerComposeService.createValues(environment, te);
        System.out.println(String.format("[tkit-quarkus-test] Service: '%s' add test environment variables: %s", this.config.name, env));
        this.container.withEnv(env);
        this.container.start();
        ArrayList<TestProperty> tp = new ArrayList<TestProperty>(this.config.commonVariables.properties);
        if (integrationTest) {
            tp.addAll(this.config.integrationVariables.properties);
        } else {
            tp.addAll(this.config.unitVariables.properties);
        }
        Map<String, String> prop = DockerComposeService.createValues(environment, tp);
        System.out.println(String.format("[tkit-quarkus-test] Service: '%s' update test properties: %s", this.config.name, prop));
        prop.forEach(System::setProperty);
    }

    private static Map<String, String> createValues(DockerTestEnvironment environment, List<TestProperty> properties) {
        return properties.stream().collect(Collectors.toMap(p -> p.name, p -> p.getValue(environment)));
    }

    public void stop(boolean integrationTest) {
        ArrayList<TestProperty> tp = new ArrayList<TestProperty>(this.config.commonVariables.properties);
        if (integrationTest) {
            tp.addAll(this.config.integrationVariables.properties);
        } else {
            tp.addAll(this.config.unitVariables.properties);
        }
        tp.forEach(p -> System.clearProperty(p.name));
        this.container.stop();
    }

    public Integer getPort(int port) {
        return DockerComposeService.getPort(this.container, port);
    }

    public static Integer getPort(GenericContainer<?> container, int port) {
        try {
            return container.getMappedPort(port);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Using fixed port for the container {} and port {}", (Object)container.getContainerId(), (Object)port);
            return port;
        }
    }

    public String getHost() {
        return DockerComposeService.getHost(this.container);
    }

    public static String getHost(GenericContainer<?> container) {
        return container.getContainerIpAddress();
    }

    public String getUrl(int port) {
        return DockerComposeService.getUrl(this.container, port);
    }

    public static String getUrl(GenericContainer<?> container, int port) {
        return "http://" + DockerComposeService.getHost(container) + ":" + DockerComposeService.getPort(container, port);
    }

    protected TestGenericContainer createContainer(Network network, ContainerConfig config) {
        try (TestGenericContainer result = new TestGenericContainer(config.image);){
            ((TestGenericContainer)result.withNetwork(network)).withNetworkAliases(new String[]{config.name});
            if (config.command != null && !config.command.isEmpty()) {
                String[] cmd = config.command.toArray(new String[0]);
                result.withCommand(cmd);
            }
            switch (config.imagePull) {
                case ALWAYS: {
                    result.withImagePullPolicy(PullPolicy.alwaysPull());
                    break;
                }
                case MAX_AGE: {
                    result.withImagePullPolicy(PullPolicy.ageBased((Duration)config.imagePullDuration));
                    break;
                }
                case DEFAULT: {
                    result.withImagePullPolicy(PullPolicy.defaultPolicy());
                }
            }
            if (config.waitLogRegex != null) {
                result.waitingFor((WaitStrategy)Wait.forLogMessage((String)config.waitLogRegex, (int)config.waitLogTimes));
            }
            if (config.log) {
                result.withLogConsumer((Consumer)((Object)ContainerLogger.create(config.name)));
            }
            config.environments.forEach((arg_0, arg_1) -> ((TestGenericContainer)result).withEnv(arg_0, arg_1));
            config.volumes.forEach((k, v) -> {
                String key = k;
                if (key.startsWith("./")) {
                    key = key.substring(1);
                }
                result.withCopyFileToContainer(MountableFile.forClasspathResource((String)key), (String)v);
            });
            config.ports.values().stream().map(Integer::parseInt).forEach(arg_0 -> ((TestGenericContainer)result).addExposedPort(arg_0));
            if (config.fixedPorts) {
                config.ports.forEach((key, value) -> result.withFixedExposedPort(Integer.parseInt(key), Integer.parseInt(value)));
            }
            TestGenericContainer testGenericContainer = result;
            return testGenericContainer;
        }
    }
}

