/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.test.docker;

import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.test.docker.DockerComposeTest;
import org.tkit.quarkus.test.docker.DockerComposeTestResource;

public class DockerComposeTestExtension
implements BeforeAllCallback,
BeforeEachCallback {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeTest.class);

    public void beforeAll(ExtensionContext context) {
        log.debug("Start docker compose test extension");
        context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).getOrComputeIfAbsent(DockerComposeStore.class);
    }

    public void beforeEach(ExtensionContext context) {
        DockerComposeStore store = (DockerComposeStore)context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).getOrComputeIfAbsent(DockerComposeStore.class);
        store.inject(context.getRequiredTestInstance());
    }

    static class DockerComposeStore
    extends DockerComposeTestResource
    implements ExtensionContext.Store.CloseableResource {
        public DockerComposeStore() {
            this.start();
        }

        public void close() {
            this.environment.stop();
        }
    }
}

