/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.test.docker;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.shaded.org.yaml.snakeyaml.Yaml;
import org.tkit.quarkus.test.docker.ContainerConfig;
import org.tkit.quarkus.test.docker.DockerComposeService;

public class DockerTestEnvironment {
    public static final String SYS_PROP_TEST_INTEGRATION = "test.integration";
    private static final Logger log = LoggerFactory.getLogger(DockerTestEnvironment.class);
    private Map<String, DockerComposeService> containers = new HashMap<String, DockerComposeService>();
    private Map<Integer, List<DockerComposeService>> containerProperties = new HashMap<Integer, List<DockerComposeService>>();
    private Network network;

    public DockerTestEnvironment() {
        String dockerComposeFilePath = System.getProperty("test.docker.compose.file", "./src/test/resources/docker-compose.yml");
        File dockerComposeFile = new File(dockerComposeFilePath);
        if (!dockerComposeFile.exists()) {
            dockerComposeFile = new File("./src/test/resources/docker-compose.yaml");
        }
        this.load(dockerComposeFile);
    }

    public DockerTestEnvironment(String dockerComposeFile) {
        this.load(new File(dockerComposeFile));
    }

    public DockerComposeService getService(String name) {
        return this.containers.get(name);
    }

    public Network getNetwork() {
        return this.network;
    }

    public void load(File dockerComposeFile) {
        this.network = Network.newNetwork();
        boolean integrationTest = Boolean.getBoolean(SYS_PROP_TEST_INTEGRATION);
        Yaml yaml = new Yaml();
        try (InputStream fileInputStream = Files.newInputStream(dockerComposeFile.toPath(), new OpenOption[0]);){
            Map map = (Map)yaml.load(fileInputStream);
            Object services = map.get("services");
            if (services instanceof Map) {
                Map data = (Map)services;
                data.forEach((k, v) -> {
                    ContainerConfig config = ContainerConfig.createContainerProperties(k, (Map)v);
                    if (integrationTest && config.integrationTest || !integrationTest && config.unitTest) {
                        DockerComposeService service = DockerComposeService.createDockerComposeService(this.network, config);
                        this.containerProperties.computeIfAbsent(service.getConfig().priority, x -> new ArrayList()).add(service);
                        this.containers.put((String)k, service);
                    }
                });
            }
        }
        catch (IOException e) {
            log.warn("Failed to read YAML from {}", (Object)dockerComposeFile.getAbsolutePath(), (Object)e);
        }
    }

    public void start() {
        System.out.println("Docker client ping ...");
        DockerClientFactory.instance().client().pingCmd().exec();
        ArrayList<Integer> priorities = new ArrayList<Integer>(this.containerProperties.keySet());
        Collections.sort(priorities);
        boolean integrationTest = Boolean.getBoolean(SYS_PROP_TEST_INTEGRATION);
        priorities.forEach(p -> {
            List<DockerComposeService> services = this.containerProperties.get(p);
            List names = services.stream().map(DockerComposeService::getName).collect(Collectors.toList());
            System.out.println(String.format("------------------------------\nStart test containers\npriority: %s\nServices: %s\nintegration test: %s\n------------------------------", p, names, integrationTest));
            services.parallelStream().forEach(s -> s.start(this, integrationTest));
        });
    }

    public void stop() {
        boolean integrationTest = Boolean.getBoolean(SYS_PROP_TEST_INTEGRATION);
        this.containers.values().parallelStream().forEach(p -> p.stop(integrationTest));
    }
}

