/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPDigestAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

abstract class HTTPAuthentication {
    private Map myChallengeParameters;
    private String myUserName;
    private String myPassword;
    private static final String AUTH_METHODS_PROPERTY = "svnkit.http.methods";
    private static final String OLD_AUTH_METHODS_PROPERTY = "javasvn.http.methods";

    protected HTTPAuthentication(SVNPasswordAuthentication credentials) {
        if (credentials != null) {
            this.myUserName = credentials.getUserName();
            this.myPassword = credentials.getPassword();
        }
    }

    protected HTTPAuthentication(String name, String password) {
        this.myUserName = name;
        this.myPassword = password;
    }

    protected HTTPAuthentication() {
    }

    public void setChallengeParameter(String name, String value) {
        Map params = this.getChallengeParameters();
        params.put(name, value);
    }

    public String getChallengeParameter(String name) {
        if (this.myChallengeParameters == null) {
            return null;
        }
        return (String)this.myChallengeParameters.get(name);
    }

    protected Map getChallengeParameters() {
        if (this.myChallengeParameters == null) {
            this.myChallengeParameters = new TreeMap();
        }
        return this.myChallengeParameters;
    }

    public void setCredentials(SVNPasswordAuthentication credentials) {
        if (credentials != null) {
            this.myUserName = credentials.getUserName();
            this.myPassword = credentials.getPassword();
        }
    }

    public String getUserName() {
        if (this.myUserName == null) {
            this.myUserName = System.getProperty("user.name", "");
        }
        return this.myUserName;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public void setUserName(String name) {
        this.myUserName = name;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    public static HTTPAuthentication parseAuthParameters(Collection authHeaderValues, HTTPAuthentication prevResponse) throws SVNException {
        if (authHeaderValues == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error(err);
        }
        HTTPAuthentication auth = null;
        String authHeader = null;
        authHeaderValues = HTTPAuthentication.sortSchemes(authHeaderValues);
        Iterator authSchemes = authHeaderValues.iterator();
        while (authSchemes.hasNext()) {
            authHeader = (String)authSchemes.next();
            String source = authHeader.trim();
            int index = source.indexOf(32);
            if (index <= 0 && !"NTLM".equalsIgnoreCase(source.substring(0, index = source.length()))) continue;
            String method = source.substring(0, index);
            source = source.substring(index).trim();
            if ("Basic".equalsIgnoreCase(method)) {
                auth = new HTTPBasicAuthentication();
                if (source.indexOf("realm=") < 0) break;
                source = source.substring(source.indexOf("realm=") + "realm=".length());
                if ((source = source.trim()).startsWith("\"")) {
                    source = source.substring(1);
                }
                if (source.endsWith("\"")) {
                    source = source.substring(0, source.length() - 1);
                }
                auth.setChallengeParameter("realm", source);
                break;
            }
            if ("Digest".equalsIgnoreCase(method)) {
                auth = new HTTPDigestAuthentication();
                char[] chars = source.toCharArray();
                int tokenIndex = 0;
                boolean parsingToken = true;
                String name = null;
                int quotesCount = 0;
                for (int i = 0; i < chars.length; ++i) {
                    if (parsingToken) {
                        if (chars[i] != '=') continue;
                        name = new String(chars, tokenIndex, i - tokenIndex);
                        name = name.trim();
                        tokenIndex = i + 1;
                        parsingToken = false;
                        continue;
                    }
                    if (chars[i] == '\"') {
                        quotesCount = quotesCount > 0 ? 0 : 1;
                        continue;
                    }
                    if (i + 1 < chars.length && (chars[i] != ',' || quotesCount != 0)) continue;
                    String value = new String(chars, tokenIndex, i - tokenIndex);
                    if ((value = value.trim()).charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1);
                        value = value.substring(0, value.length() - 1);
                    }
                    auth.setChallengeParameter(name, value);
                    tokenIndex = i + 1;
                    parsingToken = true;
                }
                HTTPDigestAuthentication digestAuth = (HTTPDigestAuthentication)auth;
                digestAuth.init();
                break;
            }
            if (!"NTLM".equalsIgnoreCase(method)) continue;
            HTTPNTLMAuthentication ntlmAuth = null;
            if (source.length() == 0) {
                ntlmAuth = new HTTPNTLMAuthentication();
                ntlmAuth.setType1State();
            } else {
                ntlmAuth = (HTTPNTLMAuthentication)prevResponse;
                ntlmAuth.parseChallenge(source);
                ntlmAuth.setType3State();
            }
            auth = ntlmAuth;
            break;
        }
        if (auth == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "HTTP authorization method ''{0}'' is not supported", authHeader);
            SVNErrorManager.error(err);
        }
        if (prevResponse != null) {
            auth.setUserName(prevResponse.getUserName());
            auth.setPassword(prevResponse.getPassword());
        }
        return auth;
    }

    public static boolean isSchemeSupportedByServer(String scheme, Collection authHeaderValues) throws SVNException {
        if (authHeaderValues == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error(err);
        }
        String authHeader = null;
        Iterator authSchemes = authHeaderValues.iterator();
        while (authSchemes.hasNext()) {
            String method;
            authHeader = (String)authSchemes.next();
            String source = authHeader.trim();
            int index = source.indexOf(32);
            if (index <= 0) {
                index = source.length();
            }
            if (!(method = source.substring(0, index)).equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }

    private static Collection sortSchemes(Collection authHeaders) {
        String priorities = System.getProperty(AUTH_METHODS_PROPERTY, System.getProperty(OLD_AUTH_METHODS_PROPERTY));
        if (priorities == null) {
            return authHeaders;
        }
        final ArrayList<String> schemes = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(priorities, " ,");
        while (tokens.hasMoreTokens()) {
            String scheme = tokens.nextToken();
            if (schemes.contains(scheme)) continue;
            schemes.add(scheme);
        }
        ArrayList ordered = new ArrayList(authHeaders);
        Collections.sort(ordered, new Comparator(){

            public int compare(Object o1, Object o2) {
                String header1 = (String)o1;
                String header2 = (String)o2;
                String scheme1 = HTTPAuthentication.getSchemeName(header1);
                String scheme2 = HTTPAuthentication.getSchemeName(header2);
                int index1 = schemes.indexOf(scheme1);
                int index2 = schemes.indexOf(scheme2);
                index1 = index1 < 0 ? Integer.MAX_VALUE : index1;
                int n = index2 = index2 < 0 ? Integer.MAX_VALUE : index2;
                if (index1 == index2) {
                    return 0;
                }
                return index1 > index2 ? 1 : -1;
            }
        });
        return ordered;
    }

    private static String getSchemeName(String header) {
        String source = header.trim();
        int index = source.indexOf(32);
        if (index <= 0) {
            index = source.length();
        }
        return source.substring(0, index);
    }

    public abstract String getAuthenticationScheme();

    public abstract String authenticate() throws SVNException;

    protected static byte[] getASCIIBytes(String data) {
        return HTTPAuthentication.getBytes(data, "US-ASCII");
    }

    protected static byte[] getBytes(String data, String charset) {
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }
}

