/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSReplayPathHandler;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;

public class FSRepositoryUtil {
    public static void replay(FSFS fsfs, FSRoot root, String basePath, long lowRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        Map fsChanges = root.getChangedPaths();
        basePath = basePath.startsWith("/") ? basePath.substring(1) : basePath;
        LinkedList<String> interestingPaths = new LinkedList<String>();
        HashMap<String, FSPathChange> changedPaths = new HashMap<String, FSPathChange>();
        Iterator paths = fsChanges.keySet().iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            FSPathChange change = (FSPathChange)fsChanges.get(path);
            String string = path = path.startsWith("/") ? path.substring(1) : path;
            if (!"".equals(basePath) && (!path.startsWith(basePath) || path.charAt(basePath.length()) != '/' && path.length() != basePath.length())) continue;
            path = path.startsWith("/") ? path.substring(1) : path;
            interestingPaths.add(path);
            changedPaths.put(path, change);
        }
        if (FSRepository.isInvalidRevision(lowRevision)) {
            lowRevision = 0L;
        }
        FSRevisionRoot compareRoot = null;
        if (sendDeltas) {
            long revision = -1L;
            if (root instanceof FSRevisionRoot) {
                FSRevisionRoot revRoot = (FSRevisionRoot)root;
                revision = revRoot.getRevision() - 1L;
            } else if (root instanceof FSTransactionRoot) {
                FSTransactionRoot txnRoot = (FSTransactionRoot)root;
                revision = txnRoot.getTxn().getBaseRevision();
            }
            compareRoot = fsfs.createRevisionRoot(revision);
        }
        if (root instanceof FSRevisionRoot) {
            FSRevisionRoot revRoot = (FSRevisionRoot)root;
            editor.targetRevision(revRoot.getRevision());
        }
        FSReplayPathHandler handler = new FSReplayPathHandler(fsfs, root, compareRoot, changedPaths, basePath, lowRevision);
        SVNCommitUtil.driveCommitEditor(handler, interestingPaths, editor, -1L);
    }

    public static void copy(InputStream src, OutputStream dst) throws SVNException {
        try {
            int length;
            byte[] buffer = new byte[102400];
            do {
                if ((length = src.read(buffer)) <= 0) continue;
                dst.write(buffer, 0, length);
            } while (length == 102400);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }

    public static boolean arePropertiesEqual(FSRevisionNode revNode1, FSRevisionNode revNode2) {
        return FSRepositoryUtil.areRepresentationsEqual(revNode1, revNode2, true);
    }

    public static boolean arePropertiesChanged(FSRoot root1, String path1, FSRoot root2, String path2) throws SVNException {
        FSRevisionNode node2;
        FSRevisionNode node1 = root1.getRevisionNode(path1);
        return !FSRepositoryUtil.areRepresentationsEqual(node1, node2 = root2.getRevisionNode(path2), true);
    }

    public static boolean areFileContentsChanged(FSRoot root1, String path1, FSRoot root2, String path2) throws SVNException {
        FSRevisionNode revNode2;
        FSRevisionNode revNode1;
        SVNErrorMessage err;
        if (root1.checkNodeKind(path1) != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "''{0}'' is not a file", path1);
            SVNErrorManager.error(err);
        }
        if (root2.checkNodeKind(path2) != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "''{0}'' is not a file", path2);
            SVNErrorManager.error(err);
        }
        return !FSRepositoryUtil.areRepresentationsEqual(revNode1 = root1.getRevisionNode(path1), revNode2 = root2.getRevisionNode(path2), false);
    }

    public static Map getPropsDiffs(Map sourceProps, Map targetProps) {
        String propName;
        HashMap<String, String> result = new HashMap<String, String>();
        if (sourceProps == null) {
            sourceProps = Collections.EMPTY_MAP;
        }
        if (targetProps == null) {
            targetProps = Collections.EMPTY_MAP;
        }
        Iterator names = sourceProps.keySet().iterator();
        while (names.hasNext()) {
            propName = (String)names.next();
            String srcPropVal = (String)sourceProps.get(propName);
            String targetPropVal = (String)targetProps.get(propName);
            if (targetPropVal == null) {
                result.put(propName, null);
                continue;
            }
            if (targetPropVal.equals(srcPropVal)) continue;
            result.put(propName, targetPropVal);
        }
        names = targetProps.keySet().iterator();
        while (names.hasNext()) {
            propName = (String)names.next();
            String targetPropVal = (String)targetProps.get(propName);
            if (sourceProps.get(propName) != null) continue;
            result.put(propName, targetPropVal);
        }
        return result;
    }

    private static boolean areRepresentationsEqual(FSRevisionNode revNode1, FSRevisionNode revNode2, boolean forProperties) {
        if (revNode1 == revNode2) {
            return true;
        }
        if (revNode1 == null || revNode2 == null) {
            return false;
        }
        return FSRepresentation.compareRepresentations(forProperties ? revNode1.getPropsRepresentation() : revNode1.getTextRepresentation(), forProperties ? revNode2.getPropsRepresentation() : revNode2.getTextRepresentation());
    }
}

