/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNGanymedConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNPlainConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNTunnelConnector;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;

public interface ISVNConnectorFactory {
    public static final ISVNConnectorFactory DEFAULT = new ISVNConnectorFactory(){

        public ISVNConnector createConnector(SVNRepository repository) throws SVNException {
            SVNURL location = repository.getLocation();
            if ("svn+ssh".equals(location.getProtocol())) {
                return new SVNGanymedConnector();
            }
            if (location.getProtocol().startsWith("svn+")) {
                String tunnel;
                String name = location.getProtocol().substring("svn+".length());
                if (repository.getTunnelProvider() != null && (tunnel = repository.getTunnelProvider().getTunnelDefinition(name)) != null) {
                    return new SVNTunnelConnector(name, tunnel);
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "Cannot find tunnel specification for ''{0}''", name);
                SVNErrorManager.error(err);
            }
            return new SVNPlainConnector();
        }
    };

    public ISVNConnector createConnector(SVNRepository var1) throws SVNException;
}

