/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

public class SVNPlainConnector
implements ISVNConnector {
    private static final int DEFAULT_SVN_TIMEOUT = 0;
    private Socket mySocket;
    private OutputStream myOutputStream;
    private InputStream myInputStream;

    public void open(SVNRepositoryImpl repository) throws SVNException {
        if (this.mySocket != null) {
            return;
        }
        SVNURL location = repository.getLocation();
        try {
            this.mySocket = SVNSocketFactory.createPlainSocket(location.getHost(), location.getPort());
            this.mySocket.setSoTimeout(0);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(SVNRepositoryImpl repository) throws SVNException {
        if (this.mySocket != null) {
            try {
                try {
                    this.mySocket.close();
                }
                catch (IOException ex) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, ex.getMessage(), ex));
                    Object var4_3 = null;
                    this.mySocket = null;
                    this.myInputStream = null;
                    this.myOutputStream = null;
                }
                Object var4_2 = null;
                this.mySocket = null;
                this.myInputStream = null;
                this.myOutputStream = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.mySocket = null;
                this.myInputStream = null;
                this.myOutputStream = null;
                throw throwable;
            }
        }
    }

    public boolean isConnected(SVNRepositoryImpl repos) throws SVNException {
        return this.mySocket != null && this.mySocket.isConnected();
    }

    public InputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            this.myInputStream = this.mySocket.getInputStream();
        }
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            this.myOutputStream = new BufferedOutputStream(this.mySocket.getOutputStream());
        }
        return this.myOutputStream;
    }

    public void free() {
    }

    public boolean occupy() {
        return true;
    }
}

