/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSDeltaConsumer;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;
import org.tmatesoft.svn.util.SVNDebugLog;

public class DefaultLoadHandler
implements ISVNLoadHandler {
    private FSFS myFSFS;
    private RevisionBaton myCurrentRevisionBaton;
    private NodeBaton myCurrentNodeBaton;
    private boolean myIsUsePreCommitHook;
    private boolean myIsUsePostCommitHook;
    private Map myRevisionsMap;
    private String myParentDir;
    private SVNUUIDAction myUUIDAction;
    private SVNDeltaReader myDeltaReader;
    private SVNDeltaGenerator myDeltaGenerator;
    private ISVNAdminEventHandler myProgressHandler;

    public DefaultLoadHandler(boolean usePreCommitHook, boolean usePostCommitHook, SVNUUIDAction uuidAction, String parentDir, ISVNAdminEventHandler progressHandler) {
        this.myProgressHandler = progressHandler;
        this.myIsUsePreCommitHook = usePreCommitHook;
        this.myIsUsePostCommitHook = usePostCommitHook;
        this.myUUIDAction = uuidAction;
        this.myParentDir = SVNPathUtil.canonicalizeAbsPath(parentDir);
        this.myRevisionsMap = new HashMap();
    }

    public void setFSFS(FSFS fsfs) {
        this.myFSFS = fsfs;
    }

    public void closeRevision() throws SVNException {
        if (this.myCurrentRevisionBaton != null) {
            RevisionBaton baton = this.myCurrentRevisionBaton;
            this.myCurrentRevisionBaton = null;
            if (baton.myRevision <= 0L) {
                return;
            }
            long oldRevision = baton.myRevision;
            if (this.myIsUsePreCommitHook) {
                try {
                    FSHooks.runPreCommitHook(this.myFSFS.getRepositoryRoot(), baton.myTxn.getTxnId());
                }
                catch (SVNException svne) {
                    try {
                        FSCommitter.abortTransaction(this.myFSFS, baton.myTxn.getTxnId());
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                    throw svne;
                }
            }
            long newRevision = -1L;
            try {
                newRevision = baton.getCommitter().commitTxn();
            }
            catch (SVNException svne) {
                try {
                    FSCommitter.abortTransaction(this.myFSFS, baton.myTxn.getTxnId());
                }
                catch (SVNException svne2) {
                    // empty catch block
                }
                throw svne;
            }
            if (this.myIsUsePostCommitHook) {
                try {
                    FSHooks.runPostCommitHook(this.myFSFS.getRepositoryRoot(), newRevision);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, "Commit succeeded, but post-commit hook failed");
                    SVNErrorManager.error(err, svne);
                }
            }
            this.myRevisionsMap.put(new Long(oldRevision), new Long(newRevision));
            if (baton.myDatestamp != null) {
                this.myFSFS.setRevisionProperty(newRevision, "svn:date", baton.myDatestamp);
            }
            String message = newRevision == baton.myRevision ? "\n------- Committed revision " + newRevision + " >>>" : "\n------- Committed new rev " + newRevision + " (loaded from original rev " + baton.myRevision + ") >>>";
            if (this.myProgressHandler != null) {
                SVNAdminEvent event = new SVNAdminEvent(newRevision, baton.myRevision, SVNAdminEventAction.REVISION_LOADED, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
            }
        }
    }

    public void openRevision(Map headers) throws SVNException {
        this.myCurrentRevisionBaton = new RevisionBaton();
        long revision = -1L;
        if (headers.containsKey("Revision-number")) {
            try {
                revision = Long.parseLong((String)headers.get("Revision-number"));
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Cannot parse revision ({0}) in dump file", headers.get("Revision-number"));
                SVNErrorManager.error(err);
            }
        }
        this.myCurrentRevisionBaton.myRevision = revision;
        long headRevision = this.myFSFS.getYoungestRevision();
        this.myCurrentRevisionBaton.myRevisionOffset = revision - (headRevision + 1L);
        if (revision > 0L) {
            this.myCurrentRevisionBaton.myTxn = FSTransactionRoot.beginTransaction(headRevision, 0, this.myFSFS);
            this.myCurrentRevisionBaton.myTxnRoot = this.myFSFS.createTransactionRoot(this.myCurrentRevisionBaton.myTxn.getTxnId());
            String message = "<<< Started new transaction, based on original revision " + revision;
            if (this.myProgressHandler != null) {
                SVNAdminEvent event = new SVNAdminEvent(revision, SVNAdminEventAction.REVISION_LOAD, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
            }
        }
    }

    public void openNode(Map headers) throws SVNException {
        if (this.myCurrentRevisionBaton.myRevision == 0L) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpstream: Revision 0 must not contain node records");
            SVNErrorManager.error(err);
        }
        this.myCurrentNodeBaton = this.createNodeBaton(headers);
        switch (this.myCurrentNodeBaton.myAction) {
            case 0: {
                String message = "     * editing path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler == null) break;
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_EDIT_PATH, this.myCurrentNodeBaton.myPath, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
                break;
            }
            case 2: {
                String message = "     * deleting path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler != null) {
                    SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_DELETE_PATH, this.myCurrentNodeBaton.myPath, message);
                    this.myProgressHandler.handleAdminEvent(event, -1.0);
                }
                this.myCurrentRevisionBaton.getCommitter().deleteNode(this.myCurrentNodeBaton.myPath);
                break;
            }
            case 1: {
                String message = "     * adding path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler != null) {
                    SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_ADD_PATH, this.myCurrentNodeBaton.myPath, message);
                    this.myProgressHandler.handleAdminEvent(event, -1.0);
                }
                this.maybeAddWithHistory(this.myCurrentNodeBaton);
                break;
            }
            case 3: {
                String message = "     * replacing path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler != null) {
                    SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_REPLACE_PATH, this.myCurrentNodeBaton.myPath, message);
                    this.myProgressHandler.handleAdminEvent(event, -1.0);
                }
                this.myCurrentRevisionBaton.getCommitter().deleteNode(this.myCurrentNodeBaton.myPath);
                this.maybeAddWithHistory(this.myCurrentNodeBaton);
                break;
            }
            default: {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_UNRECOGNIZED_DATA, "Unrecognized node-action on node ''{0}''", this.myCurrentNodeBaton.myPath);
                SVNErrorManager.error(err);
            }
        }
    }

    public void parseUUID(String uuid) throws SVNException {
        long latestRevision;
        if (this.myUUIDAction == SVNUUIDAction.IGNORE_UUID) {
            return;
        }
        if (this.myUUIDAction != SVNUUIDAction.FORCE_UUID && (latestRevision = this.myFSFS.getYoungestRevision()) != 0L) {
            return;
        }
        this.myFSFS.setUUID(uuid);
    }

    public void closeNode() throws SVNException {
        this.myCurrentNodeBaton = null;
        SVNDebugLog.getDefaultLog().info(" done.\n");
    }

    public void applyTextDelta() throws SVNException {
        FSDeltaConsumer fsConsumer = this.myCurrentRevisionBaton.getConsumer();
        fsConsumer.applyTextDelta(this.myCurrentNodeBaton.myPath, null);
    }

    public void setFullText() throws SVNException {
        FSDeltaConsumer fsConsumer = this.myCurrentRevisionBaton.getConsumer();
        fsConsumer.applyText(this.myCurrentNodeBaton.myPath);
    }

    public void parseTextBlock(InputStream dumpStream, int contentLength, boolean isDelta) throws SVNException {
        block11: {
            FSDeltaConsumer fsConsumer = this.myCurrentRevisionBaton.getConsumer();
            try {
                if (isDelta) {
                    this.applyTextDelta();
                } else {
                    this.setFullText();
                }
                byte[] buffer = null;
                if (contentLength == 0) {
                    this.getDeltaGenerator().sendDelta(this.myCurrentNodeBaton.myPath, SVNFileUtil.DUMMY_IN, fsConsumer, false);
                    break block11;
                }
                buffer = new byte[16384];
                try {
                    while (contentLength > 0) {
                        int numToRead = contentLength > 16384 ? 16384 : contentLength;
                        int numRead = dumpStream.read(buffer, 0, numToRead);
                        if (numRead != numToRead) {
                            SVNAdminHelper.generateIncompleteDataError();
                        }
                        if (isDelta) {
                            SVNDeltaReader deltaReader = this.getDeltaReader();
                            deltaReader.nextWindow(buffer, 0, numRead, this.myCurrentNodeBaton.myPath, fsConsumer);
                        } else {
                            this.getDeltaGenerator().sendDelta(this.myCurrentNodeBaton.myPath, buffer, numRead, fsConsumer);
                        }
                        contentLength -= numRead;
                    }
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                    SVNErrorManager.error(err, ioe);
                }
                fsConsumer.textDeltaEnd(this.myCurrentNodeBaton.myPath);
            }
            catch (SVNException svne) {
                fsConsumer.abort();
            }
        }
    }

    public int parsePropertyBlock(InputStream dumpStream, int contentLength, boolean isNode) throws SVNException {
        int actualLength = 0;
        StringBuffer buffer = new StringBuffer();
        String line = null;
        try {
            while (contentLength != actualLength) {
                String propName;
                byte[] buff;
                SVNErrorMessage err;
                buffer.setLength(0);
                line = SVNFileUtil.readLineFromStream(dumpStream, buffer);
                if (line == null) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Incomplete or unterminated property block");
                    SVNErrorManager.error(err2);
                }
                actualLength += line.length() + 1;
                if ("PROPS-END".equals(line)) break;
                if (line.charAt(0) == 'K' && line.charAt(1) == ' ') {
                    int len = 0;
                    try {
                        len = Integer.parseInt(line.substring(2));
                    }
                    catch (NumberFormatException nfe) {
                        err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property key length");
                        SVNErrorManager.error(err, nfe);
                    }
                    buff = new byte[len];
                    actualLength += SVNAdminHelper.readKeyOrValue(dumpStream, buff, len);
                    propName = new String(buff, "UTF-8");
                    buffer.setLength(0);
                    line = SVNFileUtil.readLineFromStream(dumpStream, buffer);
                    if (line == null) {
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                    actualLength += line.length() + 1;
                    if (line.charAt(0) == 'V' && line.charAt(1) == ' ') {
                        try {
                            len = Integer.parseInt(line.substring(2));
                        }
                        catch (NumberFormatException nfe) {
                            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property value length");
                            SVNErrorManager.error(err3, nfe);
                        }
                        buff = new byte[len];
                        actualLength += SVNAdminHelper.readKeyOrValue(dumpStream, buff, len);
                        String propValue = new String(buff, "UTF-8");
                        if (isNode) {
                            this.setNodeProperty(propName, propValue);
                            continue;
                        }
                        this.setRevisionProperty(propName, propValue);
                        continue;
                    }
                    SVNAdminHelper.generateStreamMalformedError();
                    continue;
                }
                if (line.charAt(0) == 'D' && line.charAt(1) == ' ') {
                    int len = 0;
                    try {
                        len = Integer.parseInt(line.substring(2));
                    }
                    catch (NumberFormatException nfe) {
                        err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property key length");
                        SVNErrorManager.error(err, nfe);
                    }
                    buff = new byte[len];
                    actualLength += SVNAdminHelper.readKeyOrValue(dumpStream, buff, len);
                    if (!isNode) {
                        SVNAdminHelper.generateStreamMalformedError();
                    }
                    propName = new String(buff, "UTF-8");
                    this.setNodeProperty(propName, null);
                    continue;
                }
                SVNAdminHelper.generateStreamMalformedError();
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
        return actualLength;
    }

    public void removeNodeProperties() throws SVNException {
        FSTransactionRoot txnRoot = this.myCurrentRevisionBaton.myTxnRoot;
        FSRevisionNode node = txnRoot.getRevisionNode(this.myCurrentNodeBaton.myPath);
        Map props = node.getProperties(this.myFSFS);
        Iterator propNames = props.keySet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, propName, null);
        }
    }

    public void setNodeProperty(String propertyName, String propertyValue) throws SVNException {
        this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, propertyName, propertyValue);
    }

    public void setRevisionProperty(String propertyName, String propertyValue) throws SVNException {
        long youngestRevision;
        if (this.myCurrentRevisionBaton.myRevision > 0L) {
            this.myFSFS.setTransactionProperty(this.myCurrentRevisionBaton.myTxn.getTxnId(), propertyName, propertyValue);
            if ("svn:date".equals(propertyName)) {
                this.myCurrentRevisionBaton.myDatestamp = propertyValue;
            }
        } else if (this.myCurrentRevisionBaton.myRevision == 0L && (youngestRevision = this.myFSFS.getYoungestRevision()) == 0L) {
            this.myFSFS.setRevisionProperty(0L, propertyName, propertyValue);
        }
    }

    public void setUsePreCommitHook(boolean use) {
        this.myIsUsePreCommitHook = use;
    }

    public void setUsePostCommitHook(boolean use) {
        this.myIsUsePostCommitHook = use;
    }

    public void setParentDir(String parentDir) {
        this.myParentDir = parentDir;
    }

    public void setUUIDAction(SVNUUIDAction action) {
        this.myUUIDAction = action;
    }

    private SVNDeltaReader getDeltaReader() {
        if (this.myDeltaReader == null) {
            this.myDeltaReader = new SVNDeltaReader();
        }
        return this.myDeltaReader;
    }

    private SVNDeltaGenerator getDeltaGenerator() {
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        return this.myDeltaGenerator;
    }

    private void maybeAddWithHistory(NodeBaton nodeBaton) throws SVNException {
        if (nodeBaton.myCopyFromPath == null) {
            if (nodeBaton.myKind == SVNNodeKind.FILE) {
                this.myCurrentRevisionBaton.getCommitter().makeFile(nodeBaton.myPath);
            } else if (nodeBaton.myKind == SVNNodeKind.DIR) {
                this.myCurrentRevisionBaton.getCommitter().makeDir(nodeBaton.myPath);
            }
        } else {
            long srcRevision = nodeBaton.myCopyFromRevision - this.myCurrentRevisionBaton.myRevisionOffset;
            Long copyFromRevision = new Long(nodeBaton.myCopyFromRevision);
            if (this.myRevisionsMap.containsKey(copyFromRevision)) {
                Long revision = (Long)this.myRevisionsMap.get(copyFromRevision);
                srcRevision = revision;
            }
            if (!SVNRevision.isValidRevisionNumber(srcRevision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Relative source revision {0,number,integer} is not available in current repository", new Long(srcRevision));
                SVNErrorManager.error(err);
            }
            FSRevisionRoot copyRoot = this.myFSFS.createRevisionRoot(srcRevision);
            this.myCurrentRevisionBaton.getCommitter().makeCopy(copyRoot, nodeBaton.myCopyFromPath, nodeBaton.myPath, true);
            SVNDebugLog.getDefaultLog().info("COPIED...");
        }
    }

    private NodeBaton createNodeBaton(Map headers) throws SVNException {
        NodeBaton baton = new NodeBaton();
        baton.myKind = SVNNodeKind.UNKNOWN;
        if (headers.containsKey("Node-path")) {
            String nodePath = (String)headers.get("Node-path");
            baton.myPath = this.myParentDir != null ? SVNPathUtil.concatToAbs(this.myParentDir, nodePath.startsWith("/") ? nodePath.substring(1) : nodePath) : SVNPathUtil.canonicalizeAbsPath(nodePath);
        }
        if (headers.containsKey("Node-kind")) {
            baton.myKind = SVNNodeKind.parseKind((String)headers.get("Node-kind"));
        }
        baton.myAction = -1;
        if (headers.containsKey("Node-action")) {
            String action = (String)headers.get("Node-action");
            if ("change".equals(action)) {
                baton.myAction = 0;
            } else if ("add".equals(action)) {
                baton.myAction = 1;
            } else if ("delete".equals(action)) {
                baton.myAction = 2;
            } else if ("replace".equals(action)) {
                baton.myAction = 3;
            }
        }
        baton.myCopyFromRevision = -1L;
        if (headers.containsKey("Node-copyfrom-rev")) {
            try {
                baton.myCopyFromRevision = Long.parseLong((String)headers.get("Node-copyfrom-rev"));
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Cannot parse revision ({0}) in dump file", headers.get("Node-copyfrom-rev"));
                SVNErrorManager.error(err);
            }
        }
        if (headers.containsKey("Node-copyfrom-path")) {
            String copyFromPath = (String)headers.get("Node-copyfrom-path");
            baton.myCopyFromPath = this.myParentDir != null ? SVNPathUtil.concatToAbs(this.myParentDir, copyFromPath.startsWith("/") ? copyFromPath.substring(1) : copyFromPath) : SVNPathUtil.canonicalizeAbsPath(copyFromPath);
        }
        if (headers.containsKey("Text-content-length")) {
            baton.myTextChecksum = (String)headers.get("Text-content-length");
        }
        return baton;
    }

    private class NodeBaton {
        String myPath;
        SVNNodeKind myKind;
        int myAction;
        long myCopyFromRevision;
        String myCopyFromPath;
        String myTextChecksum;

        private NodeBaton() {
        }
    }

    private class RevisionBaton {
        FSTransactionInfo myTxn;
        FSTransactionRoot myTxnRoot;
        long myRevision;
        long myRevisionOffset;
        String myDatestamp;
        private FSCommitter myCommitter;
        private FSDeltaConsumer myDeltaConsumer;

        private RevisionBaton() {
        }

        public FSDeltaConsumer getConsumer() {
            if (this.myDeltaConsumer == null) {
                this.myDeltaConsumer = new FSDeltaConsumer("", this.myTxnRoot, DefaultLoadHandler.this.myFSFS, this.getCommitter(), null, null);
            }
            return this.myDeltaConsumer;
        }

        public FSCommitter getCommitter() {
            if (this.myCommitter == null) {
                this.myCommitter = new FSCommitter(DefaultLoadHandler.this.myFSFS, this.myTxnRoot, this.myTxn, null, null);
            }
            return this.myCommitter;
        }
    }
}

