/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNDiffCallback
extends AbstractDiffCallback {
    private ISVNDiffGenerator myGenerator;
    private OutputStream myResult;
    private long myRevision2;
    private long myRevision1;
    private static final SVNStatusType[] EMPTY_STATUS = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};

    public SVNDiffCallback(SVNAdminAreaInfo info, ISVNDiffGenerator generator, long rev1, long rev2, OutputStream result) {
        super(info);
        this.myGenerator = generator;
        this.myResult = result;
        this.myRevision1 = rev1;
        this.myRevision2 = rev2;
    }

    public File createTempDirectory() throws SVNException {
        return this.myGenerator.createTempDirectory();
    }

    public boolean isDiffUnversioned() {
        return this.myGenerator.isDiffUnversioned();
    }

    public SVNStatusType directoryAdded(String path, long revision) throws SVNException {
        this.myGenerator.displayAddedDirectory(this.getDisplayPath(path), this.getRevision(this.myRevision1), this.getRevision(revision));
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType directoryDeleted(String path) throws SVNException {
        this.myGenerator.displayDeletedDirectory(this.getDisplayPath(path), this.getRevision(this.myRevision1), this.getRevision(this.myRevision2));
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType[] fileAdded(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, Map originalProperties, Map diff) throws SVNException {
        if (file2 != null) {
            this.myGenerator.displayFileDiff(this.getDisplayPath(path), file1, file2, this.getRevision(revision1), this.getRevision(revision2), mimeType1, mimeType2, this.myResult);
        }
        if (diff != null && !diff.isEmpty()) {
            this.propertiesChanged(path, originalProperties, diff);
        }
        return EMPTY_STATUS;
    }

    public SVNStatusType[] fileChanged(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, Map originalProperties, Map diff) throws SVNException {
        if (file1 != null) {
            this.myGenerator.displayFileDiff(this.getDisplayPath(path), file1, file2, this.getRevision(revision1), this.getRevision(revision2), mimeType1, mimeType2, this.myResult);
        }
        if (diff != null && !diff.isEmpty()) {
            this.propertiesChanged(path, originalProperties, diff);
        }
        return EMPTY_STATUS;
    }

    public SVNStatusType fileDeleted(String path, File file1, File file2, String mimeType1, String mimeType2, Map originalProperties) throws SVNException {
        if (file1 != null) {
            this.myGenerator.displayFileDiff(this.getDisplayPath(path), file1, file2, this.getRevision(this.myRevision1), this.getRevision(this.myRevision2), mimeType1, mimeType2, this.myResult);
        }
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType propertiesChanged(String path, Map originalProperties, Map diff) throws SVNException {
        originalProperties = originalProperties == null ? new HashMap() : originalProperties;
        diff = diff == null ? new HashMap() : diff;
        HashMap regularDiff = new HashMap();
        this.categorizeProperties(diff, regularDiff, null, null);
        if (diff.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        this.myGenerator.displayPropDiff(this.getDisplayPath(path), originalProperties, regularDiff, this.myResult);
        return SVNStatusType.UNKNOWN;
    }

    private String getRevision(long revision) {
        if (revision >= 0L) {
            return "(revision " + revision + ")";
        }
        return "(working copy)";
    }
}

