/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNFileListUtil {
    public static String[] list(File directory) {
        if (!SVNFileUtil.isOSX) {
            return directory.list();
        }
        String[] fileNames = directory.list();
        if (fileNames == null) {
            return null;
        }
        String[] composedFileNames = new String[fileNames.length];
        for (int i = 0; i < composedFileNames.length; ++i) {
            composedFileNames[i] = SVNFileListUtil.compose(fileNames[i]);
        }
        return composedFileNames;
    }

    public static File[] listFiles(File directory) {
        if (!SVNFileUtil.isOSX) {
            return directory.listFiles();
        }
        String[] fileNames = SVNFileListUtil.list(directory);
        if (fileNames == null) {
            return null;
        }
        File[] files = new File[fileNames.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(directory.getPath(), fileNames[i]);
        }
        return files;
    }

    private static String compose(String decomposedString) {
        if (decomposedString == null) {
            return null;
        }
        StringBuffer buffer = null;
        int length = decomposedString.length();
        for (int i = 1; i < length; ++i) {
            char chr = decomposedString.charAt(i);
            if (chr == '\u0300') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUu", "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9", decomposedString, buffer);
                continue;
            }
            if (chr == '\u0301') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUuYy", "\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd", decomposedString, buffer);
                continue;
            }
            if (chr == '\u0302') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUuYy", "\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177", decomposedString, buffer);
                continue;
            }
            if (chr == '\u0303') {
                buffer = SVNFileListUtil.compose(i, "AaNnOoUu", "\u00c3\u00e3\u00d1\u00f1\u00d5\u00f5\u0168\u0169", decomposedString, buffer);
                continue;
            }
            if (chr == '\u0308') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUuYy", "\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff", decomposedString, buffer);
                continue;
            }
            if (chr == '\u030a') {
                buffer = SVNFileListUtil.compose(i, "Aa", "\u00c5\u00e5", decomposedString, buffer);
                continue;
            }
            if (chr == '\u0327') {
                buffer = SVNFileListUtil.compose(i, "Cc", "\u00c7\u00e7", decomposedString, buffer);
                continue;
            }
            if (buffer == null) continue;
            buffer.append(chr);
        }
        if (buffer == null) {
            return decomposedString;
        }
        return buffer.toString();
    }

    private static StringBuffer compose(int i, String decomposedChars, String composedChars, String decomposedString, StringBuffer buffer) {
        char previousChar = decomposedString.charAt(i - 1);
        int decomposedIndex = decomposedChars.indexOf(previousChar);
        if (decomposedIndex >= 0) {
            if (buffer == null) {
                buffer = new StringBuffer(decomposedString.length() + 2);
                buffer.append(decomposedString.substring(0, i - 1));
            } else {
                buffer.delete(buffer.length() - 1, buffer.length());
            }
            buffer.append(composedChars.charAt(decomposedIndex));
        } else if (buffer == null) {
            buffer = new StringBuffer(decomposedString.length() + 2);
            buffer.append(decomposedString.substring(0, i));
        }
        return buffer;
    }
}

