/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNMergeCallback
extends AbstractDiffCallback {
    private boolean myIsDryRun;
    private SVNURL myURL;
    private boolean myIsAddNecessitatedMerge;
    private String myAddedPath = null;
    private boolean myIsForce;
    private SVNDiffOptions myDiffOptions;

    public SVNMergeCallback(SVNAdminAreaInfo info, SVNURL url, boolean force, boolean dryRun, SVNDiffOptions options) {
        super(info);
        this.myURL = url;
        this.myIsDryRun = dryRun;
        this.myIsForce = force;
        this.myDiffOptions = options;
    }

    public File createTempDirectory() throws SVNException {
        return SVNFileUtil.createTempDirectory("merge");
    }

    public boolean isDiffUnversioned() {
        return false;
    }

    public SVNStatusType propertiesChanged(String path, Map originalProperties, Map diff) throws SVNException {
        HashMap regularProps = new HashMap();
        this.categorizeProperties(diff, regularProps, null, null);
        if (regularProps.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        try {
            File file = this.getFile(path);
            SVNStatusType result = SVNPropertiesManager.mergeProperties(this.getWCAccess(), file, originalProperties, regularProps, false, this.myIsDryRun);
            return result;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE || e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) {
                return SVNStatusType.MISSING;
            }
            throw e;
        }
    }

    public SVNStatusType directoryAdded(String path, long revision) throws SVNException {
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, path)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.MISSING;
        }
        SVNURL copyFromURL = this.myURL.appendPath(path, false);
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.NONE) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry != null && !entry.isScheduledForDeletion()) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (!this.myIsDryRun) {
                if (!mergedFile.mkdirs() && SVNFileType.getType(mergedFile) != SVNFileType.DIRECTORY) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", mergedFile);
                    SVNErrorManager.error(err);
                }
                ISVNEventHandler oldEventHandler = dir.getWCAccess().getEventHandler();
                dir.getWCAccess().setEventHandler(null);
                SVNWCManager.add(mergedFile, dir, copyFromURL, revision);
                dir.getWCAccess().setEventHandler(oldEventHandler);
            }
            if (this.myIsDryRun) {
                this.myAddedPath = path;
            }
            return SVNStatusType.CHANGED;
        }
        if (fileType == SVNFileType.DIRECTORY) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry == null || entry.isScheduledForDeletion()) {
                if (!this.myIsDryRun) {
                    ISVNEventHandler oldEventHandler = dir.getWCAccess().getEventHandler();
                    dir.getWCAccess().setEventHandler(null);
                    SVNWCManager.add(mergedFile, dir, copyFromURL, revision);
                    dir.getWCAccess().setEventHandler(oldEventHandler);
                }
                if (this.myIsDryRun) {
                    this.myAddedPath = path;
                }
                return SVNStatusType.CHANGED;
            }
            if (this.myIsDryRun && this.isPathDeleted(path)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            SVNEntry entry;
            if (this.myIsDryRun) {
                this.myAddedPath = null;
            }
            if ((entry = this.getWCAccess().getEntry(mergedFile, false)) != null && this.myIsDryRun && this.isPathDeleted(path)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (this.myIsDryRun) {
            this.myAddedPath = null;
        }
        return SVNStatusType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType directoryDeleted(String path) throws SVNException {
        final File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            return SVNStatusType.MISSING;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.DIRECTORY) {
            final ISVNEventHandler oldEventHandler = this.getWCAccess().getEventHandler();
            ISVNEventHandler handler = new ISVNEventHandler(){

                public void checkCancelled() throws SVNCancelException {
                    oldEventHandler.checkCancelled();
                }

                public void handleEvent(SVNEvent event, double progress) throws SVNException {
                    if (event.getFile().equals(mergedFile)) {
                        return;
                    }
                    if (event.getAction() == SVNEventAction.DELETE) {
                        event = SVNEventFactory.createMergeEvent(SVNMergeCallback.this.getAdminInfo(), event.getFile(), SVNEventAction.UPDATE_DELETE, SVNEventAction.UPDATE_DELETE, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, event.getNodeKind());
                    }
                    oldEventHandler.handleEvent(event, progress);
                }
            };
            this.getWCAccess().setEventHandler(handler);
            try {
                this.delete(mergedFile, this.myIsForce, this.myIsDryRun);
            }
            catch (SVNException e) {
                SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                return sVNStatusType;
            }
            finally {
                this.getWCAccess().setEventHandler(oldEventHandler);
            }
            return SVNStatusType.CHANGED;
        }
        if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.NONE) {
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType[] fileChanged(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, Map originalProperties, Map diff) throws SVNException {
        boolean needsMerge = true;
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), this.myIsDryRun);
        if (dir == null) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        SVNStatusType[] result = new SVNStatusType[]{SVNStatusType.UNCHANGED, SVNStatusType.UNCHANGED};
        SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
        SVNFileType fileType = null;
        if (entry != null) {
            fileType = SVNFileType.getType(mergedFile);
        }
        if (entry == null || fileType != SVNFileType.FILE) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        if (diff != null && !diff.isEmpty()) {
            result[1] = this.propertiesChanged(path, originalProperties, diff);
        }
        String name = mergedFile.getName();
        if (file1 != null) {
            boolean same;
            boolean textModified = dir.hasTextModifications(name, false);
            if (!textModified && (SVNProperty.isBinaryMimeType(mimeType1) || SVNProperty.isBinaryMimeType(mimeType2)) && (same = SVNFileUtil.compareFiles(!this.myIsAddNecessitatedMerge ? file1 : file2, mergedFile, null))) {
                if (!this.myIsDryRun && !this.myIsAddNecessitatedMerge) {
                    SVNFileUtil.rename(file2, mergedFile);
                }
                result[0] = SVNStatusType.CHANGED;
                needsMerge = false;
            }
            if (needsMerge) {
                String latestLabel;
                String localLabel = ".working";
                String baseLabel = ".merge-left.r" + revision1;
                SVNStatusType mergeResult = dir.mergeText(name, file1, file2, localLabel, baseLabel, latestLabel = ".merge-right.r" + revision2, false, this.myIsDryRun, this.myDiffOptions);
                result[0] = mergeResult == SVNStatusType.CONFLICTED || mergeResult == SVNStatusType.CONFLICTED_UNRESOLVED ? mergeResult : (textModified ? SVNStatusType.MERGED : (mergeResult == SVNStatusType.MERGED ? SVNStatusType.CHANGED : SVNStatusType.UNCHANGED));
            }
        }
        return result;
    }

    public SVNStatusType[] fileAdded(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, Map originalProperties, Map diff) throws SVNException {
        SVNStatusType[] result = new SVNStatusType[]{null, SVNStatusType.UNKNOWN};
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, path)) {
                result[0] = SVNStatusType.CHANGED;
                result[1] = SVNStatusType.CHANGED;
            } else {
                result[0] = SVNStatusType.MISSING;
            }
            return result;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.NONE) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry != null && !entry.isScheduledForDeletion()) {
                result[0] = SVNStatusType.OBSTRUCTED;
                return result;
            }
            if (!this.myIsDryRun) {
                SVNURL copyFromURL = this.myURL.appendPath(path, false);
                SVNWCManager.addRepositoryFile(dir, mergedFile.getName(), null, file2, null, diff, copyFromURL.toString(), revision2);
            }
            result[0] = SVNStatusType.CHANGED;
            if (diff != null && !diff.isEmpty()) {
                result[1] = SVNStatusType.CHANGED;
            }
        } else if (fileType == SVNFileType.DIRECTORY || fileType == SVNFileType.SYMLINK) {
            result[0] = this.myIsDryRun && this.isPathDeleted(path) ? SVNStatusType.CHANGED : SVNStatusType.OBSTRUCTED;
        } else if (fileType == SVNFileType.FILE) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry == null || entry.isScheduledForDeletion()) {
                result[0] = SVNStatusType.OBSTRUCTED;
            } else if (this.myIsDryRun && this.isPathDeleted(path)) {
                result[0] = SVNStatusType.CHANGED;
            } else {
                this.myIsAddNecessitatedMerge = true;
                result = this.fileChanged(path, file1, file2, revision1, revision2, mimeType1, mimeType2, originalProperties, diff);
                this.myIsAddNecessitatedMerge = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType fileDeleted(String path, File file1, File file2, String mimeType1, String mimeType2, Map originalProperties) throws SVNException {
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            return SVNStatusType.MISSING;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            ISVNEventHandler oldEventHandler = this.getWCAccess().getEventHandler();
            this.getWCAccess().setEventHandler(null);
            try {
                this.delete(mergedFile, this.myIsForce, this.myIsDryRun);
            }
            catch (SVNException e) {
                SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                return sVNStatusType;
            }
            finally {
                this.getWCAccess().setEventHandler(oldEventHandler);
            }
            return SVNStatusType.CHANGED;
        }
        if (fileType == SVNFileType.DIRECTORY) {
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.NONE) {
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.UNKNOWN;
    }

    protected File getFile(String path) {
        return this.getAdminInfo().getTarget().getFile(path);
    }

    protected SVNAdminArea retrieve(File path, boolean lenient) throws SVNException {
        if (this.getAdminInfo() == null) {
            return null;
        }
        try {
            return this.getAdminInfo().getWCAccess().retrieve(path);
        }
        catch (SVNException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
    }

    protected void delete(File path, boolean force, boolean dryRun) throws SVNException {
        if (!force) {
            SVNWCManager.canDelete(path, false, this.getWCAccess().getOptions());
        }
        SVNAdminArea root = this.getWCAccess().retrieve(path.getParentFile());
        if (!dryRun) {
            SVNWCManager.delete(this.getWCAccess(), root, path, true);
        }
    }
}

