/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNPropertiesManager {
    private static final Collection NOT_ALLOWED_FOR_FILE = new HashSet();
    private static final Collection NOT_ALLOWED_FOR_DIR = new HashSet();

    public static void setWCProperty(SVNWCAccess access, File path, String propName, String propValue, boolean write) throws SVNException {
        SVNEntry entry = access.getEntry(path, false);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
            SVNErrorManager.error(err);
        }
        SVNAdminArea dir = entry.getKind() == SVNNodeKind.DIR ? access.retrieve(path) : access.retrieve(path.getParentFile());
        dir.getWCProperties(entry.getName()).setPropertyValue(propName, propValue);
        if (write) {
            dir.saveWCProperties(false);
        }
    }

    public static String getWCProperty(SVNWCAccess access, File path, String propName) throws SVNException {
        SVNEntry entry = access.getEntry(path, false);
        if (entry == null) {
            return null;
        }
        SVNAdminArea dir = entry.getKind() == SVNNodeKind.DIR ? access.retrieve(path) : access.retrieve(path.getParentFile());
        return dir.getWCProperties(entry.getName()).getPropertyValue(propName);
    }

    public static void deleteWCProperties(SVNAdminArea dir, String name, boolean recursive) throws SVNException {
        SVNVersionedProperties props;
        if (name != null && (props = dir.getWCProperties(name)) != null) {
            props.removeAll();
        }
        if (recursive || name == null) {
            Iterator entries = dir.entries(false);
            while (entries.hasNext()) {
                SVNVersionedProperties props2;
                SVNEntry entry = (SVNEntry)entries.next();
                if (name != null && (props2 = dir.getWCProperties(entry.getName())) != null) {
                    props2.removeAll();
                }
                if (dir.getThisDirName().equals(entry.getName()) || entry.isFile() || !recursive) continue;
                SVNAdminArea childDir = dir.getWCAccess().retrieve(dir.getFile(entry.getName()));
                SVNPropertiesManager.deleteWCProperties(childDir, null, true);
            }
        }
        dir.saveWCProperties(false);
    }

    public static String getProperty(SVNWCAccess access, File path, String propName) throws SVNException {
        SVNEntry entry = access.getEntry(path, false);
        if (entry == null) {
            return null;
        }
        String[] cachableProperties = entry.getCachableProperties();
        if (cachableProperties != null && SVNPropertiesManager.contains(cachableProperties, propName)) {
            String[] presentProperties = entry.getPresentProperties();
            if (presentProperties == null || !SVNPropertiesManager.contains(presentProperties, propName)) {
                return null;
            }
            if (SVNProperty.isBooleanProperty(propName)) {
                return SVNProperty.getValueOfBooleanProperty(propName);
            }
        }
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            return SVNPropertiesManager.getWCProperty(access, path, propName);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err);
        }
        SVNAdminArea dir = entry.getKind() == SVNNodeKind.DIR ? access.retrieve(path) : access.retrieve(path.getParentFile());
        return dir.getProperties(entry.getName()).getPropertyValue(propName);
    }

    public static void setProperty(SVNWCAccess access, File path, String propName, String propValue, boolean skipChecks) throws SVNException {
        SVNEntry entry;
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            SVNPropertiesManager.setWCProperty(access, path, propName, propValue, true);
            return;
        }
        if (SVNProperty.isEntryProperty(propName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err);
        }
        if ((entry = access.getEntry(path, false)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
            SVNErrorManager.error(err);
        }
        SVNAdminArea dir = entry.getKind() == SVNNodeKind.DIR ? access.retrieve(path) : access.retrieve(path.getParentFile());
        boolean updateTimeStamp = "svn:eol-style".equals(propName);
        if (propValue != null) {
            SVNPropertiesManager.validatePropertyName(path, propName, entry.getKind());
            if (!skipChecks && "svn:eol-style".equals(propName)) {
                propValue = propValue.trim();
                SVNPropertiesManager.validateEOLProperty(path, access);
            } else if (!skipChecks && "svn:mime-type".equals(propName)) {
                propValue = propValue.trim();
                SVNPropertiesManager.validateMimeType(propValue);
            } else if ("svn:externals".equals(propName) || "svn:ignore".equals(propName)) {
                if (!propValue.endsWith("\n")) {
                    propValue = propValue + "\n";
                }
                if ("svn:externals".equals(propName)) {
                    // empty if block
                }
            } else if ("svn:keywords".equals(propName)) {
                propValue = propValue.trim();
            }
        }
        if (entry.getKind() == SVNNodeKind.FILE && "svn:executable".equals(propName)) {
            if (propValue == null) {
                SVNFileUtil.setExecutable(path, false);
            } else {
                propValue = SVNProperty.getValueOfBooleanProperty(propName);
                SVNFileUtil.setExecutable(path, true);
            }
        }
        if (entry.getKind() == SVNNodeKind.FILE && "svn:needs-lock".equals(propName)) {
            if (propValue == null) {
                SVNFileUtil.setReadonly(path, false);
            } else {
                propValue = SVNProperty.getValueOfBooleanProperty(propName);
            }
        }
        SVNVersionedProperties properties = dir.getProperties(entry.getName());
        if (!updateTimeStamp && entry.getKind() == SVNNodeKind.FILE && "svn:keywords".equals(propName)) {
            Collection newKeywords;
            String oldValue = properties.getPropertyValue("svn:keywords");
            Collection oldKeywords = SVNPropertiesManager.getKeywords(oldValue);
            updateTimeStamp = !((Object)oldKeywords).equals(newKeywords = SVNPropertiesManager.getKeywords(propValue));
        }
        SVNLog log = dir.getLog();
        if (updateTimeStamp) {
            HashMap<String, String> command = new HashMap<String, String>();
            command.put("name", entry.getName());
            command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), null);
            log.addCommand("modify-entry", command, false);
        }
        properties.setPropertyValue(propName, propValue);
        dir.saveVersionedProperties(log, false);
        log.save();
        dir.runLogs();
    }

    public static SVNStatusType mergeProperties(SVNWCAccess wcAccess, File path, Map baseProperties, Map diff, boolean baseMerge, boolean dryRun) throws SVNException {
        SVNEntry entry = wcAccess.getEntry(path, false);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
            SVNErrorManager.error(err);
        }
        File parent = null;
        String name = null;
        if (entry.isDirectory()) {
            parent = path;
            name = "";
        } else if (entry.isFile()) {
            parent = path.getParentFile();
            name = entry.getName();
        }
        SVNLog log = null;
        SVNAdminArea dir = wcAccess.retrieve(parent);
        if (!dryRun) {
            log = dir.getLog();
        }
        SVNStatusType result = dir.mergeProperties(name, baseProperties, diff, baseMerge, dryRun, log);
        if (!dryRun) {
            log.save();
            dir.runLogs();
        }
        return result;
    }

    public static Map computeAutoProperties(ISVNOptions options, File file) {
        String mimeType;
        Map properties = options.applyAutoProperties(file, null);
        if (!properties.containsKey("svn:mime-type") && (mimeType = SVNFileUtil.detectMimeType(file)) != null) {
            properties.put("svn:mime-type", mimeType);
        }
        if (SVNProperty.isBinaryMimeType((String)properties.get("svn:mime-type"))) {
            properties.remove("svn:eol-style");
        }
        if (!properties.containsKey("svn:executable") && SVNFileUtil.isExecutable(file)) {
            properties.put("svn:executable", SVNProperty.getValueOfBooleanProperty("svn:executable"));
        }
        return properties;
    }

    private static void validatePropertyName(File path, String name, SVNNodeKind kind) throws SVNException {
        SVNErrorMessage err = null;
        if (kind == SVNNodeKind.DIR) {
            if (NOT_ALLOWED_FOR_DIR.contains(name)) {
                err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a directory (''{1}'')", new Object[]{name, path});
            }
        } else if (kind == SVNNodeKind.FILE) {
            if (NOT_ALLOWED_FOR_FILE.contains(name)) {
                err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a file (''{1}'')", new Object[]{name, path});
            }
        } else {
            err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "''{0}'' is not a file or directory", path);
        }
        if (err != null) {
            SVNErrorManager.error(err);
        }
    }

    private static void validateEOLProperty(File path, SVNWCAccess access) throws SVNException {
        boolean consistent;
        String mimeType = SVNPropertiesManager.getProperty(access, path, "svn:mime-type");
        if (mimeType != null && SVNProperty.isBinaryMimeType(mimeType)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has binary mime type property", path);
            SVNErrorManager.error(err);
        }
        if (!(consistent = SVNTranslator.checkNewLines(path))) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has inconsistent newlines", path);
            SVNErrorManager.error(err);
        }
    }

    private static void validateMimeType(String value) throws SVNException {
        String type = value.indexOf(59) >= 0 ? value.substring(0, value.indexOf(59)) : value;
        SVNErrorMessage err = null;
        if (type.length() == 0) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' has empty media type", value);
        } else if (type.indexOf(47) < 0) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' does not contain ''/''", value);
        } else if (!Character.isLetterOrDigit(type.charAt(type.length() - 1))) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' ends with non-alphanumeric character", value);
        }
        if (err != null) {
            SVNErrorManager.error(err);
        }
    }

    private static Collection getKeywords(String value) {
        HashSet<String> keywords = new HashSet<String>();
        if (value == null || "".equals(value.trim())) {
            return keywords;
        }
        StringTokenizer tokens = new StringTokenizer(value, " \t\n\r");
        while (tokens.hasMoreTokens()) {
            keywords.add(tokens.nextToken().toLowerCase());
        }
        return keywords;
    }

    private static boolean contains(String[] values, String value) {
        for (int i = 0; value != null && i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    static {
        NOT_ALLOWED_FOR_FILE.add("svn:ignore");
        NOT_ALLOWED_FOR_FILE.add("svn:externals");
        NOT_ALLOWED_FOR_DIR.add("svn:executable");
        NOT_ALLOWED_FOR_DIR.add("svn:keywords");
        NOT_ALLOWED_FOR_DIR.add("svn:eol-style");
        NOT_ALLOWED_FOR_DIR.add("svn:needs-lock");
        NOT_ALLOWED_FOR_DIR.add("svn:mime-type");
    }
}

