/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNStatusEditor {
    private SVNWCAccess myWCAccess;
    private SVNAdminAreaInfo myAdminInfo;
    private boolean myIsReportAll;
    private boolean myIsNoIgnore;
    private boolean myIsDescend;
    private ISVNStatusHandler myStatusHandler;
    private Map myExternalsMap;
    private Collection myGlobalIgnores;
    private SVNURL myRepositoryRoot;
    private Map myRepositoryLocks;
    private long myTargetRevision;
    private Map myExternalsInfo;

    public SVNStatusEditor(ISVNOptions options, SVNWCAccess wcAccess, SVNAdminAreaInfo info, boolean noIgnore, boolean reportAll, boolean descend, ISVNStatusHandler handler) {
        this.myWCAccess = wcAccess;
        this.myAdminInfo = info;
        this.myIsNoIgnore = noIgnore;
        this.myIsReportAll = reportAll;
        this.myIsDescend = descend;
        this.myStatusHandler = handler;
        this.myExternalsMap = new HashMap();
        this.myExternalsInfo = new HashMap();
        this.myGlobalIgnores = SVNStatusEditor.getGlobalIgnores(options);
        this.myTargetRevision = -1L;
    }

    public void setExternals(Map externals) {
        if (externals != null) {
            this.myExternalsMap = externals;
        }
    }

    public Map getExternals() {
        return this.myExternalsMap;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long revision) {
        this.myTargetRevision = revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVNCommitInfo closeEdit() throws SVNException {
        block10: {
            try {
                block9: {
                    block11: {
                        if (!this.hasTarget()) break block11;
                        File path = this.myAdminInfo.getAnchor().getFile(this.myAdminInfo.getTargetName());
                        SVNFileType type = SVNFileType.getType(path);
                        if (type == SVNFileType.DIRECTORY) {
                            SVNEntry entry = this.myWCAccess.getEntry(path, false);
                            if (entry == null) {
                                this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), false, this.myIsReportAll, true, null, true, this.myStatusHandler);
                                break block9;
                            } else {
                                SVNAdminArea target = this.myWCAccess.retrieve(path);
                                this.getDirStatus(null, target, null, this.myIsDescend, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
                            }
                            break block9;
                        } else {
                            this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), false, this.myIsReportAll, true, null, true, this.myStatusHandler);
                        }
                        break block9;
                    }
                    this.getDirStatus(null, this.myAdminInfo.getAnchor(), null, this.myIsDescend, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
                }
                Object var6_5 = null;
                if (!this.hasTarget() || !this.myExternalsInfo.containsKey(this.myAdminInfo.getAnchor())) break block10;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.hasTarget() && this.myExternalsInfo.containsKey(this.myAdminInfo.getAnchor())) {
                    SVNExternalInfo[] anchorExternals = (SVNExternalInfo[])this.myExternalsInfo.get(this.myAdminInfo.getAnchor());
                    for (int i = 0; i < anchorExternals.length; ++i) {
                        this.myExternalsMap.remove(anchorExternals[i].getPath());
                    }
                }
                this.cleanup();
                throw throwable;
            }
            SVNExternalInfo[] anchorExternals = (SVNExternalInfo[])this.myExternalsInfo.get(this.myAdminInfo.getAnchor());
            for (int i = 0; i < anchorExternals.length; ++i) {
                this.myExternalsMap.remove(anchorExternals[i].getPath());
            }
        }
        this.cleanup();
        return null;
    }

    public void setRepositoryInfo(SVNURL root, Map repositoryLocks) {
        this.myRepositoryRoot = root;
        this.myRepositoryLocks = repositoryLocks;
    }

    protected void getDirStatus(SVNEntry parentEntry, SVNAdminArea dir, String entryName, boolean descend, boolean getAll, boolean noIgnore, Collection ignorePatterns, boolean skipThisDir, ISVNStatusHandler handler) throws SVNException {
        SVNStatus status;
        File file;
        this.myWCAccess.checkCancelled();
        TreeMap childrenFiles = SVNStatusEditor.getChildrenFiles(dir.getRoot());
        SVNEntry dirEntry = this.myWCAccess.getEntry(dir.getRoot(), false);
        String externals = dir.getProperties("").getPropertyValue("svn:externals");
        if (externals != null) {
            SVNExternalInfo[] externalsInfo = SVNWCAccess.parseExternals(dir.getRelativePath(this.myAdminInfo.getAnchor()), externals);
            for (int i = 0; i < externalsInfo.length; ++i) {
                SVNExternalInfo external = externalsInfo[i];
                this.myExternalsMap.put(external.getPath(), external);
            }
            this.myExternalsInfo.put(dir, externalsInfo);
        }
        if (entryName != null) {
            File file2 = (File)childrenFiles.get(entryName);
            SVNEntry entry = dir.getEntry(entryName, false);
            if (entry != null) {
                SVNFileType fileType = SVNFileType.getType(file2);
                boolean special = fileType == SVNFileType.SYMLINK;
                SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
                this.handleDirEntry(dir, entryName, dirEntry, entry, fileKind, special, descend, getAll, noIgnore, handler);
            } else {
                if (ignorePatterns == null) {
                    ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
                }
                if (file2 == null) {
                    file2 = new File(dir.getRoot(), entryName);
                }
                this.sendUnversionedStatus(file2, entryName, SVNNodeKind.NONE, false, dir, ignorePatterns, noIgnore, handler);
            }
            return;
        }
        childrenFiles = new TreeMap(childrenFiles);
        Iterator files = childrenFiles.keySet().iterator();
        while (files.hasNext()) {
            String fileName = (String)files.next();
            if (dir.getEntry(fileName, false) != null || SVNFileUtil.getAdminDirectoryName().equals(fileName)) continue;
            if (ignorePatterns == null) {
                ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
            }
            file = (File)childrenFiles.get(fileName);
            this.sendUnversionedStatus(file, fileName, SVNNodeKind.NONE, false, dir, ignorePatterns, noIgnore, handler);
        }
        if (!skipThisDir && (status = this.assembleStatus(dir.getRoot(), dir, dirEntry, parentEntry, SVNNodeKind.DIR, false, getAll, false)) != null && handler != null) {
            handler.handleStatus(status);
        }
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if ("".equals(entry.getName())) continue;
            file = (File)childrenFiles.get(entry.getName());
            SVNFileType fileType = SVNFileType.getType(file);
            boolean special = fileType == SVNFileType.SYMLINK;
            SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
            this.handleDirEntry(dir, entry.getName(), dirEntry, entry, fileKind, special, descend, getAll, noIgnore, handler);
        }
    }

    protected void cleanup() {
        if (this.hasTarget()) {
            this.myExternalsMap.remove(this.myAdminInfo.getAnchor().getRoot());
        }
    }

    protected SVNAdminArea getAnchor() {
        return this.myAdminInfo.getAnchor();
    }

    protected SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    protected boolean isDescend() {
        return this.myIsDescend;
    }

    protected boolean isReportAll() {
        return this.myIsReportAll;
    }

    protected boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    protected SVNAdminAreaInfo getAdminAreaInfo() {
        return this.myAdminInfo;
    }

    protected ISVNStatusHandler getDefaultHandler() {
        return this.myStatusHandler;
    }

    protected boolean hasTarget() {
        return this.myAdminInfo.getTargetName() != null && !"".equals(this.myAdminInfo.getTargetName());
    }

    protected SVNLock getLock(SVNURL url) {
        String root;
        if (this.myRepositoryRoot == null || this.myRepositoryLocks == null || this.myRepositoryLocks.isEmpty() || url == null) {
            return null;
        }
        String urlString = url.getPath();
        String path = urlString.equals(root = this.myRepositoryRoot.getPath()) ? "/" : urlString.substring(root.length());
        return (SVNLock)this.myRepositoryLocks.get(path);
    }

    private void handleDirEntry(SVNAdminArea dir, String entryName, SVNEntry dirEntry, SVNEntry entry, SVNNodeKind fileKind, boolean special, boolean descend, boolean getAll, boolean noIgnore, ISVNStatusHandler handler) throws SVNException {
        File path = dir.getFile(entryName);
        if (fileKind == SVNNodeKind.DIR) {
            SVNAdminArea childDir;
            SVNEntry fullEntry = entry;
            if (entry.getKind() == fileKind && (fullEntry = this.myWCAccess.getEntry(path, false)) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err);
            }
            if (descend && fullEntry != entry) {
                childDir = this.myWCAccess.retrieve(path);
                this.getDirStatus(dirEntry, childDir, null, descend, getAll, noIgnore, null, false, handler);
            } else if (fullEntry != entry) {
                childDir = this.myWCAccess.retrieve(path);
                SVNStatus status = this.assembleStatus(path, childDir, fullEntry, dirEntry, fileKind, special, getAll, false);
                if (status != null && handler != null) {
                    handler.handleStatus(status);
                }
            } else {
                SVNStatus status = this.assembleStatus(path, dir, fullEntry, dirEntry, fileKind, special, getAll, false);
                if (status != null && handler != null) {
                    handler.handleStatus(status);
                }
            }
        } else {
            SVNStatus status = this.assembleStatus(path, dir, entry, dirEntry, fileKind, special, getAll, false);
            if (status != null && handler != null) {
                handler.handleStatus(status);
            }
        }
    }

    private void sendUnversionedStatus(File file, String name, SVNNodeKind fileType, boolean special, SVNAdminArea dir, Collection ignorePatterns, boolean noIgnore, ISVNStatusHandler handler) throws SVNException {
        boolean isIgnored = SVNStatusEditor.isIgnored(ignorePatterns, name);
        String path = dir.getRelativePath(this.myAdminInfo.getAnchor());
        path = SVNPathUtil.append(path, name);
        boolean isExternal = this.isExternal(path);
        SVNStatus status = this.assembleStatus(file, dir, null, null, fileType, special, true, isIgnored);
        if (status != null) {
            if (isExternal) {
                status.setContentsStatus(SVNStatusType.STATUS_EXTERNAL);
            }
            if (handler != null && noIgnore || !isIgnored || isExternal || status.getRemoteLock() != null) {
                handler.handleStatus(status);
            }
        }
    }

    protected SVNStatus assembleStatus(File file, SVNAdminArea dir, SVNEntry entry, SVNEntry parentEntry, SVNNodeKind fileKind, boolean special, boolean reportAll, boolean isIgnored) throws SVNException {
        boolean hasProps = false;
        boolean isTextModified = false;
        boolean isPropsModified = false;
        boolean isLocked = false;
        boolean isSwitched = false;
        boolean isSpecial = false;
        SVNStatusType textStatus = SVNStatusType.STATUS_NORMAL;
        SVNStatusType propStatus = SVNStatusType.STATUS_NONE;
        SVNLock repositoryLock = null;
        if (this.myRepositoryLocks != null) {
            SVNURL url = null;
            if (entry != null && entry.getSVNURL() != null) {
                url = entry.getSVNURL();
            } else if (parentEntry != null && parentEntry.getSVNURL() != null) {
                url = parentEntry.getSVNURL().appendPath(file.getName(), false);
            }
            if (url != null) {
                repositoryLock = this.getLock(url);
            }
        }
        if (fileKind == SVNNodeKind.UNKNOWN || fileKind == null) {
            SVNFileType fileType = SVNFileType.getType(file);
            fileKind = SVNFileType.getNodeKind(fileType);
            boolean bl = SVNFileUtil.isWindows ? false : (special = fileType == SVNFileType.SYMLINK);
        }
        if (entry == null) {
            SVNStatus status = new SVNStatus(null, file, SVNNodeKind.NONE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, null, null, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, false, false, false, null, null, null, null, null, SVNRevision.UNDEFINED, repositoryLock, null, null);
            status.setRemoteStatus(SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, repositoryLock, SVNNodeKind.NONE);
            SVNStatusType text = SVNStatusType.STATUS_NONE;
            SVNFileType fileType = SVNFileType.getType(file);
            if (fileType != SVNFileType.NONE) {
                text = isIgnored ? SVNStatusType.STATUS_IGNORED : SVNStatusType.STATUS_UNVERSIONED;
            }
            status.setContentsStatus(text);
            return status;
        }
        if (entry.getKind() == SVNNodeKind.DIR) {
            if (fileKind == SVNNodeKind.DIR) {
                if (this.myWCAccess.isMissing(file)) {
                    textStatus = SVNStatusType.STATUS_OBSTRUCTED;
                }
            } else if (fileKind != SVNNodeKind.NONE) {
                textStatus = SVNStatusType.STATUS_OBSTRUCTED;
            }
        }
        if (entry.getSVNURL() != null && parentEntry != null && parentEntry.getSVNURL() != null) {
            String urlName = SVNPathUtil.tail(entry.getSVNURL().getURIEncodedPath());
            if (!SVNEncodingUtil.uriEncode(file.getName()).equals(urlName)) {
                isSwitched = true;
            }
            if (!isSwitched && !entry.getSVNURL().removePathTail().equals(parentEntry.getSVNURL())) {
                isSwitched = true;
            }
        }
        if (textStatus != SVNStatusType.STATUS_OBSTRUCTED) {
            String name = entry.getName();
            if (dir != null && dir.hasProperties(name)) {
                propStatus = SVNStatusType.STATUS_NORMAL;
                hasProps = true;
            }
            boolean bl = isPropsModified = dir != null && dir.hasPropModifications(name);
            if (hasProps) {
                boolean bl2 = isSpecial = !SVNFileUtil.isWindows && dir != null && dir.getProperties(name).getPropertyValue("svn:special") != null;
            }
            if (entry.getKind() == SVNNodeKind.FILE && special == isSpecial) {
                boolean bl3 = isTextModified = dir != null && dir.hasTextModifications(name, false);
            }
            if (isTextModified) {
                textStatus = SVNStatusType.STATUS_MODIFIED;
            }
            if (isPropsModified) {
                propStatus = SVNStatusType.STATUS_MODIFIED;
            }
            if (entry.getPropRejectFile() != null || entry.getConflictOld() != null || entry.getConflictNew() != null || entry.getConflictWorking() != null) {
                if (dir != null && dir.hasTextConflict(name)) {
                    textStatus = SVNStatusType.STATUS_CONFLICTED;
                }
                if (dir != null && dir.hasPropConflict(name)) {
                    propStatus = SVNStatusType.STATUS_CONFLICTED;
                }
            }
            if (entry.isScheduledForAddition() && textStatus != SVNStatusType.STATUS_CONFLICTED) {
                textStatus = SVNStatusType.STATUS_ADDED;
                propStatus = SVNStatusType.STATUS_NONE;
            } else if (entry.isScheduledForReplacement() && textStatus != SVNStatusType.STATUS_CONFLICTED) {
                textStatus = SVNStatusType.STATUS_REPLACED;
                propStatus = SVNStatusType.STATUS_NONE;
            } else if (entry.isScheduledForDeletion() && textStatus != SVNStatusType.STATUS_CONFLICTED) {
                textStatus = SVNStatusType.STATUS_DELETED;
                propStatus = SVNStatusType.STATUS_NONE;
            }
            if (entry.isIncomplete() && textStatus != SVNStatusType.STATUS_DELETED && textStatus != SVNStatusType.STATUS_ADDED) {
                textStatus = SVNStatusType.STATUS_INCOMPLETE;
            } else if (fileKind == SVNNodeKind.NONE) {
                if (textStatus != SVNStatusType.STATUS_DELETED) {
                    textStatus = SVNStatusType.STATUS_MISSING;
                }
            } else if (fileKind != entry.getKind()) {
                textStatus = SVNStatusType.STATUS_OBSTRUCTED;
            } else if (!isSpecial && special || isSpecial && !special) {
                textStatus = SVNStatusType.STATUS_OBSTRUCTED;
            }
            if (fileKind == SVNNodeKind.DIR && entry.getKind() == SVNNodeKind.DIR) {
                isLocked = this.myWCAccess.isLocked(file);
            }
        }
        if (!(reportAll || textStatus != SVNStatusType.STATUS_NONE && textStatus != SVNStatusType.STATUS_NORMAL || propStatus != SVNStatusType.STATUS_NONE && propStatus != SVNStatusType.STATUS_NORMAL || isLocked || isSwitched || entry.getLockToken() != null || repositoryLock != null)) {
            return null;
        }
        SVNLock localLock = null;
        if (entry.getLockToken() != null) {
            localLock = new SVNLock(null, entry.getLockToken(), entry.getLockOwner(), entry.getLockComment(), SVNTimeUtil.parseDate(entry.getLockCreationDate()), null);
        }
        File conflictNew = dir != null ? dir.getFile(entry.getConflictNew()) : null;
        File conflictOld = dir != null ? dir.getFile(entry.getConflictOld()) : null;
        File conflictWrk = dir != null ? dir.getFile(entry.getConflictWorking()) : null;
        File conflictProp = dir != null ? dir.getFile(entry.getPropRejectFile()) : null;
        SVNStatus status = new SVNStatus(entry.getSVNURL(), file, entry.getKind(), SVNRevision.create(entry.getRevision()), SVNRevision.create(entry.getCommittedRevision()), SVNTimeUtil.parseDate(entry.getCommittedDate()), entry.getAuthor(), textStatus, propStatus, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, isLocked, entry.isCopied(), isSwitched, conflictNew, conflictOld, conflictWrk, conflictProp, entry.getCopyFromURL(), SVNRevision.create(entry.getCopyFromRevision()), repositoryLock, localLock, entry.asMap());
        status.setEntry(entry);
        return status;
    }

    private boolean isExternal(String path) {
        if (!this.myExternalsMap.containsKey(path)) {
            Iterator paths = this.myExternalsMap.keySet().iterator();
            while (paths.hasNext()) {
                String externalPath = (String)paths.next();
                if (!externalPath.startsWith(path + "/")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static Collection getIgnorePatterns(SVNAdminArea dir, Collection globalIgnores) throws SVNException {
        String localIgnores = dir.getProperties("").getPropertyValue("svn:ignore");
        if (localIgnores != null) {
            HashSet<String> patterns = new HashSet<String>();
            patterns.addAll(globalIgnores);
            StringTokenizer tokens = new StringTokenizer(localIgnores, "\r\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                patterns.add(token);
            }
            return patterns;
        }
        return globalIgnores;
    }

    public static Collection getGlobalIgnores(ISVNOptions options) {
        String[] ignores = options.getIgnorePatterns();
        if (ignores != null) {
            HashSet<String> patterns = new HashSet<String>();
            for (int i = 0; i < ignores.length; ++i) {
                patterns.add(ignores[i]);
            }
            return patterns;
        }
        return Collections.EMPTY_SET;
    }

    public static boolean isIgnored(Collection patterns, String name) {
        Iterator ps = patterns.iterator();
        while (ps.hasNext()) {
            String pattern = (String)ps.next();
            if (!DefaultSVNOptions.matches(pattern, name)) continue;
            return true;
        }
        return false;
    }

    private static Map getChildrenFiles(File parent) {
        File[] children = SVNFileListUtil.listFiles(parent);
        if (children != null) {
            HashMap<String, File> map = new HashMap<String, File>();
            for (int i = 0; i < children.length; ++i) {
                map.put(children[i].getName(), children[i]);
            }
            return map;
        }
        return Collections.EMPTY_MAP;
    }
}

