/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;

public class DefaultSVNRepositoryPool
implements ISVNRepositoryPool,
ISVNSession {
    public static final int RUNTIME_POOL = 1;
    public static final int INSTANCE_POOL = 2;
    public static final int NO_POOL = 4;
    private ISVNAuthenticationManager myAuthManager;
    private ISVNTunnelProvider myTunnelProvider;
    private boolean myIsKeepConnections;
    private int myPoolMode;
    private Map myPool;
    private static Map ourPool;
    private static Object ourPoolMonitor;
    private static final boolean ourAllowPersistentConnections;

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider) {
        this(authManager, tunnelProvider, true, 1);
    }

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, boolean keepConnections, int poolMode) {
        this.myAuthManager = authManager;
        this.myIsKeepConnections = keepConnections;
        this.myPoolMode = poolMode;
        this.myTunnelProvider = tunnelProvider;
    }

    public synchronized SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        SVNRepository repos = null;
        Map pool = this.getPool();
        if (!mayReuse || pool == null) {
            repos = SVNRepositoryFactory.create(url, this);
            repos.setAuthenticationManager(this.myAuthManager);
            repos.setTunnelProvider(this.myTunnelProvider);
            return repos;
        }
        repos = DefaultSVNRepositoryPool.retriveRepository(pool, url.getProtocol());
        if (repos != null) {
            repos.setLocation(url, false);
        } else {
            repos = SVNRepositoryFactory.create(url, this);
            DefaultSVNRepositoryPool.saveRepository(pool, repos, url.getProtocol());
        }
        repos.setAuthenticationManager(this.myAuthManager);
        repos.setTunnelProvider(this.myTunnelProvider);
        return repos;
    }

    public boolean keepConnection(SVNRepository repository) {
        return ourAllowPersistentConnections && this.myIsKeepConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownConnections(boolean shutdownAll) {
        Map pool = null;
        if (this.myPoolMode == 2) {
            pool = this.myPool;
        } else if (this.myPoolMode == 1) {
            pool = ourPool;
        }
        if (pool != null) {
            Object object = ourPoolMonitor;
            synchronized (object) {
                DefaultSVNRepositoryPool.clearPool(pool, shutdownAll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getPool() {
        switch (this.myPoolMode) {
            case 2: {
                if (this.myPool == null) {
                    this.myPool = new HashMap();
                }
                return this.myPool;
            }
            case 1: {
                Object object = ourPoolMonitor;
                synchronized (object) {
                    if (ourPool == null) {
                        ourPool = new HashMap();
                    }
                    return ourPool;
                }
            }
        }
        return null;
    }

    public void saveCommitMessage(SVNRepository repository, long revision, String message) {
    }

    public String getCommitMessage(SVNRepository repository, long revision) {
        return null;
    }

    public boolean hasCommitMessage(SVNRepository repository, long revision) {
        return false;
    }

    private static void clearPool(Map pool, boolean force) {
        Iterator references = pool.keySet().iterator();
        while (references.hasNext()) {
            WeakReference reference = (WeakReference)references.next();
            if (!force && reference.get() != null) continue;
            Map repositoriesMap = (Map)pool.get(reference);
            Iterator repos = repositoriesMap.values().iterator();
            while (repos.hasNext()) {
                SVNRepository repo = (SVNRepository)repos.next();
                try {
                    repo.closeSession();
                }
                catch (SVNException e) {
                    // empty catch block
                }
                repos.remove();
            }
            references.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNRepository retriveRepository(Map pool, String protocol) {
        Object object = ourPoolMonitor;
        synchronized (object) {
            DefaultSVNRepositoryPool.clearPool(pool, false);
            Iterator references = pool.keySet().iterator();
            while (references.hasNext()) {
                WeakReference reference = (WeakReference)references.next();
                if (reference.get() != Thread.currentThread()) continue;
                Map repositoriesMap = (Map)pool.get(reference);
                if (repositoriesMap.containsKey(protocol)) {
                    return (SVNRepository)repositoriesMap.get(protocol);
                }
                return null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRepository(Map pool, SVNRepository repository, String protocol) {
        Object object = ourPoolMonitor;
        synchronized (object) {
            DefaultSVNRepositoryPool.clearPool(pool, false);
            Iterator references = pool.keySet().iterator();
            while (references.hasNext()) {
                WeakReference reference = (WeakReference)references.next();
                if (reference.get() != Thread.currentThread()) continue;
                Map repositoriesMap = (Map)pool.get(reference);
                repositoriesMap.put(protocol, repository);
                return;
            }
            HashMap<String, SVNRepository> map = new HashMap<String, SVNRepository>();
            map.put(protocol, repository);
            pool.put(new WeakReference<Thread>(Thread.currentThread()), map);
        }
    }

    static {
        ourPoolMonitor = new Object();
        ourAllowPersistentConnections = "true".equalsIgnoreCase(System.getProperty("svnkit.http.keepAlive", System.getProperty("javasvn.http.keepAlive", "true")));
    }
}

