/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNBasicClient
implements ISVNEventHandler {
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNOptions myOptions;
    private ISVNEventHandler myEventDispatcher;
    private List myPathPrefixesStack;
    private boolean myIsIgnoreExternals;
    private boolean myIsLeaveConflictsUnresolved;
    private ISVNDebugLog myDebugLog;

    protected SVNBasicClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        this(new DefaultSVNRepositoryPool(authManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : authManager, options, true, 1), options);
    }

    protected SVNBasicClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        this.myRepositoryPool = repositoryPool;
        this.myOptions = options;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.myPathPrefixesStack = new LinkedList();
    }

    public ISVNOptions getOptions() {
        return this.myOptions;
    }

    public void setIgnoreExternals(boolean ignore) {
        this.myIsIgnoreExternals = ignore;
    }

    public boolean isIgnoreExternals() {
        return this.myIsIgnoreExternals;
    }

    public void setLeaveConflictsUnresolved(boolean leave) {
        this.myIsLeaveConflictsUnresolved = leave;
    }

    public boolean isLeaveConflictsUnresolved() {
        return this.myIsLeaveConflictsUnresolved;
    }

    public void setEventHandler(ISVNEventHandler dispatcher) {
        this.myEventDispatcher = dispatcher;
    }

    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log;
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    protected void sleepForTimeStamp() {
        if (this.myPathPrefixesStack == null || this.myPathPrefixesStack.isEmpty()) {
            SVNFileUtil.sleepForTimestamp();
        }
    }

    protected SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        SVNRepository repository = null;
        repository = this.myRepositoryPool == null ? SVNRepositoryFactory.create(url, null) : this.myRepositoryPool.createRepository(url, mayReuse);
        repository.setDebugLog(this.getDebugLog());
        return repository;
    }

    protected ISVNRepositoryPool getRepositoryPool() {
        return this.myRepositoryPool;
    }

    protected void dispatchEvent(SVNEvent event) throws SVNException {
        this.dispatchEvent(event, -1.0);
    }

    protected void dispatchEvent(SVNEvent event, double progress) throws SVNException {
        if (this.myEventDispatcher != null) {
            String path = "";
            if (!this.myPathPrefixesStack.isEmpty()) {
                Iterator paths = this.myPathPrefixesStack.iterator();
                while (paths.hasNext()) {
                    String segment = (String)paths.next();
                    path = SVNPathUtil.append(path, segment);
                }
            }
            if (path != null && !"".equals(path)) {
                path = SVNPathUtil.append(path, event.getPath());
                event.setPath(path);
            }
            try {
                this.myEventDispatcher.handleEvent(event, progress);
            }
            catch (SVNException e) {
                throw e;
            }
            catch (Throwable th) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", th.getMessage());
                SVNErrorManager.error(err, th);
            }
        }
    }

    public void setEventPathPrefix(String prefix) {
        if (prefix == null && !this.myPathPrefixesStack.isEmpty()) {
            this.myPathPrefixesStack.remove(this.myPathPrefixesStack.size() - 1);
        } else if (prefix != null) {
            this.myPathPrefixesStack.add(prefix);
        }
    }

    protected ISVNEventHandler getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected SVNWCAccess createWCAccess() {
        return this.createWCAccess(null);
    }

    protected SVNWCAccess createWCAccess(final String pathPrefix) {
        ISVNEventHandler eventHandler = null;
        eventHandler = pathPrefix != null ? new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                String fullPath = SVNPathUtil.append(pathPrefix, event.getPath());
                event.setPath(fullPath);
                SVNBasicClient.this.dispatchEvent(event, progress);
            }

            public void checkCancelled() throws SVNCancelException {
                SVNBasicClient.this.checkCancelled();
            }
        } : this;
        SVNWCAccess access = SVNWCAccess.newInstance(eventHandler);
        access.setOptions(this.myOptions);
        return access;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        this.dispatchEvent(event, progress);
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myEventDispatcher != null) {
            this.myEventDispatcher.checkCancelled();
        }
    }

    protected long getRevisionNumber(SVNRevision revision, SVNRepository repository, File path) throws SVNException {
        SVNErrorMessage err;
        if (repository == null && (revision == SVNRevision.HEAD || revision.getDate() != null)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
            SVNErrorManager.error(err);
        }
        if (revision.getNumber() >= 0L) {
            return revision.getNumber();
        }
        if (revision.getDate() != null) {
            return repository.getDatedRevision(revision.getDate());
        }
        if (revision == SVNRevision.HEAD) {
            return repository.getLatestRevision();
        }
        if (!revision.isValid()) {
            return -1L;
        }
        if (revision == SVNRevision.COMMITTED || revision == SVNRevision.WORKING || revision == SVNRevision.BASE || revision == SVNRevision.PREVIOUS) {
            SVNErrorMessage err2;
            if (path == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err);
            }
            SVNWCAccess wcAccess = this.createWCAccess();
            wcAccess.probeOpen(path, false, 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            wcAccess.close();
            if (entry == null) {
                err2 = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err2);
            }
            if (revision == SVNRevision.WORKING || revision == SVNRevision.BASE) {
                return entry.getRevision();
            }
            if (entry.getCommittedRevision() < 0L) {
                err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", path);
                SVNErrorManager.error(err2);
            }
            return revision == SVNRevision.PREVIOUS ? entry.getCommittedRevision() - 1L : entry.getCommittedRevision();
        }
        err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Unrecognized revision type requested for ''{0}''", path != null ? path : repository.getLocation());
        SVNErrorManager.error(err);
        return -1L;
    }

    protected SVNRepository createRepository(SVNURL url, File path, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        return this.createRepository(url, path, pegRevision, revision, null);
    }

    protected SVNRepository createRepository(SVNURL url, File path, SVNRevision pegRevision, SVNRevision revision, long[] pegRev) throws SVNException {
        SVNURL pathURL;
        if (url == null && (pathURL = this.getURL(path)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
            SVNErrorManager.error(err);
        }
        if (!revision.isValid() && pegRevision.isValid()) {
            revision = pegRevision;
        }
        SVNRevision startRevision = SVNRevision.UNDEFINED;
        if (path == null) {
            startRevision = !revision.isValid() ? SVNRevision.HEAD : revision;
            if (!pegRevision.isValid()) {
                pegRevision = SVNRevision.HEAD;
            }
        } else {
            startRevision = !revision.isValid() ? SVNRevision.BASE : revision;
            if (!pegRevision.isValid()) {
                pegRevision = SVNRevision.WORKING;
            }
        }
        SVNRepositoryLocation[] locations = this.getLocations(url, path, null, pegRevision, startRevision, SVNRevision.UNDEFINED);
        url = locations[0].getURL();
        long actualRevision = locations[0].getRevisionNumber();
        SVNRepository repository = this.createRepository(url, true);
        if ((actualRevision = this.getRevisionNumber(SVNRevision.create(actualRevision), repository, path)) < 0L) {
            actualRevision = repository.getLatestRevision();
        }
        if (pegRev != null && pegRev.length > 0) {
            pegRev[0] = actualRevision;
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNRepositoryLocation[] getLocations(SVNURL url, File path, SVNRepository repository, SVNRevision revision, SVNRevision start, SVNRevision end) throws SVNException {
        SVNErrorMessage err;
        Object source;
        long[] lArray;
        if (!revision.isValid() || !start.isValid()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION));
        }
        long pegRevisionNumber = -1L;
        if (path != null) {
            SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
            try {
                wcAccess.openAnchor(path, false, 0);
                SVNEntry entry = wcAccess.getEntry(path, false);
                if (entry.getCopyFromURL() != null && revision == SVNRevision.WORKING) {
                    url = entry.getCopyFromSVNURL();
                    pegRevisionNumber = entry.getCopyFromRevision();
                } else if (entry.getURL() != null) {
                    url = entry.getSVNURL();
                } else {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
                    SVNErrorManager.error(err2);
                }
            }
            finally {
                wcAccess.close();
            }
        }
        if (repository == null) {
            repository = this.createRepository(url, true);
        }
        if (pegRevisionNumber < 0L) {
            pegRevisionNumber = this.getRevisionNumber(revision, repository, path);
        }
        long startRevisionNumber = revision == start && revision == SVNRevision.HEAD ? pegRevisionNumber : this.getRevisionNumber(start, repository, path);
        long endRevisionNumber = !end.isValid() ? startRevisionNumber : this.getRevisionNumber(end, repository, path);
        if (endRevisionNumber == pegRevisionNumber && startRevisionNumber == pegRevisionNumber) {
            SVNRepositoryLocation[] result = new SVNRepositoryLocation[]{new SVNRepositoryLocation(url, startRevisionNumber), new SVNRepositoryLocation(url, endRevisionNumber)};
            return result;
        }
        SVNURL rootURL = repository.getRepositoryRoot(true);
        if (startRevisionNumber == endRevisionNumber) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = startRevisionNumber;
        } else {
            long[] lArray3 = new long[2];
            lArray3[0] = startRevisionNumber;
            lArray = lArray3;
            lArray3[1] = endRevisionNumber;
        }
        long[] revisionsRange = lArray;
        Map locations = null;
        try {
            locations = repository.getLocations("", (Map)null, pegRevisionNumber, revisionsRange);
        }
        catch (SVNException e) {
            if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                locations = this.getLocations10(repository, pegRevisionNumber, startRevisionNumber, endRevisionNumber);
            }
            throw e;
        }
        SVNLocationEntry startPath = (SVNLocationEntry)locations.get(new Long(startRevisionNumber));
        SVNLocationEntry endPath = (SVNLocationEntry)locations.get(new Long(endRevisionNumber));
        if (startPath == null) {
            source = path != null ? path : url;
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Unable to find repository location for ''{0}'' in revision ''{1}''", new Object[]{source, new Long(startRevisionNumber)});
            SVNErrorManager.error(err);
        }
        if (endPath == null) {
            source = path != null ? path : url;
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "The location for ''{0}'' for revision {1} does not exist in the repository or refers to an unrelated object", new Object[]{source, new Long(endRevisionNumber)});
            SVNErrorManager.error(err);
        }
        SVNRepositoryLocation[] result = new SVNRepositoryLocation[2];
        SVNURL startURL = SVNURL.parseURIEncoded(SVNPathUtil.append(rootURL.toString(), SVNEncodingUtil.uriEncode(startPath.getPath())));
        result[0] = new SVNRepositoryLocation(startURL, startRevisionNumber);
        if (end.isValid()) {
            SVNURL endURL = SVNURL.parseURIEncoded(SVNPathUtil.append(rootURL.toString(), SVNEncodingUtil.uriEncode(endPath.getPath())));
            result[1] = new SVNRepositoryLocation(endURL, endRevisionNumber);
        }
        return result;
    }

    private Map getLocations10(SVNRepository repos, long pegRevision, long startRevision, long endRevision) throws SVNException {
        String endPath;
        String path = repos.getRepositoryPath("");
        SVNNodeKind kind = repos.checkPath("", pegRevision);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "path ''{0}'' doesn't exist at revision {1}", new Object[]{path, new Long(pegRevision)});
            SVNErrorManager.error(err);
        }
        long logStart = pegRevision;
        logStart = Math.max(startRevision, logStart);
        logStart = Math.max(endRevision, logStart);
        long logEnd = pegRevision;
        logStart = Math.min(startRevision, logStart);
        logStart = Math.min(endRevision, logStart);
        LocationsLogEntryHandler handler = new LocationsLogEntryHandler(path, startRevision, endRevision, pegRevision, kind, this.getEventDispatcher());
        repos.log(new String[]{""}, logStart, logEnd, true, false, handler);
        String pegPath = handler.myPegPath == null ? handler.myCurrentPath : handler.myPegPath;
        String startPath = handler.myStartPath == null ? handler.myCurrentPath : handler.myStartPath;
        String string = endPath = handler.myEndPath == null ? handler.myCurrentPath : handler.myEndPath;
        if (pegPath == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "path ''{0}'' in revision {1} is an unrelated object", new Object[]{path, new Long(logStart)});
            SVNErrorManager.error(err);
        }
        HashMap<Long, SVNLocationEntry> result = new HashMap<Long, SVNLocationEntry>();
        result.put(new Long(startRevision), new SVNLocationEntry(-1L, startPath));
        result.put(new Long(endRevision), new SVNLocationEntry(-1L, endPath));
        return result;
    }

    private static String getPreviousLogPath(String path, SVNLogEntry logEntry, SVNNodeKind kind) throws SVNException {
        String prevPath = null;
        SVNLogEntryPath logPath = (SVNLogEntryPath)logEntry.getChangedPaths().get(path);
        if (logPath != null) {
            if (logPath.getType() != 'A' && logPath.getType() != 'R') {
                return logPath.getPath();
            }
            if (logPath.getCopyPath() != null) {
                return logPath.getCopyPath();
            }
            return null;
        }
        if (!logEntry.getChangedPaths().isEmpty()) {
            HashMap sortedMap = new HashMap();
            sortedMap.putAll(logEntry.getChangedPaths());
            ArrayList pathsList = new ArrayList(sortedMap.keySet());
            Collections.sort(pathsList, SVNPathUtil.PATH_COMPARATOR);
            Collections.reverse(pathsList);
            Iterator paths = pathsList.iterator();
            while (paths.hasNext()) {
                SVNLogEntryPath lPath;
                String p = (String)paths.next();
                if (!path.startsWith(p + "/") || (lPath = (SVNLogEntryPath)sortedMap.get(p)).getCopyPath() == null) continue;
                prevPath = SVNPathUtil.append(lPath.getCopyPath(), path.substring(p.length()));
                break;
            }
        }
        if (prevPath == null) {
            if (kind == SVNNodeKind.DIR) {
                prevPath = path;
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Missing changed-path information for ''{0}'' in revision {1}", new Object[]{path, new Long(logEntry.getRevision())});
                SVNErrorManager.error(err);
            }
        }
        return prevPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNURL getURL(File path) throws SVNException {
        if (path == null) {
            return null;
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.probeOpen(path, false, 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            SVNURL sVNURL = entry != null ? entry.getSVNURL() : null;
            return sVNURL;
        }
        finally {
            wcAccess.close();
        }
    }

    protected static class SVNRepositoryLocation {
        private SVNURL myURL;
        private long myRevision;

        public SVNRepositoryLocation(SVNURL url, long rev) {
            this.myURL = url;
            this.myRevision = rev;
        }

        public long getRevisionNumber() {
            return this.myRevision;
        }

        public SVNURL getURL() {
            return this.myURL;
        }
    }

    protected static class RepositoryReference {
        public String URL;
        public long Revision;

        public RepositoryReference(String url, long rev) {
            this.URL = url;
            this.Revision = rev;
        }
    }

    private static final class LocationsLogEntryHandler
    implements ISVNLogEntryHandler {
        private String myCurrentPath = null;
        private String myStartPath = null;
        private String myEndPath = null;
        private String myPegPath = null;
        private long myStartRevision;
        private long myEndRevision;
        private long myPegRevision;
        private SVNNodeKind myKind;
        private ISVNEventHandler myEventHandler;

        private LocationsLogEntryHandler(String path, long startRevision, long endRevision, long pegRevision, SVNNodeKind kind, ISVNEventHandler eventHandler) {
            this.myCurrentPath = path;
            this.myStartRevision = startRevision;
            this.myEndRevision = endRevision;
            this.myPegRevision = pegRevision;
            this.myEventHandler = eventHandler;
            this.myKind = kind;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (this.myEventHandler != null) {
                this.myEventHandler.checkCancelled();
            }
            if (logEntry.getChangedPaths() == null) {
                return;
            }
            if (this.myCurrentPath == null) {
                return;
            }
            if (this.myStartPath == null && logEntry.getRevision() <= this.myStartRevision) {
                this.myStartPath = this.myCurrentPath;
            }
            if (this.myEndPath == null && logEntry.getRevision() <= this.myEndRevision) {
                this.myEndPath = this.myCurrentPath;
            }
            if (this.myPegPath == null && logEntry.getRevision() <= this.myPegRevision) {
                this.myPegPath = this.myCurrentPath;
            }
            this.myCurrentPath = SVNBasicClient.getPreviousLogPath(this.myCurrentPath, logEntry, this.myKind);
        }
    }
}

