/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAnnotationGenerator;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNLogClient
extends SVNBasicClient {
    private SVNDiffOptions myDiffOptions;

    public SVNLogClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNLogClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setDiffOptions(SVNDiffOptions diffOptions) {
        this.myDiffOptions = diffOptions;
    }

    public SVNDiffOptions getDiffOptions() {
        if (this.myDiffOptions == null) {
            this.myDiffOptions = new SVNDiffOptions();
        }
        return this.myDiffOptions;
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler) throws SVNException {
        this.doAnnotate(path, pegRevision, startRevision, endRevision, false, handler);
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean force, ISVNAnnotateHandler handler) throws SVNException {
        long startRev;
        SVNRepository repos;
        long endRev;
        if (startRevision == null || !startRevision.isValid()) {
            startRevision = SVNRevision.create(1L);
        }
        if (endRevision == null || !endRevision.isValid()) {
            endRevision = pegRevision;
        }
        if ((endRev = this.getRevisionNumber(endRevision, repos = this.createRepository(null, path, pegRevision, endRevision), path)) < (startRev = this.getRevisionNumber(startRevision, repos, path))) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Start revision must precede end revision"));
        }
        File tmpFile = new File(path.getParentFile(), SVNFileUtil.getAdminDirectoryName());
        if (!(tmpFile = new File(tmpFile, "tmp/text-base")).isDirectory()) {
            tmpFile = SVNFileUtil.createTempDirectory("annotate");
        }
        this.doAnnotate(path.getAbsolutePath(), startRev, tmpFile, repos, endRev, force, handler, null);
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler) throws SVNException {
        this.doAnnotate(url, pegRevision, startRevision, endRevision, handler, null);
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        this.doAnnotate(url, pegRevision, startRevision, endRevision, false, handler, inputEncoding);
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean force, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        long startRev;
        SVNRepository repos;
        long endRev;
        if (startRevision == null || !startRevision.isValid()) {
            startRevision = SVNRevision.create(1L);
        }
        if (endRevision == null || !endRevision.isValid()) {
            endRevision = pegRevision;
        }
        if ((endRev = this.getRevisionNumber(endRevision, repos = this.createRepository(url, null, pegRevision, endRevision), null)) < (startRev = this.getRevisionNumber(startRevision, repos, null))) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Start revision must precede end revision"));
        }
        File tmpFile = SVNFileUtil.createTempDirectory("annotate");
        this.doAnnotate(repos.getLocation().toDecodedString(), startRev, tmpFile, repos, endRev, force, handler, inputEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAnnotate(String path, long startRev, File tmpFile, SVNRepository repos, long endRev, boolean force, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        SVNAnnotationGenerator generator = new SVNAnnotationGenerator(path, tmpFile, startRev, force, this.getDiffOptions(), this);
        try {
            repos.getFileRevisions("", startRev > 0L ? startRev - 1L : startRev, endRev, generator);
            generator.reportAnnotations(handler, inputEncoding);
            Object var13_10 = null;
            generator.dispose();
            SVNFileUtil.deleteAll(tmpFile, !"text-base".equals(tmpFile.getName()), null);
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            generator.dispose();
            SVNFileUtil.deleteAll(tmpFile, !"text-base".equals(tmpFile.getName()), null);
            throw throwable;
        }
    }

    public void doLog(File[] paths, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean reportPaths, long limit, ISVNLogEntryHandler handler) throws SVNException {
        this.doLog(paths, SVNRevision.UNDEFINED, startRevision, endRevision, stopOnCopy, reportPaths, limit, handler);
    }

    public void doLog(File[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean reportPaths, long limit, final ISVNLogEntryHandler handler) throws SVNException {
        int i;
        if (paths == null || paths.length == 0) {
            return;
        }
        if (startRevision.isValid() && !endRevision.isValid()) {
            endRevision = startRevision;
        } else if (!startRevision.isValid()) {
            startRevision = !pegRevision.isValid() ? SVNRevision.BASE : pegRevision;
            if (!endRevision.isValid()) {
                endRevision = SVNRevision.create(0L);
            }
        }
        ISVNLogEntryHandler wrappingHandler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                SVNLogClient.this.checkCancelled();
                handler.handleLogEntry(logEntry);
            }
        };
        SVNURL[] urls = new SVNURL[paths.length];
        SVNWCAccess wcAccess = this.createWCAccess();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            SVNErrorMessage err;
            this.checkCancelled();
            File path = paths[i2];
            wcAccess.probeOpen(path, false, 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err);
            }
            if (entry.getURL() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", path);
                SVNErrorManager.error(err);
            }
            urls[i2] = entry.getSVNURL();
            wcAccess.closeAdminArea(path);
        }
        if (urls.length == 0) {
            return;
        }
        TreeSet<String> targets = new TreeSet<String>();
        SVNURL baseURL = SVNURLUtil.condenceURLs(urls, targets, true);
        if (baseURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "target log paths belong to different repositories");
            SVNErrorManager.error(err);
        }
        if (targets.isEmpty()) {
            targets.add("");
        }
        SVNRevision rev = SVNRevision.UNDEFINED;
        if (startRevision.getNumber() >= 0L && endRevision.getNumber() >= 0L) {
            rev = startRevision.getNumber() > endRevision.getNumber() ? startRevision : endRevision;
        } else if (startRevision.getDate() != null && endRevision.getDate() != null) {
            rev = startRevision.getDate().compareTo(endRevision.getDate()) > 0 ? startRevision : endRevision;
        }
        SVNRepository repos = rev.isValid() ? this.createRepository(baseURL, null, pegRevision, rev) : this.createRepository(baseURL, true);
        String[] targetPaths = targets.toArray(new String[targets.size()]);
        for (i = 0; i < targetPaths.length; ++i) {
            targetPaths[i] = SVNEncodingUtil.uriDecode(targetPaths[i]);
        }
        if (startRevision.isLocal() || endRevision.isLocal()) {
            for (i = 0; i < paths.length; ++i) {
                this.checkCancelled();
                long startRev = this.getRevisionNumber(startRevision, repos, paths[i]);
                long endRev = this.getRevisionNumber(endRevision, repos, paths[i]);
                repos.log(targetPaths, startRev, endRev, reportPaths, stopOnCopy, limit, wrappingHandler);
            }
        } else {
            long startRev = this.getRevisionNumber(startRevision, repos, null);
            long endRev = this.getRevisionNumber(endRevision, repos, null);
            repos.log(targetPaths, startRev, endRev, reportPaths, stopOnCopy, limit, wrappingHandler);
        }
    }

    public void doLog(SVNURL url, String[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean reportPaths, long limit, final ISVNLogEntryHandler handler) throws SVNException {
        String[] stringArray;
        if (startRevision.isValid() && !endRevision.isValid()) {
            endRevision = startRevision;
        } else if (!startRevision.isValid()) {
            startRevision = !pegRevision.isValid() ? SVNRevision.HEAD : pegRevision;
            if (!endRevision.isValid()) {
                endRevision = SVNRevision.create(0L);
            }
        }
        if (paths == null || paths.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = paths;
        }
        paths = stringArray;
        ISVNLogEntryHandler wrappingHandler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                SVNLogClient.this.checkCancelled();
                handler.handleLogEntry(logEntry);
            }
        };
        SVNRevision rev = SVNRevision.UNDEFINED;
        if (startRevision.getNumber() >= 0L && endRevision.getNumber() >= 0L) {
            rev = startRevision.getNumber() > endRevision.getNumber() ? startRevision : endRevision;
        } else if (startRevision.getDate() != null && endRevision.getDate() != null) {
            rev = startRevision.getDate().compareTo(endRevision.getDate()) > 0 ? startRevision : endRevision;
        }
        SVNRepository repos = rev.isValid() ? this.createRepository(url, null, pegRevision, rev) : this.createRepository(url, true);
        this.checkCancelled();
        long startRev = this.getRevisionNumber(startRevision, repos, null);
        this.checkCancelled();
        long endRev = this.getRevisionNumber(endRevision, repos, null);
        this.checkCancelled();
        repos.log(paths, startRev, endRev, reportPaths, stopOnCopy, limit, wrappingHandler);
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.BASE;
        }
        SVNRepository repos = this.createRepository(null, path, pegRevision, revision);
        long rev = this.getRevisionNumber(revision, repos, path);
        this.doList(repos, rev, handler, fetchLocks, recursive);
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(path, pegRevision, revision, false, recursive, handler);
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        long[] pegRev = new long[]{-1L};
        SVNRepository repos = this.createRepository(url, null, pegRevision, revision, pegRev);
        if (pegRev[0] < 0L) {
            pegRev[0] = this.getRevisionNumber(revision, repos, null);
        }
        this.doList(repos, pegRev[0], handler, fetchLocks, recursive);
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(url, pegRevision, revision, false, recursive, handler);
    }

    private void doList(SVNRepository repos, long rev, final ISVNDirEntryHandler handler, boolean fetchLocks, boolean recursive) throws SVNException {
        final HashMap<SVNURL, SVNLock> locksMap = new HashMap<SVNURL, SVNLock>();
        if (fetchLocks) {
            SVNLock[] locks;
            block10: {
                locks = new SVNLock[]{};
                try {
                    locks = repos.getLocks("");
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) break block10;
                    throw e;
                }
            }
            if (locks != null && locks.length > 0) {
                SVNURL root = repos.getRepositoryRoot(true);
                for (int i = 0; i < locks.length; ++i) {
                    String repositoryPath = locks[i].getPath();
                    locksMap.put(root.appendPath(repositoryPath, false), locks[i]);
                }
            }
        }
        ISVNDirEntryHandler nestedHandler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                dirEntry.setLock((SVNLock)locksMap.get(dirEntry.getURL()));
                handler.handleDirEntry(dirEntry);
            }
        };
        if (repos.checkPath("", rev) == SVNNodeKind.FILE) {
            String name = SVNPathUtil.tail(repos.getLocation().getPath());
            SVNURL fileULR = repos.getLocation();
            repos.setLocation(repos.getLocation().removePathTail(), false);
            Collection dirEntries = repos.getDir("", rev, null, (Collection)null);
            SVNDirEntry fileEntry = null;
            Iterator ents = dirEntries.iterator();
            while (ents.hasNext()) {
                SVNDirEntry dirEntry = (SVNDirEntry)ents.next();
                if (!name.equals(dirEntry.getName())) continue;
                fileEntry = dirEntry;
                break;
            }
            if (fileEntry != null) {
                fileEntry.setRelativePath(name);
                nestedHandler.handleDirEntry(fileEntry);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' non-existent in that revision", fileULR);
                SVNErrorManager.error(err);
            }
        } else {
            SVNLogClient.list(repos, "", rev, recursive, nestedHandler);
        }
    }

    private static void list(SVNRepository repository, String path, long rev, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        Collection entries = new TreeSet();
        entries = repository.getDir(path, rev, null, entries);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            SVNDirEntry entry = (SVNDirEntry)iterator.next();
            String childPath = SVNPathUtil.append(path, entry.getName());
            entry.setRelativePath(childPath);
            handler.handleDirEntry(entry);
            if (entry.getKind() != SVNNodeKind.DIR || entry.getDate() == null || !recursive) continue;
            SVNLogClient.list(repository, childPath, rev, recursive, handler);
        }
    }
}

