/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.util.Iterator;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLLogHandler
extends AbstractXMLHandler
implements ISVNLogEntryHandler {
    public static final String COPYFROM_REV_ATTR = "copyfrom-rev";
    public static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    public static final String ACTION_ATTR = "action";
    public static final String REVISION_ATTR = "revision";
    public static final String MSG_TAG = "msg";
    public static final String PATH_TAG = "path";
    public static final String PATHS_TAG = "paths";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String LOGENTRY_TAG = "logentry";
    public static final String LOG_TAG = "log";

    public SVNXMLLogHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLLogHandler(ContentHandler contentHandler, ISVNDebugLog log) {
        super(contentHandler, log);
    }

    public String getHeaderName() {
        return LOG_TAG;
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        try {
            this.sendToHandler(logEntry);
        }
        catch (SAXException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
    }

    private void sendToHandler(SVNLogEntry logEntry) throws SAXException {
        String message;
        if (logEntry.getRevision() == 0L && logEntry.getMessage() == null) {
            return;
        }
        this.addAttribute(REVISION_ATTR, logEntry.getRevision() + "");
        this.openTag(LOGENTRY_TAG);
        if (logEntry.getAuthor() != null) {
            this.addTag(AUTHOR_TAG, logEntry.getAuthor());
        }
        if (logEntry.getDate() != null && logEntry.getDate().getTime() != 0L) {
            this.addTag(DATE_TAG, SVNTimeUtil.formatDate(logEntry.getDate()));
        }
        if (logEntry.getChangedPaths() != null && !logEntry.getChangedPaths().isEmpty()) {
            this.openTag(PATHS_TAG);
            Iterator paths = logEntry.getChangedPaths().keySet().iterator();
            while (paths.hasNext()) {
                String key = (String)paths.next();
                SVNLogEntryPath path = (SVNLogEntryPath)logEntry.getChangedPaths().get(key);
                this.addAttribute(ACTION_ATTR, path.getType() + "");
                if (path.getCopyPath() != null) {
                    this.addAttribute(COPYFROM_PATH_ATTR, SVNEncodingUtil.xmlEncodeAttr(path.getCopyPath()));
                    this.addAttribute(COPYFROM_REV_ATTR, path.getCopyRevision() + "");
                }
                this.addTag(PATH_TAG, SVNEncodingUtil.xmlEncodeAttr(path.getPath()));
            }
            this.closeTag(PATHS_TAG);
        }
        message = (message = logEntry.getMessage()) == null ? "" : message;
        message = SVNEncodingUtil.xmlEncodeCDATA(message);
        this.addTag(MSG_TAG, message);
        this.closeTag(LOGENTRY_TAG);
    }
}

