/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeCommand
extends SVNCommand {
    public SVNMergeCommand() {
        super("merge", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.CHANGE);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.DRY_RUN);
        options.add(SVNOption.DIFF3_CMD);
        options.add(SVNOption.RECORD_ONLY);
        options.add(SVNOption.EXTENSIONS);
        options.add(SVNOption.IGNORE_ANCESTRY);
        options.add(SVNOption.ACCEPT);
        options.add(SVNOption.REINTEGRATE);
        options.add(SVNOption.ALLOW_MIXED_REVISIONS);
        return options;
    }

    @Override
    public boolean acceptsRevisionRange() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SVNException {
        SVNErrorMessage err;
        List<String> targets = this.getSVNEnvironment().combineTargets(new ArrayList(), true);
        SVNPath source1 = null;
        SVNPath source2 = null;
        SVNPath target = null;
        SVNRevision pegRevision1 = null;
        SVNRevision pegRevision2 = null;
        if (targets.size() >= 1) {
            source1 = new SVNPath(targets.get(0), true);
            pegRevision1 = source1.getPegRevision();
            if (targets.size() >= 2) {
                source2 = new SVNPath(targets.get(1), true);
                pegRevision2 = source2.getPegRevision();
            }
        }
        boolean twoSourcesSpecified = true;
        if (targets.size() <= 1) {
            twoSourcesSpecified = false;
        } else if (targets.size() == 2 && source1.isURL() && !source2.isURL()) {
            twoSourcesSpecified = false;
        }
        LinkedList<SVNRevisionRange> rangesToMerge = this.getSVNEnvironment().getRevisionRanges();
        SVNRevision firstRangeStart = SVNRevision.UNDEFINED;
        SVNRevision firstRangeEnd = SVNRevision.UNDEFINED;
        if (!rangesToMerge.isEmpty()) {
            SVNRevisionRange range = (SVNRevisionRange)rangesToMerge.get(0);
            firstRangeStart = range.getStartRevision();
            firstRangeEnd = range.getEndRevision();
        }
        if (firstRangeStart != SVNRevision.UNDEFINED) {
            if (firstRangeEnd == SVNRevision.UNDEFINED) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Second revision required");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            twoSourcesSpecified = false;
        }
        if (!twoSourcesSpecified) {
            if (targets.size() > 2) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Too many arguments given"), (SVNLogType)SVNLogType.CLIENT);
            }
            if (targets.isEmpty()) {
                pegRevision1 = SVNRevision.HEAD;
            } else {
                source2 = source1;
                if (pegRevision1 == null || pegRevision1 == SVNRevision.UNDEFINED) {
                    SVNRevision sVNRevision = pegRevision1 = source1.isURL() ? SVNRevision.HEAD : SVNRevision.WORKING;
                }
                if (targets.size() == 2 && (target = new SVNPath(targets.get(1))).isURL()) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Cannot specifify a revision range with two URLs");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
            }
        } else {
            if (targets.size() < 2) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
            } else if (targets.size() > 3) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Too many arguments given"), (SVNLogType)SVNLogType.CLIENT);
            }
            firstRangeStart = pegRevision1;
            firstRangeEnd = pegRevision2;
            if ((firstRangeStart == null || firstRangeStart == SVNRevision.UNDEFINED) && !source1.isURL() || (pegRevision2 == null || pegRevision2 == SVNRevision.UNDEFINED) && !source2.isURL()) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_BAD_REVISION, (String)"A working copy merge source needs an explicit revision"), (SVNLogType)SVNLogType.CLIENT);
            }
            if (firstRangeStart == null || firstRangeStart == SVNRevision.UNDEFINED) {
                firstRangeStart = SVNRevision.HEAD;
            }
            if (firstRangeEnd == null || firstRangeEnd == SVNRevision.UNDEFINED) {
                firstRangeEnd = SVNRevision.HEAD;
            }
            if (targets.size() >= 3) {
                target = new SVNPath(targets.get(2));
            }
        }
        if (source1 != null && source2 != null && target == null) {
            String decodedPath;
            SVNPath decodedPathTarget;
            if (source1.isURL()) {
                String decodedPath2;
                SVNPath decodedPathTarget2;
                String name2;
                String name1 = SVNPathUtil.tail((String)source1.getTarget());
                if (name1.equals(name2 = SVNPathUtil.tail((String)source2.getTarget())) && SVNFileType.getType((File)(decodedPathTarget2 = new SVNPath(decodedPath2 = SVNEncodingUtil.uriDecode((String)name1))).getFile()) == SVNFileType.FILE) {
                    target = decodedPathTarget2;
                }
            } else if (source1.equals(source2) && SVNFileType.getType((File)(decodedPathTarget = new SVNPath(decodedPath = SVNEncodingUtil.uriDecode((String)source1.getTarget()))).getFile()) == SVNFileType.FILE) {
                target = decodedPathTarget;
            }
        }
        if (target == null) {
            target = new SVNPath("");
        }
        SVNDiffClient client = this.getSVNEnvironment().getClientManager().getDiffClient();
        SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)printer);
        }
        client.setAllowMixedRevisionsWCForMerge(this.getSVNEnvironment().isAllowMixedRevisions());
        try {
            client.setMergeOptions(this.getSVNEnvironment().getDiffOptions());
            try {
                if (!twoSourcesSpecified) {
                    if (firstRangeStart == SVNRevision.UNDEFINED && firstRangeEnd == SVNRevision.UNDEFINED) {
                        SVNRevisionRange range = new SVNRevisionRange(SVNRevision.create((long)1L), pegRevision1);
                        rangesToMerge = new LinkedList<SVNRevisionRange>();
                        rangesToMerge.add(range);
                    }
                    if (source1 == null) {
                        source1 = target;
                    }
                    if (this.getSVNEnvironment().isReIntegrate()) {
                        SVNErrorMessage err2;
                        if (this.getSVNEnvironment().getDepth() != SVNDepth.UNKNOWN) {
                            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--depth cannot be used with --reintegrate");
                            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
                        }
                        if (this.getSVNEnvironment().isForce()) {
                            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--force cannot be used with --reintegrate");
                            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
                        }
                        if (source1.isURL()) {
                            client.doMergeReIntegrate(source1.getURL(), pegRevision1, target.getFile(), this.getSVNEnvironment().isDryRun());
                        } else {
                            client.doMergeReIntegrate(source1.getFile(), pegRevision1, target.getFile(), this.getSVNEnvironment().isDryRun());
                        }
                    } else if (source1.isURL()) {
                        client.doMerge(source1.getURL(), pegRevision1, rangesToMerge, target.getFile(), this.getSVNEnvironment().getDepth(), !this.getSVNEnvironment().isIgnoreAncestry(), this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isDryRun(), this.getSVNEnvironment().isRecordOnly());
                    } else {
                        client.doMerge(source1.getFile(), pegRevision1, rangesToMerge, target.getFile(), this.getSVNEnvironment().getDepth(), !this.getSVNEnvironment().isIgnoreAncestry(), this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isDryRun(), this.getSVNEnvironment().isRecordOnly());
                    }
                } else if (source1.isURL() && source2.isURL()) {
                    client.doMerge(source1.getURL(), firstRangeStart, source2.getURL(), firstRangeEnd, target.getFile(), this.getSVNEnvironment().getDepth(), !this.getSVNEnvironment().isIgnoreAncestry(), this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isDryRun(), this.getSVNEnvironment().isRecordOnly());
                } else if (source1.isURL() && source2.isFile()) {
                    client.doMerge(source1.getURL(), firstRangeStart, source2.getFile(), firstRangeEnd, target.getFile(), this.getSVNEnvironment().getDepth(), !this.getSVNEnvironment().isIgnoreAncestry(), this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isDryRun(), this.getSVNEnvironment().isRecordOnly());
                } else if (source1.isFile() && source2.isURL()) {
                    client.doMerge(source1.getFile(), firstRangeStart, source2.getURL(), firstRangeEnd, target.getFile(), this.getSVNEnvironment().getDepth(), !this.getSVNEnvironment().isIgnoreAncestry(), this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isDryRun(), this.getSVNEnvironment().isRecordOnly());
                } else {
                    client.doMerge(source1.getFile(), firstRangeStart, source2.getFile(), firstRangeEnd, target.getFile(), this.getSVNEnvironment().getDepth(), !this.getSVNEnvironment().isIgnoreAncestry(), this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isDryRun(), this.getSVNEnvironment().isRecordOnly());
                }
            }
            finally {
                if (!this.getSVNEnvironment().isQuiet()) {
                    StringBuffer status = new StringBuffer();
                    printer.printConflictStatus(status);
                    this.getSVNEnvironment().getOut().print(status);
                }
            }
        }
        catch (SVNException e) {
            SVNErrorCode code;
            SVNErrorMessage err3 = e.getErrorMessage();
            if (!(err3 == null || this.getSVNEnvironment().isReIntegrate() || (code = err3.getErrorCode()) != SVNErrorCode.UNVERSIONED_RESOURCE && code != SVNErrorCode.CLIENT_MODIFIED)) {
                err3 = err3.wrap("Use --force to override this restriction");
                SVNErrorManager.error((SVNErrorMessage)err3, (SVNLogType)SVNLogType.CLIENT);
            }
            throw e;
        }
    }
}

