/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNRevertCommand
extends SVNCommand {
    public SVNRevertCommand() {
        super("revert", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        ArrayList<File> pathsList = new ArrayList<File>(targets.size());
        for (int i = 0; i < targets.size(); ++i) {
            SVNPath target = new SVNPath(targets.get(i));
            if (!target.isFile()) continue;
            if ("".equals(target.getTarget()) && this.isScheduledForAddition(target.getFile())) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_INVALID_OP_ON_CWD, (String)"Cannot revert addition of current directory; please try again from the parent directory");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            pathsList.add(target.getFile());
        }
        Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
        File[] paths = pathsList.toArray(new File[pathsList.size()]);
        try {
            client.doRevert(paths, depth, changeLists);
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage();
            if (!depth.isRecursive() && err.getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                err = err.wrap("Try 'svn revert --recursive' instead?");
            } else if (!depth.isRecursive() && err.getErrorCode() == SVNErrorCode.WC_INVALID_OPERATION_DEPTH) {
                err = err.wrap("Try 'svn revert --depth infinity' instead?");
            }
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isScheduledForAddition(File dir) {
        if (SVNFileType.getType((File)dir) != SVNFileType.DIRECTORY) {
            return false;
        }
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            wcAccess.probeOpen(dir, false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(dir, false);
            if (entry != null && "".equals(entry.getName()) && entry.isScheduledForAddition()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SVNException sVNException) {
        }
        finally {
            try {
                wcAccess.close();
            }
            catch (SVNException sVNException) {}
        }
        return false;
    }
}

