/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class SVNStatusPrinter {
    private SVNCommandEnvironment myEnvironment;

    public SVNStatusPrinter(SVNCommandEnvironment env) {
        this.myEnvironment = env;
    }

    public void printStatus(String path, SVNStatus status, boolean detailed, boolean showLastCommitted, boolean skipUnrecognized, boolean showReposLocks) throws SVNException {
        if (status == null || skipUnrecognized && !status.isVersioned() && status.getTreeConflict() == null && status.getNodeStatus() != SVNStatusType.STATUS_EXTERNAL || SVNStatusPrinter.combineStatus(status) == SVNStatusType.STATUS_NONE && status.getRemoteContentsStatus() == SVNStatusType.STATUS_NONE) {
            return;
        }
        char treeStatusCode = ' ';
        String treeDescriptionLine = "";
        if (status.getTreeConflict() != null) {
            String description = SVNTreeConflictUtil.getHumanReadableConflictDescription((SVNTreeConflictDescription)status.getTreeConflict());
            treeStatusCode = 'C';
            treeDescriptionLine = "\n      >   " + description;
        }
        String movedFromLine = "";
        String movedToLine = "";
        if (status.getMovedFromPath() != null && status.getMovedToPath() != null && status.getMovedFromPath().equals(status.getMovedToPath())) {
            movedFromLine = String.format("\n        > swapped places with %s", this.getRelativePath(status.getMovedFromPath()));
        } else if (status.getMovedFromPath() != null || status.getMovedToPath() != null) {
            if (status.getMovedFromPath() != null) {
                movedFromLine = String.format("\n        > moved from %s", this.getRelativePath(status.getMovedFromPath()));
            }
            if (status.getMovedToPath() != null) {
                movedToLine = String.format("\n        > moved to %s", this.getRelativePath(status.getMovedToPath()));
            }
        }
        StringBuffer result = new StringBuffer();
        if (detailed) {
            char lockStatus;
            String wcRevision = !status.isVersioned() ? "" : (status.isCopied() ? "-" : (!status.getRevision().isValid() ? (status.getWorkingCopyFormat() >= 29 ? (status.getNodeStatus() == SVNStatusType.STATUS_DELETED ? status.getCommittedRevision().toString() : "-") : " ? ") : Long.toString(status.getRevision().getNumber())));
            char remoteStatus = status.getRemoteNodeStatus() != SVNStatusType.STATUS_NONE ? (char)'*' : ' ';
            if (showReposLocks) {
                lockStatus = status.getRemoteLock() != null ? (status.getLocalLock() != null ? (status.getLocalLock().getID().equals(status.getRemoteLock().getID()) ? (char)'K' : 'T') : (char)'O') : (status.getLocalLock() != null ? (char)'B' : ' ');
            } else {
                char c = lockStatus = status.getLocalLock() != null ? (char)'K' : ' ';
            }
            if (showLastCommitted) {
                String commitRevision = "";
                String commitAuthor = "";
                if (status.isVersioned() && status.getCommittedRevision().isValid()) {
                    commitRevision = status.getCommittedRevision().toString();
                } else if (status.isVersioned()) {
                    commitRevision = " ? ";
                }
                if (status.isVersioned() && status.getAuthor() != null) {
                    commitAuthor = status.getAuthor();
                } else if (status.isVersioned()) {
                    commitAuthor = " ? ";
                }
                result.append(SVNStatusPrinter.combineStatus(status).getCode());
                result.append(status.getPropertiesStatus().getCode());
                result.append(status.isLocked() ? (char)'L' : ' ');
                result.append(status.isCopied() ? (char)'+' : ' ');
                result.append(SVNStatusPrinter.getSwitchCharacter(status));
                result.append(lockStatus);
                result.append(treeStatusCode);
                result.append(" ");
                result.append(remoteStatus);
                result.append("   ");
                result.append(SVNFormatUtil.formatString((String)wcRevision, (int)6, (boolean)false, (boolean)false));
                result.append("   ");
                result.append(SVNFormatUtil.formatString((String)commitRevision, (int)6, (boolean)false, (boolean)false));
                result.append(" ");
                result.append(SVNFormatUtil.formatString((String)commitAuthor, (int)12, (boolean)true));
                result.append(" ");
                result.append(path);
                result.append(movedToLine);
                result.append(movedFromLine);
                result.append(treeDescriptionLine);
            } else {
                result.append(SVNStatusPrinter.combineStatus(status).getCode());
                result.append(status.getPropertiesStatus().getCode());
                result.append(status.isLocked() ? (char)'L' : ' ');
                result.append(status.isCopied() ? (char)'+' : ' ');
                result.append(SVNStatusPrinter.getSwitchCharacter(status));
                result.append(lockStatus);
                result.append(treeStatusCode);
                result.append(" ");
                result.append(remoteStatus);
                result.append("   ");
                result.append(SVNFormatUtil.formatString((String)wcRevision, (int)6, (boolean)false, (boolean)false));
                result.append("   ");
                result.append(path);
                result.append(movedToLine);
                result.append(movedFromLine);
                result.append(treeDescriptionLine);
            }
        } else {
            result.append(SVNStatusPrinter.combineStatus(status).getCode());
            result.append(status.getPropertiesStatus().getCode());
            result.append(status.isLocked() ? (char)'L' : ' ');
            result.append(status.isCopied() ? (char)'+' : ' ');
            result.append(SVNStatusPrinter.getSwitchCharacter(status));
            result.append(status.getLocalLock() != null ? (char)'K' : ' ');
            result.append(treeStatusCode);
            result.append(" ");
            result.append(path);
            result.append(movedToLine);
            result.append(movedFromLine);
            result.append(treeDescriptionLine);
        }
        this.myEnvironment.getOut().println(result);
    }

    private String getRelativePath(File path) {
        return this.myEnvironment.getRelativePath(path);
    }

    public static SVNStatusType combineStatus(SVNStatus status) {
        return status.getCombinedNodeAndContentsStatus();
    }

    private static char getSwitchCharacter(SVNStatus status) {
        if (status == null) {
            return ' ';
        }
        return (char)(status.isSwitched() ? 83 : (status.isFileExternal() ? 88 : 32));
    }
}

