/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCheckoutCommand
extends SVNCommand {
    public SVNCheckoutCommand() {
        super("checkout", new String[]{"co"});
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.IGNORE_EXTERNALS);
        return options;
    }

    public void run() throws SVNException {
        String lastTarget;
        List<String> targets = this.getSVNEnvironment().combineTargets(new ArrayList(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        if (SVNCommandUtil.isURL(lastTarget = targets.get(targets.size() - 1))) {
            if (targets.size() == 1) {
                SVNPath target = new SVNPath(lastTarget, true);
                lastTarget = target.getURL().getPath();
                lastTarget = SVNPathUtil.tail((String)lastTarget);
            } else {
                lastTarget = "";
            }
            targets.add(lastTarget);
        } else if (targets.size() == 1) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNUpdateClient client = this.getSVNEnvironment().getClientManager().getUpdateClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment(), true, false, false));
        }
        SVNRevision revision = this.getSVNEnvironment().getStartRevision();
        for (int i = 0; i < targets.size() - 1; ++i) {
            SVNPath dstTarget;
            String targetDir;
            String targetName = targets.get(i);
            SVNPath target = new SVNPath(targetName, true);
            if (!target.isURL()) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.BAD_URL, (String)"''{0}'' doesn not appear to be a URL", (Object)targetName), (SVNLogType)SVNLogType.CLIENT);
            }
            if (targets.size() == 2) {
                targetDir = lastTarget;
                dstTarget = new SVNPath(targetDir);
            } else {
                targetDir = target.getURL().getPath();
                targetDir = SVNPathUtil.tail((String)targetDir);
                targetDir = SVNPathUtil.append((String)lastTarget, (String)targetDir);
                dstTarget = new SVNPath(targetDir);
            }
            SVNRevision pegRevision = target.getPegRevision();
            if (revision == SVNRevision.UNDEFINED) {
                revision = pegRevision != SVNRevision.UNDEFINED ? pegRevision : SVNRevision.HEAD;
            }
            client.doCheckout(target.getURL(), dstTarget.getFile(), pegRevision, revision, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isForce());
        }
    }
}

