/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.SVNConsoleAuthenticationProvider;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svn.SVNAddCommand;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNCommandLineConflictHandler;
import org.tmatesoft.svn.cli.svn.SVNCommitCommand;
import org.tmatesoft.svn.cli.svn.SVNConflictAcceptPolicy;
import org.tmatesoft.svn.cli.svn.SVNLogCommand;
import org.tmatesoft.svn.cli.svn.SVNMergeCommand;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNRevertCommand;
import org.tmatesoft.svn.cli.svn.SVNShowRevisionType;
import org.tmatesoft.svn.cli.svn.SVNStatusCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommandEnvironment
extends AbstractSVNCommandEnvironment
implements ISVNCommitHandler {
    private static final String DEFAULT_LOG_MESSAGE_HEADER = "--This line, and those below, will be ignored--";
    private SVNDepth myDepth;
    private SVNDepth mySetDepth;
    private boolean myIsVerbose;
    private boolean myIsUpdate;
    private boolean myIsQuiet;
    private boolean myIsIncremental;
    private boolean myIsHelp;
    private boolean myIsIgnoreExternals;
    private boolean myIsIgnoreKeywords;
    private boolean myIsXML;
    private boolean myIsVersion;
    private String myChangelist;
    private boolean myIsNonInteractive;
    private boolean myIsNoAuthCache;
    private String myUserName;
    private String myPassword;
    private String myConfigDir;
    private boolean myIsDescend = true;
    private boolean myIsNoIgnore;
    private boolean myIsRevprop;
    private boolean myIsStrict;
    private SVNRevision myStartRevision;
    private SVNRevision myEndRevision;
    private boolean myIsForce;
    private String myFilePath;
    private byte[] myFileData;
    private List myTargets;
    private String myEncoding;
    private String myMessage;
    private boolean myIsForceLog;
    private String myEditorCommand;
    private String myDiffCommand;
    private SVNProperties myRevisionProperties;
    private boolean myIsNoUnlock;
    private boolean myIsDryRun;
    private boolean myIsRecordOnly;
    private boolean myIsUseMergeHistory;
    private Collection myExtensions;
    private boolean myIsIgnoreAncestry;
    private boolean myIsShowCopiesAsAdds;
    private String myNativeEOL;
    private boolean myIsRelocate;
    private boolean myIsNoAutoProps;
    private boolean myIsAutoProps;
    private boolean myIsKeepChangelist;
    private boolean myIsParents;
    private boolean myIsKeepLocal;
    private SVNConflictAcceptPolicy myResolveAccept = SVNConflictAcceptPolicy.UNSPECIFIED;
    private boolean myIsRemove;
    private String myNewTarget;
    private String myOldTarget;
    private boolean myIsNoticeAncestry;
    private boolean myIsSummarize;
    private boolean myIsNoDiffDeleted;
    private long myLimit = -1L;
    private boolean myIsStopOnCopy;
    private boolean myIsChangeOptionUsed;
    private boolean myIsRevisionOptionUsed;
    private boolean myIsWithAllRevprops;
    private boolean myIsReIntegrate;
    private boolean myIsTrustServerCertificate;
    private boolean myIsAllowMixedRevisions;
    private List myRevisionRanges;
    private SVNShowRevisionType myShowRevsType;
    private Collection myChangelists;
    private String myAuthorOfInterest;
    private String myRegularExpression;
    private Map myConfigOptions;
    private Map myServersOptions;
    private boolean myIsGitDiffFormat;
    private boolean myIsShowDiff;
    private int myStripCount;

    public SVNCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
        this.myDepth = SVNDepth.UNKNOWN;
        this.mySetDepth = SVNDepth.UNKNOWN;
        this.myStartRevision = SVNRevision.UNDEFINED;
        this.myEndRevision = SVNRevision.UNDEFINED;
        this.myShowRevsType = SVNShowRevisionType.MERGED;
        this.myRevisionRanges = new LinkedList();
        this.myChangelists = new SVNHashSet();
    }

    public void initClientManager() throws SVNException {
        super.initClientManager();
        this.getClientManager().setIgnoreExternals(this.myIsIgnoreExternals);
    }

    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNOption.HELP || option == SVNOption.QUESTION) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (commandName == null) {
            if (this.isVersion()) {
                SVNCommand versionCommand = new SVNCommand("--version", null){

                    protected Collection createSupportedOptions() {
                        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
                        options.add(SVNOption.VERSION);
                        options.add(SVNOption.CONFIG_DIR);
                        options.add(SVNOption.QUIET);
                        return options;
                    }

                    public void run() throws SVNException {
                        AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                        helpCommand.init(SVNCommandEnvironment.this);
                        helpCommand.run();
                    }
                };
                AbstractSVNCommand.registerCommand(versionCommand);
                return "--version";
            }
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Subcommand argument required");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return commandName;
    }

    protected DefaultSVNOptions createClientOptions() throws SVNException {
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir) : SVNWCUtil.getDefaultConfigurationDirectory();
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((File)configDir, (boolean)true);
        options.setAuthStorageEnabled(!this.myIsNoAuthCache);
        if (this.myIsAutoProps) {
            options.setUseAutoProperties(true);
        }
        if (this.myIsNoAutoProps) {
            options.setUseAutoProperties(false);
        }
        if (this.myIsNoUnlock) {
            options.setKeepLocks(true);
        }
        if (this.myResolveAccept == SVNConflictAcceptPolicy.UNSPECIFIED && (!options.isInteractiveConflictResolution() || this.myIsNonInteractive) || this.myResolveAccept == SVNConflictAcceptPolicy.POSTPONE) {
            options.setConflictHandler(null);
        } else {
            if (this.myIsNonInteractive) {
                SVNErrorMessage err;
                if (this.myResolveAccept == SVNConflictAcceptPolicy.EDIT) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--accept={0} incompatible with --non-interactive", (Object)SVNConflictAcceptPolicy.EDIT);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                if (this.myResolveAccept == SVNConflictAcceptPolicy.LAUNCH) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--accept={0} incompatible with --non-interactive", (Object)SVNConflictAcceptPolicy.LAUNCH);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
            }
            options.setConflictHandler((ISVNConflictHandler)new SVNCommandLineConflictHandler(this.myResolveAccept, this));
        }
        options.setInMemoryConfigOptions(this.myConfigOptions);
        return options;
    }

    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        SVNConsoleAuthenticationProvider gnomeKeyringPasswordProvider;
        SVNConsoleAuthenticationProvider authStoreHandler;
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir) : SVNWCUtil.getDefaultConfigurationDirectory();
        final DefaultSVNAuthenticationManager authManager = (DefaultSVNAuthenticationManager)SVNWCUtil.createDefaultAuthenticationManager((File)configDir, (String)this.myUserName, (String)this.myPassword, (!this.myIsNoAuthCache ? 1 : 0) != 0);
        if (!this.myIsNonInteractive) {
            SVNConsoleAuthenticationProvider consoleAuthProvider = new SVNConsoleAuthenticationProvider(this.myIsTrustServerCertificate);
            authManager.setAuthenticationProvider((ISVNAuthenticationProvider)consoleAuthProvider);
            authStoreHandler = consoleAuthProvider;
            gnomeKeyringPasswordProvider = consoleAuthProvider;
        } else {
            authStoreHandler = null;
            gnomeKeyringPasswordProvider = null;
        }
        ISVNAuthenticationStorageOptions authOpts = new ISVNAuthenticationStorageOptions(){

            public boolean isNonInteractive() throws SVNException {
                return SVNCommandEnvironment.this.myIsNonInteractive;
            }

            public ISVNAuthStoreHandler getAuthStoreHandler() throws SVNException {
                return authStoreHandler;
            }

            public boolean isSSLPassphrasePromptSupported() {
                return authManager.isSSLPassphrasePromtSupported();
            }

            public ISVNGnomeKeyringPasswordProvider getGnomeKeyringPasswordProvider() {
                return gnomeKeyringPasswordProvider;
            }
        };
        authManager.setAuthenticationStorageOptions(authOpts);
        authManager.setInMemoryConfigOptions(this.myConfigOptions);
        authManager.setInMemoryServersOptions(this.myServersOptions);
        return authManager;
    }

    protected void initOptions(SVNCommandLine commandLine) throws SVNException {
        SVNErrorMessage err;
        SVNRevisionRange range;
        SVNErrorMessage err2;
        super.initOptions(commandLine);
        if (this.getCommand().getClass() != SVNMergeCommand.class && this.getCommand().getClass() != SVNLogCommand.class) {
            if (this.myRevisionRanges.size() > 1) {
                err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Multiple revision argument encountered; can't specify -c twice, or both -c and -r");
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (!this.myRevisionRanges.isEmpty() && this.myIsReIntegrate) {
            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"-r and -c can't be used with --reintegrate");
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.myRevisionRanges.isEmpty()) {
            range = new SVNRevisionRange(SVNRevision.UNDEFINED, SVNRevision.UNDEFINED);
            this.myRevisionRanges.add(range);
        }
        range = (SVNRevisionRange)this.myRevisionRanges.get(0);
        this.myStartRevision = range.getStartRevision();
        this.myEndRevision = range.getEndRevision();
        if (this.myIsReIntegrate) {
            if (this.myIsIgnoreAncestry) {
                if (this.myIsRecordOnly) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--reintegrate cannot be used with --ignore-ancestry or --record-only");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                } else {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--reintegrate cannot be used with --ignore-ancestry");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
            } else if (this.myIsRecordOnly) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--reintegrate cannot be used with --record-only");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        }
        if (this.myIsTrustServerCertificate && !this.myIsNonInteractive) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--trust-server-cert requires --non-interactive");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }

    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        block54: {
            AbstractSVNOption option;
            block119: {
                block118: {
                    block117: {
                        block116: {
                            block115: {
                                block114: {
                                    block113: {
                                        block112: {
                                            block111: {
                                                block110: {
                                                    block109: {
                                                        block108: {
                                                            block107: {
                                                                block106: {
                                                                    block105: {
                                                                        block104: {
                                                                            block103: {
                                                                                block102: {
                                                                                    block101: {
                                                                                        block100: {
                                                                                            block99: {
                                                                                                block98: {
                                                                                                    block97: {
                                                                                                        block96: {
                                                                                                            block95: {
                                                                                                                block94: {
                                                                                                                    block93: {
                                                                                                                        block92: {
                                                                                                                            block91: {
                                                                                                                                block90: {
                                                                                                                                    block89: {
                                                                                                                                        block88: {
                                                                                                                                            block87: {
                                                                                                                                                block86: {
                                                                                                                                                    block85: {
                                                                                                                                                        block84: {
                                                                                                                                                            block83: {
                                                                                                                                                                block82: {
                                                                                                                                                                    block81: {
                                                                                                                                                                        block80: {
                                                                                                                                                                            block79: {
                                                                                                                                                                                block78: {
                                                                                                                                                                                    block77: {
                                                                                                                                                                                        block76: {
                                                                                                                                                                                            block75: {
                                                                                                                                                                                                block74: {
                                                                                                                                                                                                    block73: {
                                                                                                                                                                                                        block72: {
                                                                                                                                                                                                            block71: {
                                                                                                                                                                                                                block70: {
                                                                                                                                                                                                                    block69: {
                                                                                                                                                                                                                        block68: {
                                                                                                                                                                                                                            block67: {
                                                                                                                                                                                                                                block66: {
                                                                                                                                                                                                                                    block65: {
                                                                                                                                                                                                                                        block64: {
                                                                                                                                                                                                                                            block63: {
                                                                                                                                                                                                                                                String fileName;
                                                                                                                                                                                                                                                block62: {
                                                                                                                                                                                                                                                    block61: {
                                                                                                                                                                                                                                                        block60: {
                                                                                                                                                                                                                                                            block59: {
                                                                                                                                                                                                                                                                block58: {
                                                                                                                                                                                                                                                                    block57: {
                                                                                                                                                                                                                                                                        block56: {
                                                                                                                                                                                                                                                                            block55: {
                                                                                                                                                                                                                                                                                block53: {
                                                                                                                                                                                                                                                                                    option = optionValue.getOption();
                                                                                                                                                                                                                                                                                    if (option != SVNOption.LIMIT) break block53;
                                                                                                                                                                                                                                                                                    String limitStr = optionValue.getValue();
                                                                                                                                                                                                                                                                                    try {
                                                                                                                                                                                                                                                                                        long limit = Long.parseLong(limitStr);
                                                                                                                                                                                                                                                                                        if (limit <= 0L) {
                                                                                                                                                                                                                                                                                            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.INCORRECT_PARAMS, (String)"Argument to --limit must be positive");
                                                                                                                                                                                                                                                                                            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        this.myLimit = limit;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    catch (NumberFormatException nfe) {
                                                                                                                                                                                                                                                                                        SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Non-numeric limit argument given");
                                                                                                                                                                                                                                                                                        SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    break block54;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (option != SVNOption.MESSAGE) break block55;
                                                                                                                                                                                                                                                                                this.myMessage = optionValue.getValue();
                                                                                                                                                                                                                                                                                break block54;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (option != SVNOption.CHANGE) break block56;
                                                                                                                                                                                                                                                                            if (this.myOldTarget != null) {
                                                                                                                                                                                                                                                                                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Can't specify -c with --old");
                                                                                                                                                                                                                                                                                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            String chValue = optionValue.getValue();
                                                                                                                                                                                                                                                                            StringTokenizer tokens = new StringTokenizer(chValue, ", \n\r\t");
                                                                                                                                                                                                                                                                            while (tokens.hasMoreTokens()) {
                                                                                                                                                                                                                                                                                SVNErrorMessage err;
                                                                                                                                                                                                                                                                                String token = tokens.nextToken();
                                                                                                                                                                                                                                                                                boolean isNegative = false;
                                                                                                                                                                                                                                                                                if (token.startsWith("-")) {
                                                                                                                                                                                                                                                                                    token = token.substring(1);
                                                                                                                                                                                                                                                                                    isNegative = true;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                while (token.startsWith("r")) {
                                                                                                                                                                                                                                                                                    token = token.substring(1);
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                long change = 0L;
                                                                                                                                                                                                                                                                                long changeEnd = 0L;
                                                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                                                    if (token.indexOf("-") > 0) {
                                                                                                                                                                                                                                                                                        if (isNegative || token.startsWith("-")) {
                                                                                                                                                                                                                                                                                            SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Negative number in range ({0}) is not supported with -c", (Object)token);
                                                                                                                                                                                                                                                                                            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        String firstPart = token.substring(0, token.indexOf("-"));
                                                                                                                                                                                                                                                                                        String secondPart = token.substring(token.indexOf("-") + 1);
                                                                                                                                                                                                                                                                                        change = Long.parseLong(firstPart);
                                                                                                                                                                                                                                                                                        while (secondPart.startsWith("r")) {
                                                                                                                                                                                                                                                                                            secondPart = secondPart.substring(1);
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        changeEnd = Long.parseLong(secondPart);
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        changeEnd = change = Long.parseLong(token);
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                catch (NumberFormatException nfe) {
                                                                                                                                                                                                                                                                                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Non-numeric change argument ({0}) given to -c", (Object)token);
                                                                                                                                                                                                                                                                                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (isNegative) {
                                                                                                                                                                                                                                                                                    change = -change;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                SVNRevisionRange range = null;
                                                                                                                                                                                                                                                                                if (change == 0L) {
                                                                                                                                                                                                                                                                                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"There is no change 0");
                                                                                                                                                                                                                                                                                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                } else if (change > 0L) {
                                                                                                                                                                                                                                                                                    if (change <= changeEnd) {
                                                                                                                                                                                                                                                                                        --change;
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        --changeEnd;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    range = new SVNRevisionRange(SVNRevision.create((long)change), SVNRevision.create((long)changeEnd));
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    change = -change;
                                                                                                                                                                                                                                                                                    changeEnd = change - 1L;
                                                                                                                                                                                                                                                                                    range = new SVNRevisionRange(SVNRevision.create((long)change), SVNRevision.create((long)changeEnd));
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                this.myIsChangeOptionUsed = true;
                                                                                                                                                                                                                                                                                this.myRevisionRanges.add(range);
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            break block54;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (option != SVNOption.REVISION) break block57;
                                                                                                                                                                                                                                                                        String revStr = optionValue.getValue();
                                                                                                                                                                                                                                                                        SVNRevision[] revisions = this.parseRevision(revStr);
                                                                                                                                                                                                                                                                        if (revisions == null) {
                                                                                                                                                                                                                                                                            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Syntax error in revision argument ''{0}''", (Object)revStr);
                                                                                                                                                                                                                                                                            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        SVNRevisionRange range = new SVNRevisionRange(revisions[0], revisions[1]);
                                                                                                                                                                                                                                                                        this.myRevisionRanges.add(range);
                                                                                                                                                                                                                                                                        this.myIsRevisionOptionUsed = true;
                                                                                                                                                                                                                                                                        break block54;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (option != SVNOption.VERBOSE) break block58;
                                                                                                                                                                                                                                                                    this.myIsVerbose = true;
                                                                                                                                                                                                                                                                    break block54;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (option != SVNOption.UPDATE) break block59;
                                                                                                                                                                                                                                                                this.myIsUpdate = true;
                                                                                                                                                                                                                                                                break block54;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (option != SVNOption.HELP && option != SVNOption.QUESTION) break block60;
                                                                                                                                                                                                                                                            this.myIsHelp = true;
                                                                                                                                                                                                                                                            break block54;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (option != SVNOption.QUIET) break block61;
                                                                                                                                                                                                                                                        this.myIsQuiet = true;
                                                                                                                                                                                                                                                        break block54;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (option != SVNOption.INCREMENTAL) break block62;
                                                                                                                                                                                                                                                    this.myIsIncremental = true;
                                                                                                                                                                                                                                                    break block54;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (option != SVNOption.FILE) break block63;
                                                                                                                                                                                                                                                this.myFilePath = fileName = optionValue.getValue();
                                                                                                                                                                                                                                                this.myFileData = this.readFromFile(new File(fileName));
                                                                                                                                                                                                                                                break block54;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (option != SVNOption.TARGETS) break block64;
                                                                                                                                                                                                                                            String fileName = optionValue.getValue();
                                                                                                                                                                                                                                            byte[] data = this.readFromFile(new File(fileName));
                                                                                                                                                                                                                                            try {
                                                                                                                                                                                                                                                String[] targets = new String(data, "UTF-8").split("[\n\r]");
                                                                                                                                                                                                                                                this.myTargets = new LinkedList();
                                                                                                                                                                                                                                                for (int i = 0; i < targets.length; ++i) {
                                                                                                                                                                                                                                                    if (targets[i].trim().length() <= 0) continue;
                                                                                                                                                                                                                                                    this.myTargets.add(targets[i].trim());
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            catch (UnsupportedEncodingException e) {
                                                                                                                                                                                                                                                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getMessage());
                                                                                                                                                                                                                                                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            break block54;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (option != SVNOption.FORCE) break block65;
                                                                                                                                                                                                                                        this.myIsForce = true;
                                                                                                                                                                                                                                        break block54;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (option != SVNOption.FORCE_LOG) break block66;
                                                                                                                                                                                                                                    this.myIsForceLog = true;
                                                                                                                                                                                                                                    break block54;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (option != SVNOption.DRY_RUN) break block67;
                                                                                                                                                                                                                                this.myIsDryRun = true;
                                                                                                                                                                                                                                break block54;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (option != SVNOption.REVPROP) break block68;
                                                                                                                                                                                                                            this.myIsRevprop = true;
                                                                                                                                                                                                                            break block54;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (option != SVNOption.RECURSIVE) break block69;
                                                                                                                                                                                                                        this.myDepth = SVNDepth.fromRecurse((boolean)true);
                                                                                                                                                                                                                        break block54;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (option != SVNOption.NON_RECURSIVE) break block70;
                                                                                                                                                                                                                    this.myIsDescend = false;
                                                                                                                                                                                                                    break block54;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (option != SVNOption.DEPTH) break block71;
                                                                                                                                                                                                                String depth = optionValue.getValue();
                                                                                                                                                                                                                if (SVNDepth.EMPTY.getName().equals(depth)) {
                                                                                                                                                                                                                    this.myDepth = SVNDepth.EMPTY;
                                                                                                                                                                                                                } else if (SVNDepth.FILES.getName().equals(depth)) {
                                                                                                                                                                                                                    this.myDepth = SVNDepth.FILES;
                                                                                                                                                                                                                } else if (SVNDepth.IMMEDIATES.getName().equals(depth)) {
                                                                                                                                                                                                                    this.myDepth = SVNDepth.IMMEDIATES;
                                                                                                                                                                                                                } else if (SVNDepth.INFINITY.getName().equals(depth)) {
                                                                                                                                                                                                                    this.myDepth = SVNDepth.INFINITY;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid depth; try ''empty'', ''files'', ''immediates'', or ''infinity''", (Object)depth);
                                                                                                                                                                                                                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                                }
                                                                                                                                                                                                                break block54;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (option != SVNOption.SET_DEPTH) break block72;
                                                                                                                                                                                                            String depth = optionValue.getValue();
                                                                                                                                                                                                            if (SVNDepth.EMPTY.getName().equals(depth)) {
                                                                                                                                                                                                                this.mySetDepth = SVNDepth.EMPTY;
                                                                                                                                                                                                            } else if (SVNDepth.FILES.getName().equals(depth)) {
                                                                                                                                                                                                                this.mySetDepth = SVNDepth.FILES;
                                                                                                                                                                                                            } else if (SVNDepth.IMMEDIATES.getName().equals(depth)) {
                                                                                                                                                                                                                this.mySetDepth = SVNDepth.IMMEDIATES;
                                                                                                                                                                                                            } else if (SVNDepth.INFINITY.getName().equals(depth)) {
                                                                                                                                                                                                                this.mySetDepth = SVNDepth.INFINITY;
                                                                                                                                                                                                            } else if (SVNDepth.EXCLUDE.getName().equals(depth)) {
                                                                                                                                                                                                                this.mySetDepth = SVNDepth.EXCLUDE;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid depth; try ''exclude'', ''empty'', ''files'', ''immediates'', or ''infinity''", (Object)depth);
                                                                                                                                                                                                                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                                                                                            }
                                                                                                                                                                                                            break block54;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (option != SVNOption.VERSION) break block73;
                                                                                                                                                                                                        this.myIsVersion = true;
                                                                                                                                                                                                        break block54;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (option != SVNOption.USERNAME) break block74;
                                                                                                                                                                                                    this.myUserName = optionValue.getValue();
                                                                                                                                                                                                    break block54;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (option != SVNOption.PASSWORD) break block75;
                                                                                                                                                                                                this.myPassword = optionValue.getValue();
                                                                                                                                                                                                break block54;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (option != SVNOption.ENCODING) break block76;
                                                                                                                                                                                            this.myEncoding = optionValue.getValue();
                                                                                                                                                                                            break block54;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (option != SVNOption.XML) break block77;
                                                                                                                                                                                        this.myIsXML = true;
                                                                                                                                                                                        break block54;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (option != SVNOption.STOP_ON_COPY) break block78;
                                                                                                                                                                                    this.myIsStopOnCopy = true;
                                                                                                                                                                                    break block54;
                                                                                                                                                                                }
                                                                                                                                                                                if (option != SVNOption.STRICT) break block79;
                                                                                                                                                                                this.myIsStrict = true;
                                                                                                                                                                                break block54;
                                                                                                                                                                            }
                                                                                                                                                                            if (option != SVNOption.NO_AUTH_CACHE) break block80;
                                                                                                                                                                            this.myIsNoAuthCache = true;
                                                                                                                                                                            break block54;
                                                                                                                                                                        }
                                                                                                                                                                        if (option != SVNOption.NON_INTERACTIVE) break block81;
                                                                                                                                                                        this.myIsNonInteractive = true;
                                                                                                                                                                        break block54;
                                                                                                                                                                    }
                                                                                                                                                                    if (option != SVNOption.NO_DIFF_DELETED) break block82;
                                                                                                                                                                    this.myIsNoDiffDeleted = true;
                                                                                                                                                                    break block54;
                                                                                                                                                                }
                                                                                                                                                                if (option != SVNOption.NOTICE_ANCESTRY) break block83;
                                                                                                                                                                this.myIsNoticeAncestry = true;
                                                                                                                                                                break block54;
                                                                                                                                                            }
                                                                                                                                                            if (option != SVNOption.IGNORE_ANCESTRY) break block84;
                                                                                                                                                            this.myIsIgnoreAncestry = true;
                                                                                                                                                            break block54;
                                                                                                                                                        }
                                                                                                                                                        if (option != SVNOption.SHOW_COPIES_AS_ADDS) break block85;
                                                                                                                                                        this.myIsShowCopiesAsAdds = true;
                                                                                                                                                        break block54;
                                                                                                                                                    }
                                                                                                                                                    if (option != SVNOption.GIT_DIFF_FORMAT) break block86;
                                                                                                                                                    this.myIsGitDiffFormat = true;
                                                                                                                                                    break block54;
                                                                                                                                                }
                                                                                                                                                if (option != SVNOption.DIFF) break block87;
                                                                                                                                                this.myIsShowDiff = true;
                                                                                                                                                break block54;
                                                                                                                                            }
                                                                                                                                            if (option != SVNOption.IGNORE_EXTERNALS) break block88;
                                                                                                                                            this.myIsIgnoreExternals = true;
                                                                                                                                            break block54;
                                                                                                                                        }
                                                                                                                                        if (option != SVNOption.IGNORE_KEYWORDS) break block89;
                                                                                                                                        this.myIsIgnoreKeywords = true;
                                                                                                                                        break block54;
                                                                                                                                    }
                                                                                                                                    if (option != SVNOption.RELOCATE) break block90;
                                                                                                                                    if (this.myDepth != SVNDepth.UNKNOWN) {
                                                                                                                                        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--depth and --relocate are mutually exclusive"), (SVNLogType)SVNLogType.CLIENT);
                                                                                                                                    }
                                                                                                                                    this.myIsRelocate = true;
                                                                                                                                    break block54;
                                                                                                                                }
                                                                                                                                if (option != SVNOption.EXTENSIONS) break block91;
                                                                                                                                String extensionsString = optionValue.getValue();
                                                                                                                                String[] extensions = extensionsString.trim().split("\\s+");
                                                                                                                                if (this.myExtensions == null) {
                                                                                                                                    this.myExtensions = new SVNHashSet();
                                                                                                                                }
                                                                                                                                this.myExtensions.addAll(Arrays.asList(extensions));
                                                                                                                                break block54;
                                                                                                                            }
                                                                                                                            if (option != SVNOption.RECORD_ONLY) break block92;
                                                                                                                            this.myIsRecordOnly = true;
                                                                                                                            break block54;
                                                                                                                        }
                                                                                                                        if (option != SVNOption.DIFF_CMD) break block93;
                                                                                                                        this.myDiffCommand = optionValue.getValue();
                                                                                                                        break block54;
                                                                                                                    }
                                                                                                                    if (option != SVNOption.EDITOR_CMD) break block94;
                                                                                                                    this.myEditorCommand = optionValue.getValue();
                                                                                                                    break block54;
                                                                                                                }
                                                                                                                if (option != SVNOption.OLD) break block95;
                                                                                                                if (this.myIsChangeOptionUsed) {
                                                                                                                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Can't specify -c with --old"), (SVNLogType)SVNLogType.CLIENT);
                                                                                                                }
                                                                                                                this.myOldTarget = optionValue.getValue();
                                                                                                                break block54;
                                                                                                            }
                                                                                                            if (option != SVNOption.NEW) break block96;
                                                                                                            this.myNewTarget = optionValue.getValue();
                                                                                                            break block54;
                                                                                                        }
                                                                                                        if (option != SVNOption.CONFIG_DIR) break block97;
                                                                                                        this.myConfigDir = optionValue.getValue();
                                                                                                        break block54;
                                                                                                    }
                                                                                                    if (option != SVNOption.CONFIG_OPTION) break block98;
                                                                                                    if (this.myConfigOptions == null) {
                                                                                                        this.myConfigOptions = new HashMap();
                                                                                                    }
                                                                                                    if (this.myServersOptions == null) {
                                                                                                        this.myServersOptions = new HashMap();
                                                                                                    }
                                                                                                    SVNCommandUtil.parseConfigOption(optionValue.getValue(), this.myConfigOptions, this.myServersOptions);
                                                                                                    break block54;
                                                                                                }
                                                                                                if (option != SVNOption.AUTOPROPS) break block99;
                                                                                                if (this.myIsNoAutoProps) {
                                                                                                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--auto-props and --no-auto-props are mutually exclusive"), (SVNLogType)SVNLogType.CLIENT);
                                                                                                }
                                                                                                this.myIsAutoProps = true;
                                                                                                break block54;
                                                                                            }
                                                                                            if (option != SVNOption.NO_AUTOPROPS) break block100;
                                                                                            if (this.myIsAutoProps) {
                                                                                                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--auto-props and --no-auto-props are mutually exclusive"), (SVNLogType)SVNLogType.CLIENT);
                                                                                            }
                                                                                            this.myIsNoAutoProps = true;
                                                                                            break block54;
                                                                                        }
                                                                                        if (option != SVNOption.NATIVE_EOL) break block101;
                                                                                        this.myNativeEOL = optionValue.getValue();
                                                                                        break block54;
                                                                                    }
                                                                                    if (option != SVNOption.NO_UNLOCK) break block102;
                                                                                    this.myIsNoUnlock = true;
                                                                                    break block54;
                                                                                }
                                                                                if (option != SVNOption.SUMMARIZE) break block103;
                                                                                this.myIsSummarize = true;
                                                                                break block54;
                                                                            }
                                                                            if (option != SVNOption.REMOVE) break block104;
                                                                            this.myIsRemove = true;
                                                                            break block54;
                                                                        }
                                                                        if (option != SVNOption.CHANGELIST) break block105;
                                                                        this.myChangelist = optionValue.getValue();
                                                                        if (this.myChangelist == null) {
                                                                            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Changelist names must not be empty");
                                                                            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                                                        }
                                                                        this.myChangelists.add(this.myChangelist);
                                                                        break block54;
                                                                    }
                                                                    if (option != SVNOption.KEEP_CHANGELISTS) break block106;
                                                                    this.myIsKeepChangelist = true;
                                                                    break block54;
                                                                }
                                                                if (option != SVNOption.KEEP_LOCAL) break block107;
                                                                this.myIsKeepLocal = true;
                                                                break block54;
                                                            }
                                                            if (option != SVNOption.NO_IGNORE) break block108;
                                                            this.myIsNoIgnore = true;
                                                            break block54;
                                                        }
                                                        if (option != SVNOption.WITH_ALL_REVPROPS) break block109;
                                                        this.myIsWithAllRevprops = true;
                                                        break block54;
                                                    }
                                                    if (option != SVNOption.WITH_REVPROP) break block110;
                                                    this.parseRevisionProperty(optionValue);
                                                    break block54;
                                                }
                                                if (option != SVNOption.PARENTS) break block111;
                                                this.myIsParents = true;
                                                break block54;
                                            }
                                            if (option != SVNOption.USE_MERGE_HISTORY) break block112;
                                            this.myIsUseMergeHistory = true;
                                            break block54;
                                        }
                                        if (option != SVNOption.ACCEPT) break block113;
                                        SVNConflictAcceptPolicy accept = SVNConflictAcceptPolicy.fromString(optionValue.getValue());
                                        if (accept == SVNConflictAcceptPolicy.INVALID) {
                                            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid --accept value;", (Object)optionValue.getValue());
                                            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                        }
                                        this.myResolveAccept = accept;
                                        break block54;
                                    }
                                    if (option != SVNOption.SHOW_REVS) break block114;
                                    this.myShowRevsType = SVNShowRevisionType.fromString(optionValue.getValue());
                                    if (this.myShowRevsType != SVNShowRevisionType.INVALID) break block54;
                                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid --show-revs value", (Object)optionValue.getValue());
                                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                                    break block54;
                                }
                                if (option != SVNOption.REINTEGRATE) break block115;
                                this.myIsReIntegrate = true;
                                break block54;
                            }
                            if (option != SVNOption.ALLOW_MIXED_REVISIONS) break block116;
                            this.myIsAllowMixedRevisions = true;
                            break block54;
                        }
                        if (option != SVNOption.AUTHOR_OF_INTEREST) break block117;
                        this.myAuthorOfInterest = optionValue.getValue();
                        break block54;
                    }
                    if (option != SVNOption.REGULAR_EXPRESSION) break block118;
                    this.myRegularExpression = optionValue.getValue();
                    break block54;
                }
                if (option != SVNOption.TRUST_SERVER_CERT) break block119;
                this.myIsTrustServerCertificate = true;
                break block54;
            }
            if (option != SVNOption.STRIP) break block54;
            String value = optionValue.getValue();
            try {
                this.myStripCount = Integer.parseInt(optionValue.getValue());
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Non-numeric change argument ({0}) given to -strip", (Object)value);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        }
    }

    protected SVNCommand getSVNCommand() {
        return (SVNCommand)this.getCommand();
    }

    protected void validateOptions(SVNCommandLine commandLine) throws SVNException {
        SVNErrorMessage err;
        super.validateOptions(commandLine);
        if (!this.isForceLog() && this.getSVNCommand().isCommitter()) {
            File file;
            if (this.myFilePath != null && this.isVersioned(this.myFilePath)) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_LOG_MESSAGE_IS_VERSIONED_FILE, (String)this.getSVNCommand().getFileAmbigousErrorMessage());
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if (this.myMessage != null && !"".equals(this.myMessage) && SVNFileType.getType((File)(file = new File(this.myMessage).getAbsoluteFile())) != SVNFileType.NONE) {
                SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_LOG_MESSAGE_IS_PATHNAME, (String)this.getSVNCommand().getMessageAmbigousErrorMessage());
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
        }
        if (!this.getSVNCommand().acceptsRevisionRange() && this.getEndRevision() != SVNRevision.UNDEFINED) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_REVISION_RANGE);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (!this.myIsDescend) {
            this.myDepth = this.getCommand() instanceof SVNStatusCommand ? SVNDepth.IMMEDIATES : (this.getCommand() instanceof SVNRevertCommand || this.getCommand() instanceof SVNAddCommand || this.getCommand() instanceof SVNCommitCommand ? SVNDepth.EMPTY : SVNDepth.FILES);
        }
        if ("relocate".equals(this.getCommandName())) {
            this.myIsRelocate = true;
        }
    }

    protected String getCommandLineClientName() {
        return "svn";
    }

    public boolean isReIntegrate() {
        return this.myIsReIntegrate;
    }

    public SVNShowRevisionType getShowRevisionType() {
        return this.myShowRevsType;
    }

    public boolean isChangeOptionUsed() {
        return this.myIsChangeOptionUsed;
    }

    public boolean isRevisionOptionUsed() {
        return this.myIsRevisionOptionUsed;
    }

    public String getChangelist() {
        return this.myChangelist;
    }

    public String[] getChangelists() {
        if (this.myChangelists != null && !this.myChangelists.isEmpty()) {
            return this.myChangelists.toArray(new String[this.myChangelists.size()]);
        }
        return null;
    }

    public Collection getChangelistsCollection() {
        return this.myChangelists;
    }

    public boolean isIgnoreKeywords() {
        return this.myIsIgnoreKeywords;
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    public SVNDepth getSetDepth() {
        return this.mySetDepth;
    }

    public boolean isVerbose() {
        return this.myIsVerbose;
    }

    public boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    public boolean isUpdate() {
        return this.myIsUpdate;
    }

    public boolean isQuiet() {
        return this.myIsQuiet;
    }

    public boolean isIncremental() {
        return this.myIsIncremental;
    }

    public boolean isRevprop() {
        return this.myIsRevprop;
    }

    public boolean isStrict() {
        return this.myIsStrict;
    }

    public List getRevisionRanges() {
        return this.myRevisionRanges;
    }

    public SVNRevision getStartRevision() {
        return this.myStartRevision;
    }

    public SVNRevision getEndRevision() {
        return this.myEndRevision;
    }

    public boolean isXML() {
        return this.myIsXML;
    }

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public boolean isForce() {
        return this.myIsForce;
    }

    public String getEncoding() {
        return this.myEncoding;
    }

    public byte[] getFileData() {
        return this.myFileData;
    }

    public List getTargets() {
        return this.myTargets;
    }

    public boolean isForceLog() {
        return this.myIsForceLog;
    }

    public String getEditorCommand() {
        return this.myEditorCommand;
    }

    public String getDiffCommand() {
        return this.myDiffCommand;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public SVNProperties getRevisionProperties() {
        return this.myRevisionProperties;
    }

    public boolean isDryRun() {
        return this.myIsDryRun;
    }

    public boolean isIgnoreAncestry() {
        return this.myIsIgnoreAncestry;
    }

    public boolean isShowCopiesAsAdds() {
        return this.myIsShowCopiesAsAdds;
    }

    public boolean isGitDiffFormat() {
        return this.myIsGitDiffFormat;
    }

    public boolean isShowDiff() {
        return this.myIsShowDiff;
    }

    public boolean isUseMergeHistory() {
        return this.myIsUseMergeHistory;
    }

    public boolean isRecordOnly() {
        return this.myIsRecordOnly;
    }

    public Collection getExtensions() {
        return this.myExtensions;
    }

    public String getNativeEOL() {
        return this.myNativeEOL;
    }

    public boolean isRelocate() {
        return this.myIsRelocate;
    }

    public boolean isNoUnlock() {
        return this.myIsNoUnlock;
    }

    public boolean isKeepChangelist() {
        return this.myIsKeepChangelist;
    }

    public boolean isParents() {
        return this.myIsParents;
    }

    public boolean isKeepLocal() {
        return this.myIsKeepLocal;
    }

    public SVNConflictAcceptPolicy getResolveAccept() {
        return this.myResolveAccept;
    }

    public boolean isRemove() {
        return this.myIsRemove;
    }

    public boolean isSummarize() {
        return this.myIsSummarize;
    }

    public boolean isNoticeAncestry() {
        return this.myIsNoticeAncestry;
    }

    public boolean isNoDiffDeleted() {
        return this.myIsNoDiffDeleted;
    }

    public String getOldTarget() {
        return this.myOldTarget;
    }

    public String getNewTarget() {
        return this.myNewTarget;
    }

    public String getAuthorOfInterest() {
        return this.myAuthorOfInterest;
    }

    public String getRegularExpression() {
        return this.myRegularExpression;
    }

    public long getLimit() {
        return this.myLimit;
    }

    public boolean isStopOnCopy() {
        return this.myIsStopOnCopy;
    }

    public boolean isAllRevisionProperties() {
        return this.myIsWithAllRevprops;
    }

    public int getStripCount() {
        return this.myStripCount;
    }

    public SVNDiffOptions getDiffOptions() throws SVNException {
        boolean ignoreEOLStyle;
        boolean ignoreAmountOfWS;
        boolean ignoreAllWS;
        if (this.myExtensions == null) {
            return null;
        }
        LinkedList extensions = new LinkedList(this.myExtensions);
        boolean bl = ignoreAllWS = this.myExtensions.contains("-w") || this.myExtensions.contains("--ignore-all-space");
        if (ignoreAllWS) {
            extensions.remove("-w");
            extensions.remove("--ignore-all-space");
        }
        boolean bl2 = ignoreAmountOfWS = this.myExtensions.contains("-b") || this.myExtensions.contains("--ignore-space-change");
        if (ignoreAmountOfWS) {
            extensions.remove("-b");
            extensions.remove("--ignore-space-change");
        }
        if (ignoreEOLStyle = this.myExtensions.contains("--ignore-eol-style")) {
            extensions.remove("--ignore-eol-style");
        }
        if (!extensions.isEmpty()) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.INVALID_DIFF_OPTION, (String)"Invalid argument ''{0}'' in diff options", extensions.get(0));
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return new SVNDiffOptions(ignoreAllWS, ignoreAmountOfWS, ignoreEOLStyle);
    }

    public boolean isAllowMixedRevisions() {
        return this.myIsAllowMixedRevisions;
    }

    public SVNProperties getRevisionProperties(String message, SVNCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
        return revisionProperties == null ? new SVNProperties() : revisionProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommitMessage(String message, SVNCommitItem[] commitables) throws SVNException {
        if (this.getFileData() != null) {
            byte[] data = this.getFileData();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 0) continue;
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_BAD_LOG_MESSAGE, (String)"Log message contains a zero byte"), (SVNLogType)SVNLogType.CLIENT);
            }
            String charset = this.getEncoding();
            if (charset == null) {
                charset = this.getOptions().getLogEncoding();
            }
            if (charset == null) {
                charset = this.getOptions().getNativeCharset();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream os = SVNTranslator.getTranslatingOutputStream((OutputStream)bos, (String)charset, (byte[])new byte[]{10}, (boolean)false, null, (boolean)false);
            try {
                os.write(this.getFileData());
                os.close();
                os = null;
                String string = new String(bos.toByteArray(), "UTF-8");
                return string;
            }
            catch (UnsupportedEncodingException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getMessage()), (SVNLogType)SVNLogType.CLIENT);
            }
            catch (IOException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"Error normalizing log message to internal format"), (SVNLogType)SVNLogType.CLIENT);
            }
            finally {
                SVNFileUtil.closeFile((OutputStream)os);
            }
        } else if (this.getMessage() != null) {
            return this.getMessage();
        }
        if (commitables == null || commitables.length == 0) {
            return "";
        }
        if (this.myIsNonInteractive) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Cannot invoke editor to get log message when non-interactive");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        message = null;
        while (message == null) {
            message = this.createCommitMessageTemplate(commitables);
            byte[] messageData = null;
            try {
                try {
                    messageData = message.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    messageData = message.getBytes();
                }
                messageData = SVNCommandUtil.runEditor(this, this.getEditorCommand(), messageData, "svn-commit");
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_EDITOR) {
                    SVNErrorMessage err = e.getErrorMessage().wrap("Could not use external editor to fetch log message; consider setting the $SVN_EDITOR environment variable or using the --message (-m) or --file (-F) options");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                throw e;
            }
            if (messageData != null) {
                String editedMessage = null;
                try {
                    editedMessage = this.getEncoding() != null ? new String(messageData, this.getEncoding()) : new String(messageData);
                }
                catch (UnsupportedEncodingException e) {
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getMessage());
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                if (editedMessage.indexOf(DEFAULT_LOG_MESSAGE_HEADER) >= 0) {
                    editedMessage = editedMessage.substring(0, editedMessage.indexOf(DEFAULT_LOG_MESSAGE_HEADER));
                }
                if (!"a".equals(editedMessage.trim())) {
                    return editedMessage;
                }
            }
            message = null;
            this.getOut().println("\nLog message unchanged or not specified\na)bort, c)ontinue, e)dit");
            try {
                char c = (char)this.getIn().read();
                if (c == 'a') {
                    SVNErrorManager.cancel((String)"", (SVNLogType)SVNLogType.CLIENT);
                    continue;
                }
                if (c == 'c') {
                    return "";
                }
                if (c != 'e') continue;
            }
            catch (IOException e) {}
        }
        SVNErrorManager.cancel((String)"", (SVNLogType)SVNLogType.CLIENT);
        return null;
    }

    private void parseRevisionProperty(SVNOptionValue optionValue) throws SVNException {
        String revProp;
        if (this.myRevisionProperties == null) {
            this.myRevisionProperties = new SVNProperties();
        }
        if ((revProp = optionValue.getValue()) == null || "".equals(revProp)) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Revision property pair is empty");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        int index = revProp.indexOf(61);
        String revPropName = null;
        String revPropValue = null;
        if (index >= 0) {
            revPropName = revProp.substring(0, index);
            revPropValue = revProp.substring(index + 1);
        } else {
            revPropName = revProp;
            revPropValue = "";
        }
        if (!SVNPropertiesManager.isValidPropertyName((String)revPropName)) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_PROPERTY_NAME, (String)"''{0}'' is not a valid Subversion property name", (Object)revPropName);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        this.myRevisionProperties.put(revPropName, revPropValue);
    }

    private String createCommitMessageTemplate(SVNCommitItem[] items) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(System.getProperty("line.separator"));
        buffer.append(DEFAULT_LOG_MESSAGE_HEADER);
        buffer.append(System.getProperty("line.separator"));
        buffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < items.length; ++i) {
            String path;
            SVNCommitItem item = items[i];
            String string = path = item.getPath() != null ? item.getPath() : item.getURL().toString();
            if ("".equals(path) || path == null) {
                path = ".";
            }
            if (item.isDeleted() && item.isAdded()) {
                buffer.append('R');
            } else if (item.isDeleted()) {
                buffer.append('D');
            } else if (item.isAdded()) {
                buffer.append('A');
            } else if (item.isContentsModified()) {
                buffer.append('M');
            } else {
                buffer.append('_');
            }
            if (item.isPropertiesModified()) {
                buffer.append('M');
            } else {
                buffer.append(' ');
            }
            if (!this.myIsNoUnlock && item.isLocked()) {
                buffer.append('L');
            } else {
                buffer.append(' ');
            }
            if (item.isCopied()) {
                buffer.append("+ ");
            } else {
                buffer.append("  ");
            }
            buffer.append(path);
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }
}

