/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNImportCommand
extends SVNCommand {
    public SVNImportCommand() {
        super("import", null);
    }

    public boolean isCommitter() {
        return true;
    }

    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.AUTOPROPS);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.NO_AUTOPROPS);
        options = SVNOption.addLogMessageOptions(options);
        options.add(SVNOption.NO_IGNORE);
        return options;
    }

    public void run() throws SVNException {
        SVNDepth depth;
        List<String> targets = this.getSVNEnvironment().combineTargets(new ArrayList(), true);
        SVNPath url = null;
        SVNPath src = null;
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Repository URL required when importing"), (SVNLogType)SVNLogType.CLIENT);
        } else if (targets.size() > 2) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Too many arguments to import command"), (SVNLogType)SVNLogType.CLIENT);
        } else if (targets.size() == 1) {
            src = new SVNPath("");
            url = new SVNPath(targets.get(0));
        } else {
            src = new SVNPath(targets.get(0));
            url = new SVNPath(targets.get(1));
        }
        if (!url.isURL()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Invalid URL ''{0}''", (Object)url.getTarget()), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNCommitClient client = this.getSVNEnvironment().getClientManager().getCommitClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        client.setCommitHandler((ISVNCommitHandler)this.getSVNEnvironment());
        SVNCommitInfo info = client.doImport(src.getFile(), url.getURL(), this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), !this.getSVNEnvironment().isNoIgnore(), this.getSVNEnvironment().isForce(), depth);
        if (!this.getSVNEnvironment().isQuiet()) {
            this.getSVNEnvironment().printCommitInfo(info);
        }
    }
}

