/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNShowRevisionType;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnLogMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNMergeInfoCommand
extends SVNCommand
implements ISVNLogEntryHandler {
    public SVNMergeInfoCommand() {
        super("mergeinfo", null);
    }

    @Override
    protected Collection<SVNOption> createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.SHOW_REVS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNPath source;
        SVNRevision srcPegRevision;
        SVNErrorMessage err;
        List<String> targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.size() < 1) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Not enough arguments given");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (targets.size() > 2) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Too many arguments given");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if ((srcPegRevision = (source = new SVNPath(targets.get(0), true)).getPegRevision()) == SVNRevision.UNDEFINED) {
            srcPegRevision = SVNRevision.HEAD;
        }
        SVNPath target = null;
        SVNRevision tgtPegRevision = null;
        if (targets.size() == 2) {
            target = new SVNPath(targets.get(1), true);
            tgtPegRevision = target.getPegRevision();
        } else {
            target = new SVNPath("");
            tgtPegRevision = SVNRevision.UNDEFINED;
        }
        if (tgtPegRevision == SVNRevision.UNDEFINED) {
            tgtPegRevision = target.isURL() ? SVNRevision.HEAD : SVNRevision.BASE;
        }
        SVNDiffClient client = this.getSVNEnvironment().getClientManager().getDiffClient();
        SvnOperationFactory of = client.getOperationsFactory();
        SVNDepth depth = this.getSVNEnvironment().getDepth();
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        SvnLogMergeInfo logMergeInfo = of.createLogMergeInfo();
        logMergeInfo.setDepth(depth);
        logMergeInfo.setDiscoverChangedPaths(true);
        logMergeInfo.setRevisionProperties(null);
        logMergeInfo.setReceiver((ISvnObjectReceiver)new ISvnObjectReceiver<SVNLogEntry>(){

            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                SVNMergeInfoCommand.this.handleLogEntry(object);
            }
        });
        logMergeInfo.setFindMerged(this.getSVNEnvironment().getShowRevisionType() == SVNShowRevisionType.MERGED);
        if (target.isURL()) {
            logMergeInfo.setSingleTarget(SvnTarget.fromURL((SVNURL)target.getURL(), (SVNRevision)tgtPegRevision));
        } else {
            logMergeInfo.setSingleTarget(SvnTarget.fromFile((File)target.getFile(), (SVNRevision)tgtPegRevision));
        }
        if (source.isURL()) {
            logMergeInfo.setSource(SvnTarget.fromURL((SVNURL)source.getURL(), (SVNRevision)srcPegRevision));
        } else {
            logMergeInfo.setSource(SvnTarget.fromFile((File)source.getFile(), (SVNRevision)srcPegRevision));
        }
        logMergeInfo.run();
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        String message = logEntry.isNonInheritable() ? MessageFormat.format("r{0}*", String.valueOf(logEntry.getRevision())) : MessageFormat.format("r{0}", String.valueOf(logEntry.getRevision()));
        this.getSVNEnvironment().getOut().println(message);
    }
}

