/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPropEditCommand
extends SVNPropertiesCommand {
    public SVNPropEditCommand() {
        super("propedit", new String[]{"pedit", "pe"});
    }

    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.REVPROP);
        options = SVNOption.addLogMessageOptions(options);
        options.add(SVNOption.FORCE);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    public void run() throws SVNException {
        SVNErrorMessage err;
        String propertyName = this.getSVNEnvironment().popArgument();
        if (propertyName == null) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (!SVNPropertiesManager.isValidPropertyName((String)propertyName)) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_PROPERTY_NAME, (String)"''{0}'' is not a valid Subversion property name", (Object)propertyName);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        List<Object> targets = new ArrayList();
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (this.getSVNEnvironment().isRevprop()) {
            long rev;
            if (targets.isEmpty()) {
                targets.add("");
            }
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            String target = this.checkRevPropTarget(this.getSVNEnvironment().getStartRevision(), targets);
            Object var5_8 = null;
            File targetPath = null;
            if (SVNCommandUtil.isURL(target)) {
                SVNURL sVNURL = SVNURL.parseURIEncoded((String)target);
                rev = client.doGetRevisionProperty(sVNURL, propertyName, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            } else {
                targetPath = new SVNPath(target).getFile();
                rev = client.doGetRevisionProperty(targetPath, propertyName, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            }
            SVNPropertyData property = this.getRevisionProperty(rev);
            SVNPropertyValue propertyValue = property != null ? property.getValue() : SVNPropertyValue.create((String)"");
            byte[] propBytes = SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)propertyValue);
            byte[] bytes = SVNCommandUtil.runEditor(this.getSVNEnvironment(), this.getSVNEnvironment().getEditorCommand(), propBytes, "svn-prop");
            SVNPropertyValue newPropertyValue = SVNPropertyValue.create((String)propertyName, (byte[])bytes);
            if (newPropertyValue != null && !newPropertyValue.equals((Object)propertyValue)) {
                void var5_10;
                this.clearCollectedProperties();
                if (var5_10 != null) {
                    client.doSetRevisionProperty((SVNURL)var5_10, SVNRevision.create((long)rev), propertyName, newPropertyValue, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
                } else if (targetPath != null) {
                    client.doSetRevisionProperty(targetPath, SVNRevision.create((long)rev), propertyName, newPropertyValue, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
                }
                String message = "Set new value for property ''{0}'' on revision {1}";
                message = MessageFormat.format(message, propertyName, new Long(rev));
                this.getSVNEnvironment().getOut().println(message);
            } else {
                String message = "No changes to property ''{0}'' on revision {1}";
                message = MessageFormat.format(message, propertyName, new Long(rev));
                this.getSVNEnvironment().getOut().println(message);
            }
        } else if (this.getSVNEnvironment().getStartRevision() != SVNRevision.UNDEFINED) {
            SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Cannot specify revision for editing versioned property ''{0}''", (Object)propertyName);
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        } else {
            if (targets.isEmpty()) {
                SVNErrorMessage err3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Explicit target argument required", (Object)propertyName);
                SVNErrorManager.error((SVNErrorMessage)err3, (SVNLogType)SVNLogType.CLIENT);
            }
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            for (String string : targets) {
                String message;
                SVNPropertyValue newPropertyValue;
                byte[] bytes;
                byte[] propBytes;
                SVNPropertyValue propertyValue;
                SVNPropertyData property;
                SVNPath target = new SVNPath(string);
                if (target.isFile()) {
                    String path;
                    if (this.getSVNEnvironment().getMessage() != null || this.getSVNEnvironment().getFileData() != null || this.getSVNEnvironment().getRevisionProperties() != null) {
                        SVNErrorMessage err4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, (String)"Local, non-commit operations do not take a log message or revision properties");
                        SVNErrorManager.error((SVNErrorMessage)err4, (SVNLogType)SVNLogType.CLIENT);
                    }
                    propertyValue = (property = client.doGetProperty(target.getFile(), propertyName, SVNRevision.UNDEFINED, SVNRevision.WORKING)) != null ? property.getValue() : SVNPropertyValue.create((String)"");
                    propBytes = SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)propertyValue);
                    bytes = SVNCommandUtil.runEditor(this.getSVNEnvironment(), this.getSVNEnvironment().getEditorCommand(), propBytes, "svn-prop");
                    newPropertyValue = SVNPropertyValue.create((String)propertyName, (byte[])bytes);
                    if (newPropertyValue != null && !newPropertyValue.equals((Object)propertyValue)) {
                        this.checkBooleanProperty(propertyName, newPropertyValue);
                        client.doSetProperty(target.getFile(), propertyName, newPropertyValue, this.getSVNEnvironment().isForce(), SVNDepth.EMPTY, (ISVNPropertyHandler)this, null);
                        message = "Set new value for property ''{0}'' on ''{1}''";
                        path = SVNCommandUtil.getLocalPath(string);
                        message = MessageFormat.format(message, propertyName, path);
                        this.getSVNEnvironment().getOut().println(message);
                    } else {
                        message = "No changes to property ''{0}'' on ''{1}''";
                        path = SVNCommandUtil.getLocalPath(string);
                        message = MessageFormat.format(message, propertyName, path);
                        this.getSVNEnvironment().getOut().println(message);
                    }
                } else {
                    property = client.doGetProperty(target.getURL(), propertyName, SVNRevision.UNDEFINED, SVNRevision.HEAD);
                    propertyValue = property != null ? property.getValue() : SVNPropertyValue.create((String)"");
                    propBytes = SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)propertyValue);
                    bytes = SVNCommandUtil.runEditor(this.getSVNEnvironment(), this.getSVNEnvironment().getEditorCommand(), propBytes, "svn-prop");
                    newPropertyValue = SVNPropertyValue.create((String)propertyName, (byte[])bytes);
                    if (newPropertyValue != null && !newPropertyValue.equals((Object)propertyValue)) {
                        this.checkBooleanProperty(propertyName, newPropertyValue);
                        client.setCommitHandler((ISVNCommitHandler)this.getSVNEnvironment());
                        SVNCommitInfo info = client.doSetProperty(target.getURL(), propertyName, newPropertyValue, SVNRevision.HEAD, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
                        String message2 = "Set new value for property ''{0}'' on ''{1}''";
                        message2 = MessageFormat.format(message2, propertyName, string);
                        this.getSVNEnvironment().getOut().println(message2);
                        if (!this.getSVNEnvironment().isQuiet()) {
                            this.getSVNEnvironment().printCommitInfo(info);
                        }
                    } else {
                        message = "No changes to property ''{0}'' on ''{1}''";
                        message = MessageFormat.format(message, propertyName, string);
                        this.getSVNEnvironment().getOut().println(message);
                    }
                }
                this.clearCollectedProperties();
            }
        }
    }
}

