/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.togglz.console.shade.jmte.util.MiniParser;
import org.togglz.console.shade.jmte.util.StartEndPair;

public class Util {
    public static final MiniParser MINI_PARSER = MiniParser.defaultInstance();
    public static final MiniParser RAW_MINI_PARSER = MiniParser.fullRawInstance();
    public static final MiniParser NO_QUOTE_MINI_PARSER = new MiniParser('\\', '\uffff', false, false, false);
    public static final MiniParser RAW_OUTPUT_MINI_PARSER = MiniParser.rawOutputInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stringToFile(String string, File file, String charsetName) {
        FileOutputStream fos = null;
        Writer writer = null;
        try {
            try {
                fos = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)fos, charsetName);
                writer.write(string);
            }
            finally {
                if (writer != null) {
                    writer.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(File file, String charsetName) {
        String string;
        block6: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                string = Util.streamToString(fileInputStream, charsetName);
                if (fileInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            fileInputStream.close();
        }
        return string;
    }

    public static String fileToString(String fileName, String charsetName) {
        return Util.fileToString(new File(fileName), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream is, String charsetName) {
        String string;
        block10: {
            Reader r = null;
            try {
                r = new BufferedReader(new InputStreamReader(is, charsetName));
                string = Util.readerToString(r);
                if (r == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                r.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return string;
    }

    public static String resourceToString(String resourceName, String charsetName) {
        InputStream templateStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        String template = Util.streamToString(templateStream, "UTF-8");
        return template;
    }

    public static String readerToString(Reader reader) {
        try {
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                sb.append(buf, 0, numRead);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] streamToBa(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int numRead = 0;
            while ((numRead = is.read(buf)) != -1) {
                baos.write(buf, 0, numRead);
            }
            byte[] byteArray = baos.toByteArray();
            return byteArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Object> arrayAsList(Object value) {
        List<Object> list = null;
        if (value instanceof int[]) {
            int[] array;
            list = new ArrayList<Object>();
            for (int i : array = (int[])value) {
                list.add(i);
            }
        } else if (value instanceof short[]) {
            short[] array;
            list = new ArrayList();
            for (short i : array = (short[])value) {
                list.add(i);
            }
        } else if (value instanceof char[]) {
            char[] array;
            list = new ArrayList();
            for (char i : array = (char[])value) {
                list.add(Character.valueOf(i));
            }
        } else if (value instanceof byte[]) {
            byte[] array;
            list = new ArrayList();
            for (byte i : array = (byte[])value) {
                list.add(i);
            }
        } else if (value instanceof long[]) {
            long[] array;
            list = new ArrayList();
            for (long i : array = (long[])value) {
                list.add(i);
            }
        } else if (value instanceof double[]) {
            double[] array;
            list = new ArrayList();
            for (double i : array = (double[])value) {
                list.add(i);
            }
        } else if (value instanceof float[]) {
            float[] array;
            list = new ArrayList();
            for (float i : array = (float[])value) {
                list.add(Float.valueOf(i));
            }
        } else if (value instanceof boolean[]) {
            boolean[] array;
            list = new ArrayList();
            for (boolean i : array = (boolean[])value) {
                list.add(i);
            }
        } else if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            list = Arrays.asList(array);
        }
        return list;
    }

    public static String trimFront(String input) {
        int i;
        for (i = 0; i < input.length() && Character.isWhitespace(input.charAt(i)); ++i) {
        }
        return input.substring(i);
    }

    public static List<StartEndPair> scan(String input, String splitStart, String splitEnd, boolean useEscaping) {
        int exprStart;
        ArrayList<StartEndPair> result = new ArrayList<StartEndPair>();
        int fromIndex = 0;
        while ((exprStart = input.indexOf(splitStart, fromIndex)) != -1) {
            if (useEscaping && Util.isEscaped(input, exprStart)) {
                fromIndex = exprStart + splitStart.length();
                continue;
            }
            int exprEnd = input.indexOf(splitEnd, exprStart += splitStart.length());
            if (exprEnd == -1) break;
            while (useEscaping && Util.isEscaped(input, exprEnd)) {
                exprEnd = input.indexOf(splitEnd, exprEnd + splitEnd.length());
            }
            fromIndex = exprEnd + splitEnd.length();
            StartEndPair startEndPair = new StartEndPair(exprStart, exprEnd);
            result.add(startEndPair);
        }
        return result;
    }

    static boolean isEscaped(String input, int index) {
        return Util.isEscaped(input, index, '\\');
    }

    static boolean isEscaped(String input, int index, char escapeCharacter) {
        int leftOfleftOfIndex;
        int leftOfIndex = index - 1;
        boolean escaped = leftOfIndex >= 0 ? (input.charAt(leftOfIndex) == escapeCharacter ? (leftOfleftOfIndex = leftOfIndex - 1) < 0 || input.charAt(leftOfleftOfIndex) != escapeCharacter : false) : false;
        return escaped;
    }

    public static <T> Set<T> asSet(T ... a) {
        return a != null ? new HashSet<T>(Arrays.asList(a)) : Collections.emptySet();
    }

    public static String unifyNewlines(String source) {
        String regex = "\\r?\\n";
        String clearedSource = source.replaceAll("\\r?\\n", "\n");
        return clearedSource;
    }
}

