/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.togglz.console.shade.jmte.util.MiniParser;

public final class NestedParser {
    private static final MiniParser MINI_PARSER = MiniParser.rawOutputInstance();
    private static final MiniParser INNER_MINI_PARSER = MiniParser.trimmedInstance();

    public static String access(List<? extends Object> ast, int index) {
        return NestedParser.access(ast, index, null);
    }

    public static String access(List<? extends Object> ast, int index, String defaultValue) {
        if (ast == null) {
            return defaultValue;
        }
        if (index < ast.size()) {
            Object object = ast.get(index);
            if (object instanceof String) {
                return (String)object;
            }
            throw new IllegalArgumentException("You can only access scalar strings");
        }
        return defaultValue;
    }

    public List<Object> parse(String input, List<String> operators) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (operators.size() != 0) {
            List<String> segments;
            boolean innerLoop = operators.size() == 1;
            MiniParser currentParser = innerLoop ? INNER_MINI_PARSER : MINI_PARSER;
            String operator = operators.get(0);
            if (operator.length() == 1) {
                segments = currentParser.split(input, operator.charAt(0));
            } else if (operator.length() == 2) {
                List<String> allSegments = currentParser.scan(input, String.valueOf(operator.charAt(0)), String.valueOf(operator.charAt(1)), true);
                if (allSegments.size() > 0) {
                    result.add(allSegments.get(0));
                }
                segments = allSegments.size() > 1 ? allSegments.subList(1, allSegments.size()) : Collections.emptyList();
            } else {
                throw new IllegalArgumentException("Operators must either be start/end pairs or single characters");
            }
            if (innerLoop) {
                result.addAll(segments);
            } else {
                for (String segment : segments) {
                    List<Object> parse = this.parse(segment, operators.subList(1, operators.size()));
                    if (parse.size() == 1 && parse.get(0) instanceof String) {
                        result.add(parse.get(0));
                        continue;
                    }
                    result.add(parse);
                }
            }
        }
        return result;
    }

    public List<Object> parse(String input, String[] operators) {
        return this.parse(input, Arrays.asList(operators));
    }
}

