/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.handlers.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandlerBase;
import org.togglz.console.handlers.index.IndexPageTab;
import org.togglz.console.handlers.index.IndexPageTabView;
import org.togglz.console.handlers.index.SanitizeHtmlRenderer;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.Services;
import org.togglz.servlet.spi.CSRFToken;
import org.togglz.servlet.spi.CSRFTokenProvider;

public class IndexPageHandler
extends RequestHandlerBase {
    @Override
    public boolean handles(String path) {
        return path.equals("/index");
    }

    @Override
    public boolean adminOnly() {
        return true;
    }

    @Override
    public void process(RequestEvent event) throws IOException {
        FeatureManager featureManager = event.getFeatureManager();
        Integer activeTabIndex = null;
        if (event.getRequest().getCookies() != null) {
            for (Cookie cookie : event.getRequest().getCookies()) {
                if (cookie.getName().compareTo("t") != 0 || cookie.getValue() == null || cookie.getValue().length() == 0) continue;
                activeTabIndex = Integer.parseInt(cookie.getValue());
            }
        }
        event.getResponse().addCookie(new Cookie("t", null));
        List strategies = featureManager.getActivationStrategies();
        IndexPageTabView tabView = new IndexPageTabView(strategies);
        for (Feature feature : featureManager.getFeatures()) {
            FeatureMetaData metadata = featureManager.getMetaData(feature);
            FeatureState featureState = featureManager.getFeatureState(feature);
            tabView.add(feature, metadata, featureState);
        }
        for (IndexPageTab indexPageTab : tabView.getTabs()) {
            if (activeTabIndex != null) {
                if (indexPageTab.getIndex() == activeTabIndex.intValue()) {
                    indexPageTab.setIsActive(true);
                    continue;
                }
                indexPageTab.setIsActive(false);
                continue;
            }
            if (indexPageTab.isAllTab()) {
                indexPageTab.setIsActive(true);
                continue;
            }
            indexPageTab.setIsActive(false);
        }
        ArrayList<CSRFToken> tokens = new ArrayList<CSRFToken>();
        for (CSRFTokenProvider provider : Services.get(CSRFTokenProvider.class)) {
            CSRFToken token = provider.getToken(event.getRequest());
            if (token == null) continue;
            tokens.add(token);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("tokens", tokens);
        hashMap.put("tabView", tabView);
        String template = this.getResourceAsString("index.html");
        Engine engine = new Engine();
        engine.registerNamedRenderer(new SanitizeHtmlRenderer());
        String content = engine.transform(template, hashMap);
        this.writeResponse(event, content);
    }
}

