/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class HazelcastStateRepository
implements StateRepository {
    protected final HazelcastInstance hazelcastInstance;
    protected final Config hazelcastConfig;
    protected final ClientConfig hazelcastClientConfig;
    protected final String mapName;

    public HazelcastStateRepository(Config hazelcastConfig, String mapName) {
        this.mapName = mapName;
        this.hazelcastConfig = hazelcastConfig;
        this.hazelcastClientConfig = null;
        this.hazelcastInstance = this.createHazelcastInstance();
    }

    public HazelcastStateRepository(ClientConfig hazelcastClientConfig, String mapName) {
        this.mapName = mapName;
        this.hazelcastConfig = null;
        this.hazelcastClientConfig = hazelcastClientConfig;
        this.hazelcastInstance = this.createHazelcastInstance();
    }

    public HazelcastStateRepository(HazelcastInstance hazelcastInstance, String mapName) {
        this.mapName = mapName;
        this.hazelcastConfig = null;
        this.hazelcastClientConfig = null;
        this.hazelcastInstance = hazelcastInstance;
    }

    private HazelcastStateRepository(Builder builder) {
        this.mapName = builder.mapName;
        this.hazelcastConfig = builder.hazelcastConfig;
        this.hazelcastClientConfig = builder.hazelcastClientConfig;
        this.hazelcastInstance = builder.hazelcastInstance != null ? builder.hazelcastInstance : this.createHazelcastInstance();
    }

    private HazelcastInstance createHazelcastInstance() {
        if (this.hazelcastClientConfig == null && this.hazelcastConfig == null) {
            return Hazelcast.newHazelcastInstance();
        }
        if (this.hazelcastClientConfig == null) {
            return Hazelcast.newHazelcastInstance((Config)this.hazelcastConfig);
        }
        return HazelcastClient.newHazelcastClient((ClientConfig)this.hazelcastClientConfig);
    }

    public FeatureState getFeatureState(Feature feature) {
        IMap map = this.hazelcastInstance.getMap(this.mapName);
        return (FeatureState)map.get((Object)feature);
    }

    public void setFeatureState(FeatureState featureState) {
        IMap map = this.hazelcastInstance.getMap(this.mapName);
        map.set((Object)featureState.getFeature(), (Object)featureState);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String mapName) {
        return new Builder(mapName);
    }

    public static class Builder {
        private String mapName = "togglz";
        private Config hazelcastConfig = null;
        private ClientConfig hazelcastClientConfig = null;
        private HazelcastInstance hazelcastInstance = null;

        public Builder() {
        }

        public Builder(String mapName) {
            this.mapName = mapName;
        }

        public Builder(Config hazelcastConfig) {
            this.hazelcastConfig = hazelcastConfig;
        }

        public Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public Builder config(Config hazelcastConfig) {
            this.hazelcastConfig = hazelcastConfig;
            return this;
        }

        public Builder clientConfig(ClientConfig hazelcastClientConfig) {
            this.hazelcastClientConfig = hazelcastClientConfig;
            return this;
        }

        public Builder hazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
            return this;
        }

        public HazelcastStateRepository build() {
            this.checkStateOfWhatIsSet();
            return new HazelcastStateRepository(this);
        }

        private void checkStateOfWhatIsSet() {
            int countOfWhatIsSet = 0;
            if (this.hazelcastClientConfig != null) {
                ++countOfWhatIsSet;
            }
            if (this.hazelcastConfig != null) {
                ++countOfWhatIsSet;
            }
            if (this.hazelcastInstance != null) {
                ++countOfWhatIsSet;
            }
            if (countOfWhatIsSet > 1) {
                throw new IllegalStateException("Please only configure exactly one of hazelcastClientConfig, hazelcastConfig, or hazelcastInstance");
            }
        }
    }
}

