/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.junit;

import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.util.NamedFeature;
import org.togglz.core.util.Validate;
import org.togglz.junit.WithFeature;
import org.togglz.junit.vary.VariationSetBuilder;
import org.togglz.testing.TestFeatureManager;
import org.togglz.testing.TestFeatureManagerProvider;

public class TogglzRule
implements TestRule {
    private static final Log log = LogFactory.getLog(TogglzRule.class);
    private final Class<? extends Feature> featureClass;
    private final Set<Set<Feature>> variants;
    private TestFeatureManager featureManager;

    public static Builder builder(Class<? extends Feature> featuresClass) {
        return new Builder(featuresClass);
    }

    public static TogglzRule allEnabled(Class<? extends Feature> featureClass) {
        return TogglzRule.builder(featureClass).enableAll().build();
    }

    public static TogglzRule allDisabled(Class<? extends Feature> featureClass) {
        return TogglzRule.builder(featureClass).disableAll().build();
    }

    private TogglzRule(Class<? extends Feature> featureEnum, Set<Set<Feature>> variants) {
        Validate.notNull(featureEnum, (String)"The featureEnum argument is required");
        Validate.isTrue((boolean)featureEnum.isEnum(), (String)"This class only works with feature enums");
        this.featureClass = featureEnum;
        this.variants = variants;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    if (TogglzRule.this.featureManager != null) {
                        throw new IllegalStateException("Found existing TestFeatureManager");
                    }
                    WithFeature withFeature = (WithFeature)description.getAnnotation(WithFeature.class);
                    for (Set activeFeatures : TogglzRule.this.variants) {
                        TogglzRule.this.featureManager = new TestFeatureManager(TogglzRule.this.featureClass);
                        for (Feature feature : activeFeatures) {
                            TogglzRule.this.featureManager.enable(feature);
                        }
                        TestFeatureManagerProvider.setFeatureManager((FeatureManager)TogglzRule.this.featureManager);
                        FeatureContext.clearCache();
                        if (withFeature != null) {
                            if (TogglzRule.this.variants.size() == 1) {
                                for (String featureName : withFeature.value()) {
                                    NamedFeature feature = new NamedFeature(featureName);
                                    if (withFeature.disable()) {
                                        TogglzRule.this.disable((Feature)feature);
                                        continue;
                                    }
                                    TogglzRule.this.enable((Feature)feature);
                                }
                            } else {
                                log.info("Ignoring @ViewFeature because the rule defines feature variations");
                            }
                        }
                        base.evaluate();
                    }
                }
                finally {
                    TogglzRule.this.featureManager = null;
                    TestFeatureManagerProvider.setFeatureManager(null);
                    FeatureContext.clearCache();
                }
            }
        };
    }

    public TestFeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public void disable(Feature feature) {
        this.featureManager.disable(feature);
    }

    public void enable(Feature feature) {
        this.featureManager.enable(feature);
    }

    public void enableAll() {
        this.featureManager.enableAll();
    }

    public void disableAll() {
        this.featureManager.disableAll();
    }

    public static class Builder {
        private final Class<? extends Feature> featuresClass;
        private final VariationSetBuilder<Feature> variationSetBuilder;

        public Builder(Class<? extends Feature> featuresClass) {
            this.featuresClass = featuresClass;
            this.variationSetBuilder = VariationSetBuilder.create(featuresClass);
        }

        public Builder enable(Feature f) {
            this.variationSetBuilder.enable(f);
            return this;
        }

        public Builder enableAll() {
            this.variationSetBuilder.enableAll();
            return this;
        }

        public Builder disable(Feature f) {
            this.variationSetBuilder.disable(f);
            return this;
        }

        public Builder disableAll() {
            this.variationSetBuilder.disableAll();
            return this;
        }

        public Builder vary(Feature f) {
            this.variationSetBuilder.vary(f);
            return this;
        }

        public TogglzRule build() {
            return new TogglzRule(this.featuresClass, this.variationSetBuilder.getVariants());
        }
    }
}

