/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.junit.vary;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.togglz.core.Feature;
import org.togglz.junit.vary.VariationRunner;
import org.togglz.junit.vary.VariationSetBuilder;
import org.togglz.junit.vary.Variations;

public class FeatureVariations
extends Suite {
    protected List<Runner> runners = new ArrayList<Runner>();

    public FeatureVariations(Class<?> clazz) throws InitializationError {
        super(clazz, Collections.emptyList());
        TestClass testClass = new TestClass(clazz);
        VariationSetBuilder<? extends Feature> permutation = this.getPermutationFromMethod(testClass);
        if (permutation == null) {
            throw new IllegalStateException("You have to place a @" + Variations.class.getSimpleName() + " annotation one the class: " + clazz.getName());
        }
        for (Set<? extends Feature> activeFeatures : permutation.getVariants()) {
            this.runners.add((Runner)new VariationRunner(clazz, permutation.getFeatureClass(), activeFeatures));
        }
    }

    private VariationSetBuilder<? extends Feature> getPermutationFromMethod(TestClass testClass) {
        List methods = testClass.getAnnotatedMethods(Variations.class);
        for (FrameworkMethod method : methods) {
            int modifiers = method.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            try {
                return (VariationSetBuilder)method.invokeExplosively(null, new Object[0]);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Could not find public static method annotated with @" + Variations.class.getSimpleName() + " on class: " + testClass.getName());
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }
}

