/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.junit.vary;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.util.Validate;
import org.togglz.junit.vary.VariationSet;

public class VariationSetBuilder<F extends Feature>
implements VariationSet<F> {
    private final Class<F> featureClass;
    private final Set<F> featuresToVary = new HashSet<F>();
    private final Set<F> featuresToEnable = new HashSet<F>();
    private final Set<F> featuresToDisable = new HashSet<F>();

    public static <F extends Feature> VariationSetBuilder<F> create(Class<F> featureClass) {
        return new VariationSetBuilder<F>(featureClass);
    }

    private VariationSetBuilder(Class<F> featureEnum) {
        Validate.notNull(featureEnum, (String)"The featureEnum argument is required");
        Validate.isTrue((boolean)featureEnum.isEnum(), (String)"This class only works with feature enums");
        this.featureClass = featureEnum;
    }

    public VariationSetBuilder<F> vary(F f) {
        this.featuresToVary.add(f);
        this.featuresToEnable.remove(f);
        this.featuresToDisable.remove(f);
        return this;
    }

    public VariationSetBuilder<F> enable(F f) {
        this.featuresToVary.remove(f);
        this.featuresToEnable.add(f);
        this.featuresToDisable.remove(f);
        return this;
    }

    public VariationSetBuilder<F> disable(F f) {
        this.featuresToVary.remove(f);
        this.featuresToEnable.remove(f);
        this.featuresToDisable.add(f);
        return this;
    }

    public VariationSetBuilder<F> enableAll() {
        for (Feature f : (Feature[])this.featureClass.getEnumConstants()) {
            this.enable(f);
        }
        return this;
    }

    public VariationSetBuilder<F> disableAll() {
        for (Feature f : (Feature[])this.featureClass.getEnumConstants()) {
            this.disable(f);
        }
        return this;
    }

    @Override
    public Set<Set<F>> getVariants() {
        LinkedHashSet<Set<F>> variantSet = new LinkedHashSet<Set<F>>();
        variantSet.add(new HashSet());
        for (Feature feature : (Feature[])this.featureClass.getEnumConstants()) {
            if (this.featuresToEnable.contains(feature)) {
                for (Set set : variantSet) {
                    set.add(feature);
                }
                continue;
            }
            if (this.featuresToDisable.contains(feature)) {
                for (Set set : variantSet) {
                    set.remove(feature);
                }
                continue;
            }
            if (!this.featuresToVary.contains(feature)) continue;
            Set<Set<F>> copy = this.deepCopy(variantSet);
            for (Set<F> variant : copy) {
                variant.add(feature);
            }
            variantSet.addAll(copy);
        }
        return variantSet;
    }

    private Set<Set<F>> deepCopy(Set<Set<F>> src) {
        HashSet<Set<F>> copy = new HashSet<Set<F>>();
        for (Set<F> variant : src) {
            copy.add(new HashSet<F>(variant));
        }
        return copy;
    }

    public Class<? extends Feature> getFeatureClass() {
        return this.featureClass;
    }
}

